extends World

#signal scene_ended

@onready var map: TBLoader = $NavigationRegion3D/Map
@onready var exit_trigger: Area3D = $map_externals/exit_trigger
var total_enemies: int
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_exit_triggered: bool = false
var is_scene_endable: bool = false
var keep_player_inventory: bool = false

var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")

func _ready():
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	if keep_player_inventory and not Global.prop_table["slot_manager_cache"].is_empty():
		U.grptop("players").load_saved_inventory()
	
	var grandpa: CharacterBody3D = $civ_container/sleepy_clinic_grandpa
	var grandpa_anim: AnimationPlayer = $civ_container/sleepy_clinic_grandpa/model/AnimationPlayer
	grandpa_anim.play("die1")
	await grandpa_anim.animation_finished
	grandpa.process_mode = PROCESS_MODE_DISABLED
	
	for enemy_group in ["punks", "mooks"]:
		total_enemies += len(get_tree().get_nodes_in_group(enemy_group))
	
	#self.connect("child_entered_tree", _child_entered_tree)
	exit_trigger.connect("body_entered", _body_entered_exit_trigger)
	return

func _physics_process(delta):
	total_time += delta
	if is_exit_triggered and is_scene_endable and Input.is_anything_pressed():
		#Engine.time_scale = 1.0
		var exit_fade_time: float = .25 # 1.0
		var fade_speed: float = 1 / exit_fade_time
		U.fade_out_screen(self, fade_speed)

		await get_tree().create_timer(exit_fade_time).timeout
		scene_ended.emit()
	return

#func _child_entered_tree(node):
	#prints(self.name, ":", "Child entered tree:", node, node.name)
	#
	#var node_ident: String = node.scene_file_path
	#if node_ident not in debug_store["node_counter"]:
		#debug_store["node_counter"][node_ident] = 0
	#
	#debug_store["node_counter"][node_ident] += 1
	#
	#print(debug_store["node_counter"])
	#return
func _body_entered_exit_trigger(body: Node3D):
	if is_exit_triggered:
		return
	
	if body and body.is_in_group("players"):
		is_exit_triggered = true
		$map_externals/exit_camera.make_current()
		$map_externals/exit_camera.get_node("AnimationPlayer").play("main_alternate")
		$map_externals/exit_music.play()
		$map_externals/exit_music.get_node("AnimationPlayer").play("main")
		
		var intermission_loop: Node3D = intermission_loop_scene.instantiate()
		$map_externals/intermission_fader/SubViewport.add_child(intermission_loop)
		$map_externals/intermission_fader/intermission_fader_anim.process_mode = Node.PROCESS_MODE_INHERIT
		$map_externals/intermission_fader/intermission_fader_anim.play("fade_in")
		Engine.time_scale = 0.3
		
		var enemies_alive: int = 0
		for enemy_group in ["mooks", "punks"]:
			for enemy in get_tree().get_nodes_in_group(enemy_group):
				if not enemy.is_dead:
					enemies_alive += 1
		
		var total_kills: String = str(total_enemies - enemies_alive)
		var credits_amount: String = str(Global.prop_table["credits"][get_tree().get_first_node_in_group("players").offline_id])
		$map_externals/exit_screen/Label_Kills.text = "KILLS: " + total_kills + " / " + str(total_enemies)
		$map_externals/exit_screen/Label_Time.text = "TIME: " + str(snappedf(total_time, 0.1))
		$map_externals/exit_screen/Label_Credits.text = "CREDS: " + credits_amount
		$map_externals/exit_screen/Label_Time.visible = true
		$map_externals/exit_screen/Label_Kills.visible = true
		$map_externals/exit_screen/Label_Credits.visible = true
		
		for player in get_tree().get_nodes_in_group("players"):
			player.trigger_exit_mode()
		
		#await get_tree().create_timer(2.0).timeout
		await get_tree().create_timer(0.8).timeout
		is_scene_endable = true
	return

func fade_out():
	#$ColorRect/AnimationPlayer.speed_scale *= 3
	#$ColorRect/AnimationPlayer.play("fade_out")
	var fade_time: float = 0.1 #0.8
	get_tree().create_tween().tween_property(
		$Node3D/AudioStreamPlayer3D,
		"volume_db",
		-200,
		fade_time
	)
	await get_tree().create_timer(
		$ColorRect/AnimationPlayer.get_animation("fade_out").length
	).timeout
	#scene_ended.emit()
	return
