extends World
# TODO:
# x Spawn cultist grunts after grabbing the painting
# - Put something in NARDBAR to make it worth visiting (need or want)
# - Set up level exit trigger
# - Test for performance


@onready var map: TBLoader = $NavigationRegion3D/Map
#@onready var exit_trigger: Area3D = $map_externals/exit_trigger
@onready var prop_trucked_biker: Node3D = $NavigationRegion3D/map_externals/prop_mook_biker
@onready var exit_screen: Control = $EXIT/exit_screen
var total_enemies: int
var expected_enemy_groups: Array = ["mooks", "punks", "burglars", "clowns_freeling", "wiseguys", "cultists"]
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_exit_triggered: bool = false
var is_scene_endable: bool = false

var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")
var is_weird_flask_gone: bool = false
var study_wall_raised: bool = false
var is_curio_painting_gone: bool = false
var full_init: bool = false

var exit_camera_index: int = 0
var is_exit_camera_flickering: bool = false
var is_exit_screen_jittering: bool = false
var exit_camera_delta: float = 0.0
var exit_camera_interval: float = 0.005
var keep_player_inventory: bool = true

var cultist_grunt_late_spawn_y_offset: float = 100.0

#func _enter_tree() -> void:
	#$EXIT/exit_area.process_mode = Node.PROCESS_MODE_DISABLED
	#return

func _ready():
	for enemy_group in expected_enemy_groups:
		total_enemies += len(get_tree().get_nodes_in_group(enemy_group))
	
	$EXIT/exit_area.process_mode = Node.PROCESS_MODE_DISABLED
	
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	if keep_player_inventory and not Global.prop_table["slot_manager_cache"].is_empty():
		U.grptop("players").load_saved_inventory()
		U.grptop("players").load_life_state()
	
	hide_cultist_grunts()
	
	var biker_anim: AnimationPlayer = prop_trucked_biker.get_node("AnimationPlayer")
	biker_anim.assigned_animation = "die_heavy_1"
	biker_anim.seek(.4)
	
	await get_tree().create_timer(.5).timeout
	full_init = true
	
	await get_tree().create_timer(3.0).timeout
	for x in [$map_externals_nonav/apartment/tv, $map_externals_nonav/apartment/radio, $map_externals_nonav/apartment/radio_2]:
		if x.name == "tv":
			$map_externals_nonav/apartment/tv_screen_test.visible = true
		get_tree().create_tween().tween_property(x, "volume_db", 0.0, .2)
		await get_tree().create_timer(randf_range(.9, 3.2)).timeout
	return

func _physics_process(delta):
	if not full_init: return
	
	if not is_exit_triggered:
		total_time += delta
	if is_scene_endable and Input.is_anything_pressed():
		scene_ended.emit()
	
	if is_exit_screen_jittering:
		exit_screen.position.x = randf_range(-1.0, 1.0)
		exit_screen.position.y = randf_range(-1.4, 2.4)
	
	if is_exit_camera_flickering:
		exit_camera_delta += delta
		if exit_camera_delta >= exit_camera_interval:
			exit_camera_delta = 0.0
		
			var exit_cameras: Array = get_tree().get_nodes_in_group("exit_cameras")
			exit_cameras[exit_camera_index].make_current()
			exit_camera_index += 1
			if exit_camera_index > (exit_cameras.size() - 1):
				exit_camera_index = 0
	
	if not is_weird_flask_gone and not get_tree().get_first_node_in_group("weird_flask"):
		is_weird_flask_gone = true
		$WorldEnvironment/AnimationPlayer.play("loop_weird")
	
	if not is_curio_painting_gone:
		var world_curios: Array = get_tree().get_nodes_in_group("curios")
		is_curio_painting_gone = len(world_curios) == 0
	
	if not study_wall_raised and is_curio_painting_gone:
		# INTERP!!!!!!!
		get_tree().create_tween().tween_property(
			$NavigationRegion3D/Map/study_moving_wall,
			"global_position:y",
			25.18,
			3.0
		).set_trans(Tween.TRANS_SINE)
		$NavigationRegion3D/map_externals/study_area/study_wall_move_sound.play()
		for speaker in $NavigationRegion3D/map_externals/study_area/nosferatu_speakers.get_children():
			speaker.play()
		study_wall_raised = true
		show_cultist_grunts()
		
		var outside_speaker_stream: AudioStream = $NavigationRegion3D/map_externals/bar_area/speakers/nard_bar_outside_speaker_1.stream
		for speaker in $NavigationRegion3D/map_externals/bar_area/speakers.find_children("nard_bar_inside_speaker*"):
			speaker.stream = outside_speaker_stream
		for speaker in $NavigationRegion3D/map_externals/bar_area/speakers.find_children("nard_bar_outside_speaker*"):
			speaker.play()
		
		$EXIT/exit_light_local.visible = true
		$EXIT/exit_area.process_mode = Node.PROCESS_MODE_INHERIT
		
	return

func hide_cultist_grunts():
	$enemy_container/cultist_grunts_spawned.global_position.y -= cultist_grunt_late_spawn_y_offset
	for n in get_tree().get_nodes_in_group("cultist_grunt_late_spawn"):
		n.visible = false
		n.process_mode = Node.PROCESS_MODE_DISABLED
	return

func show_cultist_grunts():
	$enemy_container/cultist_grunts_spawned.global_position.y += cultist_grunt_late_spawn_y_offset
	for n in get_tree().get_nodes_in_group("cultist_grunt_late_spawn"):
		n.process_mode = Node.PROCESS_MODE_INHERIT
		n.visible = true
	return


#func _on_exit_area_body_entered(body: Node3D) -> void:
	#prints("#####", self.name, body)
	#if not body.is_in_group("players"):
		#return
	#
	#var player: Node3D = U.grptop("players")
	#player.trigger_exit_mode()
	#self.trigger_exit()
	#return

func trigger_exit():
	trigger_exit_canvas()
	Engine.time_scale = .6
	$EXIT/exit_music.play()
	var cam_i: int = 1
	for cam in get_tree().get_nodes_in_group("exit_cameras"):
		if cam_i > 1:
			cam.get_node("AnimationPlayer").play("drive_by_2")
		else:
			cam.get_node("AnimationPlayer").play("drive_by")
		cam_i += 1
	is_exit_camera_flickering = true
	is_exit_screen_jittering = true
	
	await get_tree().create_timer(1.0).timeout
	is_scene_endable = true
	return



func _on_exit_area_body_entered(body: Node3D) -> void:
	prints("#####", self.name, body)
	if not body.is_in_group("players"):
		return
	
	var player: Node3D = U.grptop("players")
	player.trigger_exit_mode()
	self.trigger_exit()
	return

func trigger_exit_canvas():
	exit_screen.visible = true
	var enemies_alive: int = 0
	for enemy_group in expected_enemy_groups:
		for enemy in get_tree().get_nodes_in_group(enemy_group):
			if not enemy.is_dead:
				enemies_alive += 1
	
	var total_kills: String = str(total_enemies - enemies_alive)
	var credits_amount: String = "0"
	if Global.prop_table["credits"].has(get_tree().get_first_node_in_group("players").offline_id):
		credits_amount = str(Global.prop_table["credits"][get_tree().get_first_node_in_group("players").offline_id])
	#var exit_screen: Control = $External/Exit/exit_screen
	exit_screen.get_node("Label_Kills").text = "KILLS: " + total_kills + " / " + str(total_enemies)
	exit_screen.get_node("Label_Time").text = "TIME: " + str(snappedf(total_time, 0.1))
	exit_screen.get_node("Label_Credits").text = "CREDS: " + credits_amount
	
	exit_screen.get_node("Label_Time").visible = true
	exit_screen.get_node("Label_Kills").visible = true
	exit_screen.get_node("Label_Credits").visible = true
	return
