@tool
extends TBLoader

@export var run_post_build: bool = false :
	get:
		return run_post_build
	set(value):
		_post_build_init()
		run_post_build = false

@export var custom_build: bool = false :
	get:
		return custom_build
	set(value):
		_build_wrapper()
		custom_build = false

func _build_wrapper():
	print("Custom build: START")
	self.build_meshes()
	await get_tree().process_frame
	_post_build_init()
	print("Custom build: FINISHED")
	return

func _kill_doors():
	return

func _post_build_init():
	if not Engine.is_editor_hint(): return
	
	var children_to_remove: Array
	var doorswingers: Array = []
	var doorhinges: Array = []
	for child in self.get_children():
		if "_editor_ready" in child:
			child._editor_ready()
		
		if child.name.contains("-alphatex") or "alpha_texture" in child:
		#if child.name.contains("alphatex"):
			
			for alpha_child in child.get_children():
				if not is_instance_of(alpha_child, MeshInstance3D):
					continue
				var alpha_mesh: MeshInstance3D = alpha_child
				
				set_mesh_materials_alpha(alpha_mesh)
				#alpha_mesh.get_active_material(0).transparency = 1
		if child.name.contains("-scrolltex"):
			var material_scroller: Node = preload("res://Scenes/material_scroller.tscn").instantiate()
			child.add_child(material_scroller)
			material_scroller.owner = get_tree().edited_scene_root
		if child.name.contains("-nocol"):
			for subchild in child.get_children():
				if is_instance_of(subchild, StaticBody3D):
					subchild.queue_free()
		if child.name.contains("-fullbright"):
			for fullbright_child in child.get_children():
				if not is_instance_of(fullbright_child, MeshInstance3D):
					continue
				var fullbright_mesh: MeshInstance3D = fullbright_child
				
				set_mesh_materials_unshaded(fullbright_mesh)
				#alpha_mesh.get_active_material(0).transparency = 1
		if child.name.contains("-ignore"):
			children_to_remove.append(child)
		
		if child.name.contains("-doorswinger"):
			doorswingers.append(child)
		if child.name.contains("-doorhinge"):
			doorhinges.append(child)
		if child.name.contains("-doorlocked"):
			for door_child in child.get_children():
				if is_instance_of(door_child, StaticBody3D):
					door_child.set_script(load("res://Scripts/doorswinger_hinge_child.gd"))
					door_child.is_locked = true
					break
		if child.name.contains("-bottleitem"):
			var bottle_colliders: Array = child.find_children("*", "StaticBody3D")
			#var mesh_candidates: Array = child.find_children("*", "MeshInstance3D")
			#var bottle_mesh: MeshInstance3D = mesh_candidates[0] if mesh_candidates else null
			for bottle_collider in bottle_colliders:
				bottle_collider.set_script(load("res://Scripts/bottle_item.gd"))
		#### PHYS
		#### You've tried this twice.
		#### You forgot about the first time and ran into the same problem.
		#### The mesh from the colshape is concave and only works on static
		#if child.name.contains("-physrigid"):
			## Create rigid body
			#var physbody: RigidBody3D = RigidBody3D.new()
			#child.add_child(physbody)
			#physbody.name = "physrigid"
			#physbody.owner = get_tree().edited_scene_root
			#physbody.global_position = child.global_position
			#var colshape_parents: Array = []
			#var colshapes: Array = child.find_children("*CollisionShape3D*")
			#for colshape in colshapes:
				#prints(self.name, "Colshape:", colshape, "|", colshape.owner)
				#colshape_parents.append(colshape.get_parent())
				#colshape.reparent(physbody)
				#colshape.owner = get_tree().edited_scene_root
			#for colshape_parent in colshape_parents:
				#prints(self.name, "Colshape parent:", colshape_parent, "|", colshape_parent.owner)
				#colshape_parent.queue_free()

	###
	# LESSON LEARNED:
	# I had many doors "disappearing" when opening. They were getting hinged to nodes far away from them.
	# The cause of the problem was I had deleted a door but left the hinge. The hinge doesn't care how close
	# the door is, only that it's the closest door available in the array.
	# TODO
	# At least include a warning that the hinged door is above a given distance threshold.
	
	var doorswinger_parentings: Dictionary = {}
	for hinge in doorhinges:
		var hinge_prefix: String = hinge.name.replace("-", "_").split("_")[0]
		var closest_door: Node3D
		var closest_door_distance: float
		if not doorswingers:
			print("Cannot hinge door " + hinge.name + ", no doors left in array.")
			break # Should be continue but I know the array will stay empty
		for door in doorswingers:
			var door_prefix: String = door.name.replace("-", "_").split("_")[0]
			if door_prefix == hinge_prefix:
				closest_door = door
				break
			var door_distance: float = hinge.global_position.distance_to(door.global_position)
			#prints(self.name, "DOOR DISTANCE:", door_distance)
			if not closest_door_distance:
				closest_door = door
				closest_door_distance = door_distance
				continue
			if door_distance < closest_door_distance:
				closest_door = door
				closest_door_distance = door_distance
				continue
		
		prints(self.name, "Reparenting closest door:", closest_door, " to hinge:", hinge, "distance:", closest_door_distance)
		if not doorswinger_parentings.has(closest_door.name):
			doorswinger_parentings[closest_door.name] = 0
		doorswinger_parentings[closest_door.name] += 1
		closest_door.reparent(hinge)
		closest_door.owner = get_tree().edited_scene_root
		
		var door_collider: StaticBody3D
		for c in closest_door.find_children("*", "", true, false):
			c.owner = get_tree().edited_scene_root
			if not door_collider and is_instance_of(c, StaticBody3D):
				door_collider = c
				door_collider.set_script(load("res://Scripts/doorswinger_hinge_child.gd"))
		
		doorswingers.erase(closest_door)
	
	prints(self.name, "# Hinge child count")
	for hinge in doorhinges:
		prints(self.name, hinge, "count:", len(hinge.find_children("*doorswinger*")))
	
	prints(self.name, "# Door reparent count")
	prints(self.name, doorswinger_parentings)
	
	for child in children_to_remove:
		child.queue_free()

	return


func set_mesh_materials_alpha(mesh: MeshInstance3D):
	for i in range(mesh.mesh.get_surface_count()):
		var current_material: Material = mesh.get_active_material(i)
		if current_material == null:
			return
		current_material.transparency = 1
		#alpha_mesh.get_active_material(0).transparency = 1
	return

func set_mesh_materials_unshaded(mesh: MeshInstance3D):
	for i in range(mesh.mesh.get_surface_count()):
		var current_material: Material = mesh.get_active_material(i)
		if current_material == null:
			return
		current_material.shading_mode = 0
	return
