extends World

@onready var clerk_jenny: CharacterBody3D = $Actors/clerk_jenny
@onready var noko: CharacterBody3D = $noko_actor

var is_player_inside_shop: bool = false
var is_player_at_counter: bool = false
var is_noko_sara_call_ended: bool = false

var clerk_tick_interval: float = .05
var accumulated_clerk_tick: float = 0.0
var current_fog_amount: float = 0.0
const NO_FOG_DISTANCE: float = 25.0
const MIN_FOG_AMOUNT: float = 0.0014 # 0.0
const THICK_FOG_AMOUNT: float = 0.05

var is_player_ever_entered_store: bool = false
var is_player_greeted: bool = false
var is_player_started_speak_sequence: bool = false
var is_speak_sequence_finished: bool = false
var time_since_player_left: float = 0.0
var time_inside_store: float = 0.0

@onready var world_environment: WorldEnvironment = $WorldEnvironment

func _ready():
	return

func _physics_process(delta: float) -> void:
	accumulated_clerk_tick += delta
	if accumulated_clerk_tick > clerk_tick_interval:
		accumulated_clerk_tick = 0.0
		clerk_control()
		fog_control()
	
	if is_player_ever_entered_store and not is_player_inside_shop:
		time_since_player_left += delta
	if is_player_inside_shop and time_since_player_left > 0.0:
		time_since_player_left = 0.0
	
	if is_player_inside_shop:
		time_inside_store += delta
	if not is_player_inside_shop and time_inside_store > 0.0:
		time_inside_store = 0.0
	
	if $External/Payphone/payphone_spotlight.visible:
		$External/Payphone/payphone_spotlight.light_energy = randf_range(9.0, 9.577)
	return

func clerk_control() -> void:
	if is_player_inside_shop and not is_player_greeted:
		is_player_greeted = true
		
	return

func _on_shop_entry_body_entered(body: Node3D) -> void:
	if not is_instance_of(body, CharacterBody3D):
		return
	if not body.is_in_group("players"):
		return
	
	is_player_inside_shop = true
	var player: PhysicsBody3D = body
	if not is_player_ever_entered_store:
		get_tree().create_tween().tween_callback(
			func ():
				clerk_jenny.greet(player)
		).set_delay(
			randf_range(0.6, 1.1)
		)
		
	
	is_player_ever_entered_store = true
	
	if time_since_player_left > 0.0 and time_since_player_left < 18_000:
		get_tree().create_tween().tween_callback(
			func ():
				clerk_jenny.greet_again(player)
		).set_delay(
			randf_range(0.6, 1.1)
		)
	return


func _on_shop_entry_body_exited(body: Node3D) -> void:
	if not is_instance_of(body, CharacterBody3D):
		return
	if not body.is_in_group("players"):
		return
	
	is_player_inside_shop = false
	var player: PhysicsBody3D = body
	if time_inside_store > 15.0:
		clerk_jenny.farewell(player)
	return

func fog_control() -> void:
	var closest_fog_dist: float = -1.0
	var player: PhysicsBody3D = get_tree().get_first_node_in_group("players")
	for fog_point in $External/Fogpoints.get_children():
		var player_fog_dist: float = fog_point.global_position.distance_to(player.global_position)
		if closest_fog_dist < 0.0:
			closest_fog_dist = player_fog_dist
			continue
		if player_fog_dist < closest_fog_dist:
			closest_fog_dist = player_fog_dist
			continue
	
	var fog_dist_ratio: float = clampf(closest_fog_dist, 0.0, NO_FOG_DISTANCE) / NO_FOG_DISTANCE
	#current_fog_amount = MIN_FOG_AMOUNT
	current_fog_amount = lerpf(THICK_FOG_AMOUNT, MIN_FOG_AMOUNT, fog_dist_ratio)
	$WorldEnvironment.environment.fog_density = current_fog_amount
	return


func _on_shop_counter_area_body_entered(body: Node3D) -> void:
	if not is_instance_of(body, CharacterBody3D):
		return
	if not body.is_in_group("players"):
		return
	
	is_player_at_counter = true
	if not is_player_started_speak_sequence:
		is_player_started_speak_sequence = true
		noko.sequence_speak_trigger("sequence_healersmokes", 0)
		$External/Payphone/payphone_flickerlight.process_mode = Node.PROCESS_MODE_DISABLED
		$External/Payphone/payphone_flickerlight.visible = false
		$External/Payphone/payphone_spotlight.visible = true
		$External/Payphone/payphone.is_paid = true
	return


func _on_shop_counter_area_body_exited(body: Node3D) -> void:
	if not is_instance_of(body, CharacterBody3D):
		return
	if not body.is_in_group("players"):
		return
	
	is_player_at_counter = false
	if is_player_started_speak_sequence and not is_speak_sequence_finished:
		noko.stop_speak()
		clerk_jenny.stop_speak()
	return

func _speak_sequence_ended(finished_sequence_name: String) -> void:
	if finished_sequence_name == "sequence_healersmokes":
		is_speak_sequence_finished = true
	return

func fade_in_environment(fade_time: float = .6) -> float:
	get_tree().create_tween().tween_property(
		$WorldEnvironment.environment,
		"tonemap_exposure",
		1.0,
		fade_time
	)
	return fade_time

func fade_out_environment(fade_time: float = .6) -> float:
	get_tree().create_tween().tween_property(
		$WorldEnvironment.environment,
		"tonemap_exposure",
		0.0,
		fade_time
	)
	return fade_time


func _on_payphone_custom_audio_ended(audio_name: Variant) -> void:
	if is_noko_sara_call_ended:
		return
	if audio_name.contains("healerphone_effects_combined_noko_and_sara"):
		activate_end_scene()
	return

#n.speak_sequence_triggered(next_sequence_index)
func speak_sequence_triggered(sequence_name: String, sequence_index: int) -> void:
	if not sequence_name == "sequence_healersmokes":
		return
	match sequence_index:
		0: # Hey, smokes
			return
		1: # Sure, $1.93
			clerk_jenny.is_adding_to_counter = true
			$External/counter_items/smokes.visible = true
			await get_tree().create_timer(1.0).timeout
			clerk_jenny.is_adding_to_counter = false
			return
		2: # Change too?
			return
		3: # Uhh, yep here you go
			clerk_jenny.is_checking_register = true
			$External/anim_sequencer.play("jenny_check_register")
			$External/cash_register/AnimationPlayer.play("open_drawer")
			await get_tree().create_timer(3.2).timeout
			$External/counter_items/coinpile.visible = true
			$External/counter_items/coinpile/coinsound.play()
			clerk_jenny.is_checking_register = false
			$External/cash_register/AnimationPlayer.play("close_drawer")
			return
		4: # Thanks
			$External/counter_items/coinpile.visible = false
			$External/counter_items/smokes.visible = false
			return
	return

func activate_end_scene() -> void:
	fade_out_environment(.8)
	await get_tree().create_timer(1.4).timeout
	scene_ended.emit()
	return
