@tool
extends TBLoader

@export var run_post_build: bool = false :
	get:
		return run_post_build
	set(value):
		_post_build_init()
		run_post_build = false

@export var custom_build: bool = false :
	get:
		return custom_build
	set(value):
		_build_wrapper()
		custom_build = false

func _ready() -> void:
	if not Engine.is_editor_hint():
		live_init()
		
	return

func _build_wrapper():
	print("Custom build: START")
	self.build_meshes()
	await get_tree().process_frame
	_post_build_init()
	print("Custom build: FINISHED")
	return

func _post_build_init():
	if not Engine.is_editor_hint(): return
	
	var children_to_remove: Array
	var doorswingers: Array = []
	var doorhinges: Array = []
	for child in self.get_children():
		if "_editor_ready" in child:
			child._editor_ready()
		
		## This glow thing didn't work
		## Partly because grouping a light in TB splits it on generate
		## so the OmniLight is a separate node
		#if child.name.contains("-glow"):
			#var glow_anim: AnimationPlayer = load("res://Scenes/light_glow_anim.tscn").instantiate()
			#child.add_child(glow_anim)
			#glow_anim.owner = get_tree().edited_scene_root
		
		if child.name.contains("-glow"):
			var light_candidates: Array = self.find_children("*OmniLight3D*")
			for light_candidate in light_candidates:
				if light_candidate.global_position.distance_to(child.global_position) < 9:
					var glow_anim: AnimationPlayer = load("res://Scenes/light_glow_anim.tscn").instantiate()
					light_candidate.add_child(glow_anim)
					glow_anim.owner = get_tree().edited_scene_root
		
		if child.name.contains("-breaktex"):
			var brush_colliders: Array = child.find_children("*", "StaticBody3D")
			#var mesh_candidates: Array = child.find_children("*", "MeshInstance3D")
			#var bottle_mesh: MeshInstance3D = mesh_candidates[0] if mesh_candidates else null
			for brush_collider in brush_colliders:
				brush_collider.set_script(load("res://Scripts/breaktex_tb.gd"))
		
		if child.name.contains("-alphatex") or "alpha_texture" in child:
		#if child.name.contains("alphatex"):
			
			for alpha_child in child.get_children():
				if not is_instance_of(alpha_child, MeshInstance3D):
					continue
				var alpha_mesh: MeshInstance3D = alpha_child
				
				set_mesh_materials_alpha(alpha_mesh)
				#alpha_mesh.get_active_material(0).transparency = 1
		if child.name.contains("-scrolltex"):
			var material_scroller: Node = preload("res://Scenes/material_scroller.tscn").instantiate()
			child.add_child(material_scroller)
			material_scroller.owner = get_tree().edited_scene_root
		if child.name.contains("-nocol") and not child.name.contains("-nocolactor"):
			for subchild in child.get_children():
				if is_instance_of(subchild, StaticBody3D):
					subchild.queue_free()
		if child.name.contains("-fullbright"):
			for fullbright_child in child.get_children():
				if not is_instance_of(fullbright_child, MeshInstance3D):
					continue
				var fullbright_mesh: MeshInstance3D = fullbright_child
				
				set_mesh_materials_unshaded(fullbright_mesh)
				#alpha_mesh.get_active_material(0).transparency = 1
		if child.name.contains("-ignore"):
			children_to_remove.append(child)
		
		if child.name.contains("-doorswinger"):
			doorswingers.append(child)
		if child.name.contains("-doorhinge"):
			doorhinges.append(child)
		if child.name.contains("-doorlocked"):
			for door_child in child.get_children():
				if is_instance_of(door_child, StaticBody3D):
					door_child.set_script(load("res://Scripts/doorswinger_hinge_child.gd"))
					door_child.is_locked = true
					break
		if child.name.contains("-bottleitem"):
			var bottle_colliders: Array = child.find_children("*", "StaticBody3D")
			#var mesh_candidates: Array = child.find_children("*", "MeshInstance3D")
			#var bottle_mesh: MeshInstance3D = mesh_candidates[0] if mesh_candidates else null
			for bottle_collider in bottle_colliders:
				bottle_collider.set_script(load("res://Scripts/bottle_item.gd"))
		
		if child.name.contains("-invisible"):
			prints(self.name, "INVIS FOUND", child.name)
			child.visible = false
		
		# MAP SPECIFIC \/
		if child.name == "poisonvis-nocol":
			var meshes: Array = child.find_children("*", "MeshInstance3D")
			for mesh in meshes:
				mesh.set_surface_override_material(0, load("res://Resources/nukage_waves.material"))
		# MAP SPECIFIC /\
		
		#### PHYS
		#### You've tried this twice.
		#### You forgot about the first time and ran into the same problem.
		#### The mesh from the colshape is concave and only works on static
		#if child.name.contains("-physrigid"):
			## Create rigid body
			#var physbody: RigidBody3D = RigidBody3D.new()
			#child.add_child(physbody)
			#physbody.name = "physrigid"
			#physbody.owner = get_tree().edited_scene_root
			#physbody.global_position = child.global_position
			#var colshape_parents: Array = []
			#var colshapes: Array = child.find_children("*CollisionShape3D*")
			#for colshape in colshapes:
				#prints(self.name, "Colshape:", colshape, "|", colshape.owner)
				#colshape_parents.append(colshape.get_parent())
				#colshape.reparent(physbody)
				#colshape.owner = get_tree().edited_scene_root
			#for colshape_parent in colshape_parents:
				#prints(self.name, "Colshape parent:", colshape_parent, "|", colshape_parent.owner)
				#colshape_parent.queue_free()

	
	
	for hinge in doorhinges:
		var closest_door: Node3D
		var closest_door_distance: float
		if not doorswingers:
			print("Cannot hinge door " + hinge.name + ", no doors left in array.")
			break # Should be continue but I know the array will stay empty
		for door in doorswingers:
			var door_distance: float = hinge.global_position.distance_to(door.global_position)
			if not closest_door_distance:
				closest_door = door
				closest_door_distance = door_distance
				continue
			if door_distance < closest_door_distance:
				closest_door = door
				closest_door_distance = door_distance
				continue
		closest_door.reparent(hinge)
		closest_door.owner = get_tree().edited_scene_root
		
		var door_collider: StaticBody3D
		for c in closest_door.find_children("*", "", true, false):
			c.owner = get_tree().edited_scene_root
			if not door_collider and is_instance_of(c, StaticBody3D):
				door_collider = c
				door_collider.set_script(load("res://Scripts/doorswinger_hinge_child.gd"))
		
		doorswingers.erase(closest_door)
	
	
	for child in children_to_remove:
		child.queue_free()
	
	### LEVEL SPECIFIC
	#$jp_elevator.travel_top_npath = $"../../External/Elevator/travel_top".get_path()
	#$jp_elevator.travel_bottom_npath = $"../../External/Elevator/travel_bottom".get_path()
	return


func set_mesh_materials_alpha(mesh: MeshInstance3D):
	for i in range(mesh.mesh.get_surface_count()):
		var current_material: Material = mesh.get_active_material(i)
		if current_material == null:
			return
		current_material.transparency = 1
		#alpha_mesh.get_active_material(0).transparency = 1
	return

func set_mesh_materials_unshaded(mesh: MeshInstance3D):
	for i in range(mesh.mesh.get_surface_count()):
		var current_material: Material = mesh.get_active_material(i)
		if current_material == null:
			return
		current_material.shading_mode = 0
	return

func live_init() -> void:
	for child in self.get_children():
		if child.name.contains("-nocolactor"):
			var colliderchildren: Array = child.find_children("*", "StaticBody3D")
			for colliderchild in colliderchildren:
				for a in get_tree().get_nodes_in_group("actors"):
					colliderchild.add_collision_exception_with(a)
	return
