extends World

@onready var map: TBLoader = $NavigationRegion3D/Map
var expected_enemy_groups: Array = [] # ["mooks", "punks", "burglars", "clowns_freeling", "wiseguys"]
var total_enemies: int
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_vela_office_triggered: bool = false
var is_exit_available: bool = false
var is_exit_triggered: bool = false
var is_grunt_entry_audio_triggered: bool = false
var is_scene_endable: bool = false

#var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")
var full_init: bool = false

@onready var exit_player_pos: Marker3D = null # $External/Exit/exit_player_pos
@onready var exit_light: Node3D = null # $External/Exit/exit_light
@onready var exit_music: AudioStreamPlayer3D = null # $External/Exit/exit_music
@onready var exit_screen: Control = null # $External/Exit/exit_screen
var keep_player_inventory: bool = true

@onready var vela: CharacterBody3D = $Actors/vela_cinem

func _ready():
	toggle_exit_zone(false)
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	if keep_player_inventory and not Global.prop_table["slot_manager_cache"].is_empty():
		#U.grptop("players").load_saved_inventory()
		U.grptop("players").load_life_state()
	
	for enemy_group in expected_enemy_groups:
		total_enemies += len(get_tree().get_nodes_in_group(enemy_group))
	
	for gd_rocker in get_tree().get_nodes_in_group("gd_rockers"):
		gd_rocker.interacted.connect(_gd_rocker_interacted)
	
	$Externals/Sounds.find_children("truck_door_*").pick_random().play()
	await get_tree().create_timer(.5).timeout
	full_init = true
	
	return

func _physics_process(delta):
	if not full_init: return
	
	total_time += delta
	
	#if is_scene_endable and Input.is_anything_pressed():
		#scene_ended.emit()
	
	if is_exit_available:
		exit_area_control()
	# Goofing around \/
	# Goofing around /\
	return


func exit_level():
	if is_exit_triggered:
		return
	
	is_exit_triggered = true
	scene_ended.emit()
	return


func trigger_exit_canvas():
	exit_screen.visible = true
	var enemies_alive: int = 0
	for enemy_group in expected_enemy_groups:
		for enemy in get_tree().get_nodes_in_group(enemy_group):
			if not enemy.is_dead:
				enemies_alive += 1
	
	var total_kills: String = str(total_enemies - enemies_alive)
	var credits_amount: String = "0"
	if Global.prop_table["credits"].has(get_tree().get_first_node_in_group("players").offline_id):
		credits_amount = str(Global.prop_table["credits"][get_tree().get_first_node_in_group("players").offline_id])
	#var exit_screen: Control = $External/Exit/exit_screen
	exit_screen.get_node("Label_Kills").text = "KILLS: " + total_kills + " / " + str(total_enemies)
	exit_screen.get_node("Label_Time").text = "TIME: " + str(snappedf(total_time, 0.1))
	exit_screen.get_node("Label_Credits").text = "CREDS: " + credits_amount
	exit_screen.get_node("Label_Time").visible = true
	exit_screen.get_node("Label_Kills").visible = true
	exit_screen.get_node("Label_Credits").visible = true
	return




func _on_vela_office_entry_body_entered(body: Node3D) -> void:
	if not body.is_in_group("players"):
		return
	if is_vela_office_triggered:
		return
	is_vela_office_triggered = true
	# Trigger exit availability
	toggle_exit_zone(true)
	
	# Trigger talking state and audio
	vela.sequence_speak_trigger("sequence_maisonmeet", 0)
	return

func toggle_exit_zone(toggle: bool) -> void:
	# Walk into exit light, end level
	if toggle == true:
		$Externals/EXIT/exit_light_local.visible = true
		is_exit_available = true
		return
	elif toggle == false:
		$Externals/EXIT/exit_light_local.visible = false
		is_exit_available = false
		return
		
	return

func exit_area_control() -> void:
	if is_exit_triggered: return
	var bodies: Array = $Externals/EXIT/exit_area.get_overlapping_bodies()
	if not bodies:
		return
	for b in bodies:
		if b.is_in_group("players"):
			exit_level()
			return
	return

func _gd_rocker_interacted(rocker_node: Node3D) -> void:
	#prints(self.name, "rocker interacted:", rocker_node)
	vela.interrupt_bad_touch(rocker_node)
	return
