extends World

@export var scene_start_time: float = 0.0
@onready var map: TBLoader = $NavigationRegion3D/Map
@onready var actors_anim: AnimationPlayer = $"Scene Actors/sc_chief_krammler_scolds_bravura_office_actors/sc_chief_krammler_scolds_bravura_office/AnimationPlayer"
@onready var krammler_head: MeshInstance3D = $"Scene Actors/sc_chief_krammler_scolds_bravura_office_actors/sc_chief_krammler_scolds_bravura_office/Armature_krammler/Skeleton3D/krammler_head_alttex"
var total_enemies: int
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_exit_triggered: bool = false

var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")
var full_init: bool = false
var debug_krammler_speak_value: float = 0.0

var is_krammler_talking: bool = false
var krammler_talk_tick: float = 0.0
var krammler_talk_interval_default: float = 0.08
var krammler_talk_interval: float = krammler_talk_interval_default

var is_bravura_talking: bool = false
var bravura_talk_tick: float = 0.0
var bravura_talk_interval_default: float = 0.11
var bravura_talk_interval: float = bravura_talk_interval_default
var is_bravura_face_resting: bool = true

### Bravura
@onready var bravura_face_overlay: MeshInstance3D = $"Scene Actors/sc_chief_krammler_scolds_bravura_office_actors/sc_chief_krammler_scolds_bravura_office/Armature_bravura/Skeleton3D/gb_face_overlay_B"
@onready var bravura_faces: Array = [
	preload("res://Sprites/faces/bravura_face_overlay_speak1.png"),
	preload("res://Sprites/faces/bravura_face_overlay_speak2.png"),
	preload("res://Sprites/faces/bravura_face_overlay_speak3.png")
]
@onready var bravura_rest_face: Texture2D = preload("res://Sprites/faces/bravura_face_overlay_idle.png")
@onready var bravura_serious_face: Texture2D = preload("res://Sprites/faces/bravura_face_overlay_serious_sad.png")
var bravura_face_index: int = 0
var bravura_face_material
#"res://Staging/Models/detective_bravura.glb::StandardMaterial3D_kw3vd"

func _ready():
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	
	await get_tree().create_timer(.5).timeout
	full_init = true
	
	bravura_face_material = bravura_face_overlay.get_active_material(0)
	
	actors_anim.seek(scene_start_time, true)
	#start_event_chain()
	for event in [
		[1.1, func (): $Cameras/krammler_main.make_current()],
		[1.1, func (): is_krammler_talking = true],
		[1.5, func (): is_krammler_talking = false],
		[2.00, func (): $Cameras/bravura_main.make_current()],
		[3.1, func (): $Cameras/krammler_main.make_current()],
		[3.4, func (): is_krammler_talking = true],
		[3.7, func (): is_krammler_talking = false],
		[3.8, func (): $Cameras/bravura_tight.make_current()],
		
		
		[4.3, func (): $Other/door_anchor/manual_doorhinge/AnimationPlayer.play("closing")],
		[5.2, func (): $Cameras/krammler_main.make_current()],
		[5.6, func (): is_krammler_talking = true],
		[6.5, func (): is_krammler_talking = false],
		
		[7.4, func (): is_krammler_talking = true],
		[8.8, func (): is_krammler_talking = false],
		[10.0, func (): is_krammler_talking = true],
		[13.0, func (): is_krammler_talking = false],
		[13.3, func (): is_krammler_talking = true],
		[16.8, func (): is_krammler_talking = false],
		[17.4, func (): is_krammler_talking = true],
		[24.0, func (): is_krammler_talking = false],
		
		[24.6, func (): $Cameras/bravura_tight.make_current()],
		[27.0, func (): $Cameras/krammler_main.make_current()],
		[27.2, func (): is_krammler_talking = true],
		[28.0, func (): is_krammler_talking = false],
		
		[29.4, func (): is_krammler_talking = true],
		[31.3, func (): is_krammler_talking = false],
		[31.9, func (): is_krammler_talking = true],
		[33.4, func (): is_krammler_talking = false],
		[24.6, func (): $Cameras/bravura_tight.make_current()],
		[34.6, func (): $Cameras/krammler_main.make_current()],
		[34.7, func (): is_krammler_talking = true],
		[36.4, func (): is_krammler_talking = false],
		[36.9, func (): is_bravura_talking = true],
		[39.4, func (): is_bravura_talking = false],
		[37.1, func (): $Cameras/bravura_tight.make_current()],
		[39.4, func (): $Cameras/krammler_main.make_current()],
		[39.5, func (): is_krammler_talking = true],
		[46.1, func (): is_krammler_talking = false],

		[46.2, func (): $Cameras/bravura_tight.make_current()],
		[46.3, func (): is_bravura_talking = true],
		[50.3, func (): is_bravura_talking = false],
		[50.9, func (): is_bravura_talking = true],
		[53.1, func (): is_bravura_talking = false],
		[53.4, func (): is_bravura_talking = true],
		[53.8, func (): $Cameras/bravura_main.make_current()],
		[55.0, func (): is_bravura_talking = false],
		[55.6, func (): is_krammler_talking = true],
		[55.7, func (): $Cameras/krammler_main.make_current()],
		[55.6, func (): $Cameras/krammler_main.fov = 35.0],
		[64.1, func (): $Cameras/bravura_main.make_current()],
		[63.1, func (): is_krammler_talking = false],
		[64.5, func (): is_bravura_talking = true],
		[65, func (): is_bravura_talking = false],
		[65.6, func (): is_bravura_talking = true],
		[67.3, func (): is_bravura_talking = false],
		[67.4, func (): $Cameras/bravura_tight_2.make_current()],
		[70.1, func (): $Cameras/splash_main.make_current()],
		
		[80.7, func (): $Cameras/krammler_main.make_current()],
		[81.2, func (): is_krammler_talking = true],
		[83.5, func (): is_krammler_talking = false],
		[84.5, func (): is_bravura_talking = true],
		[86.4, func (): is_bravura_talking = false],
		[86.4, func (): is_krammler_talking = true],
		[87.0, func (): is_krammler_talking = false],
		[92.2, func (): is_bravura_talking = true],
		[93.7, func (): is_bravura_talking = false],
		[93.8, func (): is_krammler_talking = true],
		[95.9, func (): is_krammler_talking = false],
		
		[86.5, func (): bravura_set_serious_face()],
		
		[82.5, func (): $Cameras/splash_main.make_current()],
		[84.4, func (): $Cameras/bravura_tight_2.make_current()],
		[88.4, func (): $Cameras/bravura_tight_3.make_current()],
		[92.2, func (): $Cameras/bravura_tight_2.make_current()],
		
		[95.5, func (): $"Scene Actors/sc_chief_krammler_scolds_bravura_office_actors/sc_chief_krammler_scolds_bravura_office/Armature_bravura".visible = false],
		[95.5, func (): $"Scene Actors/sc_chief_krammler_scolds_bravura_office_actors/sc_chief_krammler_scolds_bravura_office/folder_jimmy_baroni".visible = false],
		[95.5, func (): $Cameras/splash_main.make_current()],
	]:
		timed_func(event[1], event[0])
	return

func _physics_process(delta):
	total_time += delta
	$Control/timevaluelabel.text = str(total_time)
	$Control/kram_bark_value_label.text = str(krammler_talk_tick)
	
	if not full_init: return
	
	####
	if is_krammler_talking:
		krammler_talk_tick += delta
		if krammler_talk_tick >= krammler_talk_interval:
			krammler_bark_toggle()
			krammler_talk_tick = 0.0
	
	elif not is_krammler_talking:
		krammler_talk_tick = krammler_talk_interval_default
	####
	if is_bravura_talking:
		bravura_talk_tick += delta
		if bravura_talk_tick >= bravura_talk_interval:
			bravura_bark_toggle()
			bravura_talk_tick = 0.0
	
	elif not is_bravura_talking:
		bravura_talk_tick = bravura_talk_interval_default

	
	#prints(self.name, total_time)
	return


func timed_func(event: Callable, time_to_trigger: float):
	return get_tree().create_tween().tween_callback(event).set_delay(time_to_trigger)

func start_event_chain():
	#await get_tree().create_timer(4.3).timeout
	#$Other/door_anchor/manual_doorhinge/AnimationPlayer.play("closing")
	return

func krammler_bark_toggle():
	if debug_krammler_speak_value > 0.9:
		debug_krammler_speak_value = 0.0
	else:
		debug_krammler_speak_value = 1.0
	krammler_head.set_blend_shape_value(0, randf_range(-0.01, debug_krammler_speak_value))
	
	return
#----

func bravura_bark_toggle():
	# if is speaking index, set to non-speaking
	# If is non-speaking, set to speaking
	if not is_bravura_face_resting:
		bravura_set_rest_face()
		is_bravura_face_resting = true
	elif is_bravura_face_resting:
		is_bravura_face_resting = false
		bravura_set_next_face()
	return

func bravura_switch_to_face(index: int):
	bravura_face_material.albedo_texture = bravura_faces[index]
	return

func bravura_set_next_face():
	if Engine.is_editor_hint(): return
	bravura_face_index = U.cycled_array_index(bravura_faces, bravura_face_index)
	bravura_face_material.albedo_texture = bravura_faces[bravura_face_index]
	return bravura_faces[bravura_face_index]

func bravura_set_rest_face():
	if Engine.is_editor_hint(): return
	bravura_face_material.albedo_texture = bravura_rest_face
	return

func bravura_set_serious_face():
	if Engine.is_editor_hint(): return
	bravura_face_material.albedo_texture = bravura_serious_face
	return
