extends World

@onready var map: TBLoader = $NavigationRegion3D/Map
var expected_enemy_groups: Array = ["mooks", "punks", "burglars", "clowns_freeling", "wiseguys"]
var total_enemies: int
var debug_store: Dictionary = {"node_counter": {}}
var total_time: float = 0.0
var is_exit_triggered: bool = false
var is_scene_endable: bool = false
var is_club_music_triggered: bool = false
var is_cinem_clown_vest_triggered: bool = false

#var extra_club_music: Array = [
	#preload("res://Audio/Music/sqg/sqg_Business.ogg"),
	#preload("res://Audio/Music/sqg/sqg_Out.mp3"),
	#preload("res://Audio/Music/sqg/sqg_Miss Me.mp3")
#]
#var extra_club_music_index: int = -1

var intermission_loop_scene: Resource = preload("res://Scenes/intermission_loop.tscn")
var full_init: bool = false

var is_exit_camera_flickering: bool = false
var exit_camera_delta: float = 0.0
var exit_camera_interval: float = .001
var exit_camera_index: int = 0
@onready var exit_cameras: Array = [
	$External/Exit/exit_camera_1,
	$External/Exit/exit_camera_2
]
@onready var exit_player_pos: Marker3D = $External/Exit/exit_player_pos
@onready var exit_light: Node3D = $External/Exit/exit_light
@onready var exit_music: AudioStreamPlayer3D = $External/Exit/exit_music
@onready var exit_screen: Control = $External/Exit/exit_screen
var keep_player_inventory: bool = true

var restaurant_music_audio: Array = [
	preload("res://Audio/Music/sqg/Environment/sqg_Yopparai_Tori.mp3"),
	preload("res://Audio/Music/sqg/Environment/sqg_Yopparai_Tori_alt_1.mp3"),
	preload("res://Audio/Music/sqg/Environment/sqg_Yopparai_Tori_alt_2.mp3")
]
var restaurant_music_index: int = 0

func _ready():
	for c in get_tree().get_nodes_in_group("world_inits"):
		c._on_world_ready()
	
	if keep_player_inventory and not Global.prop_table["slot_manager_cache"].is_empty():
		U.grptop("players").load_saved_inventory()
		U.grptop("players").load_life_state()
	
	for enemy_group in expected_enemy_groups:
		total_enemies += len(get_tree().get_nodes_in_group(enemy_group))
	
	await get_tree().create_timer(.5).timeout
	full_init = true
	
	
	exit_player_pos.reparent(get_tree().get_first_node_in_group("exit_elevator"))
	exit_light.reparent(get_tree().get_first_node_in_group("exit_elevator"))
	exit_music.reparent(get_tree().get_first_node_in_group("exit_elevator"))
	######
	await get_tree().create_timer(6.0).timeout
	Engine.time_scale = .5
	$world_camera.make_current()
	$world_camera/AnimationPlayer.play("scroll")
	$vday_container/vday_intro_song.playing = true
	await get_tree().create_timer(3.4).timeout
	get_tree().create_tween().tween_property(
		$vday_container/vday_intro_song,
		"pitch_scale",
		2.71,
		.5
	)
	
	return

func _physics_process(delta):
	if not full_init: return
	
	total_time += delta
	
	if is_scene_endable and Input.is_anything_pressed():
		scene_ended.emit()
	
	if is_exit_camera_flickering:
		
		exit_camera_delta += delta
		if exit_camera_delta >= exit_camera_interval:
			var offset: float = 0.002
			exit_cameras[0].position.x -= offset# * .6
			exit_cameras[1].position.x += offset * .6
			exit_cameras[1].position.z += offset
			exit_cameras[1].position.y -= offset * 1.7
			
			exit_camera_delta = 0.0
			exit_cameras[exit_camera_index].make_current()
			if exit_camera_index == 1:
				exit_camera_index = 0
			elif exit_camera_index == 0:
				exit_camera_index = 1
	return

# 


func _on_club_music_trigger_body_entered(body):
	if is_club_music_triggered: return
	
	if not body.is_in_group("players"):
		return
	
	is_club_music_triggered = true
	var random_seek: float = (
		randf_range(0.0, ($External/Club/club_speaker_1.stream.get_length() * .6))
	)
	for speaker in get_tree().get_nodes_in_group("club_speakers"):
		speaker.seek(random_seek)
		speaker.play()
		get_tree().create_tween().tween_property(speaker, "volume_db", -14, 2.2)
	
	$External/AreaTriggers/club_music_trigger.monitoring = false
	$External/AreaTriggers/club_music_trigger/CollisionShape3D.disabled = true
	
	## Performance
	$enemy_container/Main.process_mode = Node.PROCESS_MODE_DISABLED
	$enemy_container/Office.process_mode = Node.PROCESS_MODE_INHERIT
	$enemy_container/Club.process_mode = Node.PROCESS_MODE_INHERIT
	#
	#for n in $enemy_container/Club.get_children():
		#if n.process_mode != Node.PROCESS_MODE_INHERIT:
			#prints(n.name, "Process mode was not INHERIT")
			#n.process_mode = Node.PROCESS_MODE_INHERIT
	#
	#for n in $enemy_container/Office.get_children():
		#if n.process_mode != Node.PROCESS_MODE_INHERIT:
			#prints(n.name, "Process mode was not INHERIT")
			#n.process_mode = Node.PROCESS_MODE_INHERIT
	return


func _on_clown_vest_trigger_body_entered(body):
	if is_cinem_clown_vest_triggered: return
	if body.is_in_group("players"):
		#for speaker in get_tree().get_nodes_in_group("club_speakers"):
			#get_tree().create_tween().tween_property(speaker, "volume_db", -15, 0.4)
		
		$External/ClownConnector/clownvest_shoot.play()
		await get_tree().create_timer(.1).timeout
		$External/ClownConnector/clownvest_shoot.play()
		await get_tree().create_timer(.1).timeout
		$External/ClownConnector/clownvest_shoot.play()
		await get_tree().create_timer(.2).timeout
		
		is_cinem_clown_vest_triggered = true
		#var clown_vest_spatial: Node3D = $External/ClownConnector/clown_freeling_cinem
		var clown_vest_anim: AnimationPlayer = $External/ClownConnector/clown_freeling_cinem/AnimationPlayer
		clown_vest_anim.play("cinem_pull_armor_2")
		$External/ClownConnector/clownvest_laugh.play()
		await clown_vest_anim.animation_finished
		$External/ClownConnector/clown_freeling_cinem/Armature/Skeleton3D/rhand_attachment/rhand_anchor/mook_femme_vest.visible = false
		$External/ClownConnector/clown_freeling_cinem/Armature/Skeleton3D/vest.visible = true
		clown_vest_anim.play("unarmed_idle")
		$External/ClownConnector/clown_freeling_cinem.global_rotation_degrees.y = -6.0
		await get_tree().create_timer(.4).timeout
		clown_vest_anim.play("unarmed_run")
		$External/ClownConnector/clown_vest_sequencer.play("move_node")
		
		$External/AreaTriggers/clown_vest_trigger.monitoring = false
		$External/AreaTriggers/clown_vest_trigger/CollisionShape3D.disabled = true
	return

func exit_level():
	if is_exit_triggered:
		return
	
	is_exit_triggered = true
	Engine.time_scale = 0.4 # .2
	var player: Node3D = U.grptop("players")
	player.exit_mode = true
	player.hud.visible = false
	player.velocity = Vector3.ZERO
	player.toggle_dancing("gesture_dance_head_shake_1")
	
	player.global_position = exit_player_pos.global_position
	player.global_rotation = exit_player_pos.global_rotation
	
	#U.grptop("players").global_position = $External/Exit/exit_player_pos.global_position
	#U.grptop("players").global_rotation = $External/Exit/exit_player_pos.global_rotation
	for camera in exit_cameras:
		var prev_pos: Vector3 = camera.global_position
		camera.reparent(
			get_tree().get_first_node_in_group("exit_elevator")
		)
		
		#camera.global_position = prev_pos
	
	exit_light.get_node("AnimationPlayer").play("flash")
	exit_light.get_node("AnimationPlayer").speed_scale = 2.0
	
	for speaker in get_tree().get_nodes_in_group("club_speakers"):
		speaker.stop()
	
	exit_music.play(41.9)
	is_exit_camera_flickering = true
	await get_tree().create_timer(0.3).timeout
	#$External/Exit/exit_screen.visible = true
	trigger_exit_canvas()
	await get_tree().create_timer(2.0).timeout
	is_scene_endable = true
	await get_tree().create_timer(23.0).timeout
	is_exit_camera_flickering = false
	get_tree().get_first_node_in_group("black_camera").make_current()

	return


func _on_exit_trigger_body_entered(body):
	if is_exit_triggered:
		return
	if not body.is_in_group("players"):
		return
	
	exit_level()
	return

func trigger_exit_canvas():
	exit_screen.visible = true
	var enemies_alive: int = 0
	for enemy_group in expected_enemy_groups:
		for enemy in get_tree().get_nodes_in_group(enemy_group):
			if not enemy.is_dead:
				enemies_alive += 1
	
	var total_kills: String = str(total_enemies - enemies_alive)
	var credits_amount: String = "0"
	if Global.prop_table["credits"].has(get_tree().get_first_node_in_group("players").offline_id):
		credits_amount = str(Global.prop_table["credits"][get_tree().get_first_node_in_group("players").offline_id])
	#var exit_screen: Control = $External/Exit/exit_screen
	exit_screen.get_node("Label_Kills").text = "KILLS: " + total_kills + " / " + str(total_enemies)
	exit_screen.get_node("Label_Time").text = "TIME: " + str(snappedf(total_time, 0.1))
	exit_screen.get_node("Label_Credits").text = "CREDS: " + credits_amount
	exit_screen.get_node("Label_Time").visible = true
	exit_screen.get_node("Label_Kills").visible = true
	exit_screen.get_node("Label_Credits").visible = true
	return



func _on_restaurant_speakers_1_finished() -> void:
	restaurant_music_index = U.cycled_array_index(restaurant_music_audio, restaurant_music_index)
	for speaker in get_tree().get_nodes_in_group("restaurant_speakers"):
		speaker.stop()
		speaker.stream = restaurant_music_audio[restaurant_music_index]
		speaker.play()
	return


func _on_pit_kill_timer_timeout() -> void:
	var area_bodies: Array = $External/AreaTriggers/pit_kill_trigger.get_overlapping_bodies()
	for b in area_bodies:
		if not b: 
			continue
		if not b.is_in_group("actors"):
			continue
		if b.is_dead:
			continue
		b.hit(9999, U.hit_types.AREA, null, b.global_position)
	return


func _on_club_speaker_1_finished() -> void:
	#extra_club_music_index += 1
	#var last_index: int = extra_club_music.size() - 1
	#if extra_club_music_index > last_index:
		#return
	#for speaker in get_tree().get_nodes_in_group("club_speakers"):
		#speaker.stream = extra_club_music[extra_club_music_index]
	#
	#get_tree().call_group("club_speakers", "play")
	return
