extends Node
# [A]ctor

var gravity = (ProjectSettings.get_setting("physics/3d/default_gravity") * 6)
const CSGBOX: Resource = preload("res://Scenes/csg_box_subtract_test.tscn")
const SMOKEPUFF: Resource = preload("res://Scenes/smoke_puff.tscn")

func apply_move(actor: CharacterBody3D, input_dir: Vector2, speed: float = 1):
	var direction = (actor.transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	if direction:
		actor.velocity.x = direction.x * speed
		actor.velocity.z = direction.z * speed
	else:
		return
		# Got an error with these saying no move_toward. Probably only works on a position/Vector3
		#actor.velocity.x = actor.move_toward(actor.velocity.x, 0, speed)
		#actor.velocity.z = actor.move_toward(actor.velocity.z, 0, speed)
	return

func apply_move_with_axis(fixed_basis: Basis, actor: CharacterBody3D, input_dir: Vector2, speed: float = 1):
	var direction = (fixed_basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	if direction:
		actor.velocity.x = direction.x * speed
		actor.velocity.z = direction.z * speed
	else:
		return
		# Got an error with these saying no move_toward. Probably only works on a position/Vector3
		#actor.velocity.x = actor.move_toward(actor.velocity.x, 0, speed)
		#actor.velocity.z = actor.move_toward(actor.velocity.z, 0, speed)
	return

func apply_gravity(actor: CharacterBody3D, delta: float):
	actor.velocity.y -= gravity * delta
	return

func face_position_spatial(spatial: Node3D, raw_position: Vector3 = Vector3.ZERO, parallel: bool = false):
	var target_position = raw_position
	if parallel:
		target_position.y = spatial.global_position.y
	spatial.look_at(target_position, Vector3.UP)
	return

#func face_position(actor: CharacterBody3D, raw_position: Vector3 = Vector3.ZERO, parallel: bool = false):
func face_position(actor: PhysicsBody3D, raw_position: Vector3 = Vector3.ZERO, parallel: bool = false):
	if actor.name.contains("cult"):
		pass
	var target_position = raw_position
	if parallel:
		target_position.y = actor.global_position.y
	if not actor.is_in_group("players"):
		actor.eyes.look_at(target_position, Vector3.UP)
		actor.global_rotation.y = actor.eyes.global_rotation.y
	else:
		actor.cam_base.look_at(target_position, Vector3.UP)
		actor.global_rotation.y = actor.cam_base.global_rotation.y
	
	if actor.is_in_group("players"):
		get_tree().create_tween().tween_property(actor.cam_base, "rotation", Vector3.ZERO, .2)
	return

func is_actor_ahead_approx(source_actor: PhysicsBody3D, target_actor: PhysicsBody3D):
	var raw_diff: Vector3 = target_actor.global_position - source_actor.global_position
	var diff_dot: float = source_actor.transform.basis.z.dot(raw_diff.normalized())
	if diff_dot < 0.0:
		return true
	else:
		return false
	return

#func is_actor_viewable(source_actor: CharacterBody3D = null, source_raycast: RayCast3D = null, target_actor: CharacterBody3D = null, y_look_offset: float = 0.0):
#func is_actor_viewable(source_actor: PhysicsBody3D = null, source_raycast: RayCast3D = null, target_actor: CharacterBody3D = null, y_look_offset: float = 0.0):
func is_actor_viewable(source_actor: PhysicsBody3D = null, source_raycast: RayCast3D = null, target_actor: PhysicsBody3D = null, y_look_offset: float = 0.0):
	# var original_global_rotation: Vector3 = sight_raycast.global_rotation
	# May be an issue later not resetting the raycast orientation but whatever for now!
	if not target_actor:
		return false
	
	if not source_actor:
		push_warning("is_actor_viewable: No source actor given")
		return false
	
	if not source_raycast and not "sight_raycast" in source_actor:
		push_warning("is_actor_viewable: No sight_raycast in source_actor, and func param is null")
		return false
	
	if not source_raycast:
		source_raycast = source_actor.sight_raycast
	
	var look_position: Vector3 = target_actor.global_position
	look_position.y += y_look_offset
	
	
	source_raycast.look_at(look_position, Vector3.UP)
	
	
	var collider = source_raycast.get_collider()
	if not collider:
		return false
	
	if collider.is_in_group("windows"):
		source_raycast.add_exception(collider)
		collider = source_raycast.get_collider()
	if collider.is_in_group("vehicles"):
		source_raycast.add_exception(collider)
		collider = source_raycast.get_collider()
	return collider == target_actor

#func create_impact(actor: CharacterBody3D, raycast: RayCast3D, damage: int, knockback_force: float = 30):
func create_basic_impact(actor: PhysicsBody3D, raycast: RayCast3D, damage: int, knockback_force: float = 30):
	if actor and actor.get("suppress_impact_calls"):
		return
	
	var hit_recipient: Node3D #PhysicsBody3D
	
	var collider: Object = raycast.get_collider()
	if collider:
		hit_recipient = collider
		var impact_position = raycast.get_collision_point()
		
		if collider.is_in_group("hit_takers"):
			if collider.has_method("hit"):
				#collider.hit(damage, U.hit_types.UNDEFINED, actor, impact_position)
				collider.hit(damage, U.hit_types.RAYCAST, actor, impact_position)
			elif collider.get_parent().has_method("hit"):
				#collider.get_parent().hit(damage, U.hit_types.UNDEFINED, actor, impact_position)
				collider.get_parent().hit(damage, U.hit_types.RAYCAST, actor, impact_position)
		
		#if is_instance_of(collider, CharacterBody3D):
			#A.apply_move(collider, Vector2.DOWN, knockback_force)
		
		if is_instance_of(collider, RigidBody3D):
			# Stolen from leddit and cleaned up.
			var start_pos: Vector3 = raycast.global_position
			var collision_point: Vector3 = raycast.get_collision_point()
			var impact_direction: Vector3 = start_pos.direction_to(collision_point)
			var impulse = knockback_force * impact_direction
			var relative_position: Vector3 = collision_point - collider.global_position
			collider.apply_impulse(impulse, relative_position)
		
		## CSG TEST
		if is_instance_of(collider, CSGCombiner3D):

			var new_box: CSGMesh3D = CSGBOX.instantiate()
			collider.add_child(new_box)
			new_box.global_position = raycast.get_collision_point()
		
		var is_puffable: bool = true
		var nopuff_groups: Array = ["civilians", "glass_cells"]
		#if collider.is_in_group("civilians"):
		for g in nopuff_groups:
			if collider.is_in_group(g):
				is_puffable = false
				break
		
		if is_puffable:
			var new_smoke_puff: Sprite3D = SMOKEPUFF.instantiate()
			
			#collider.add_child(new_smoke_puff)
			var assumed_world = get_tree().get_first_node_in_group("Worlds")
			assumed_world.add_child(new_smoke_puff)
			var audio_stream_path: String = ["res://Audio/Weapons/crowbar_hit_1.ogg", "res://Audio/Weapons/crowbar_hit_2.ogg"].pick_random()
			var impact_sound: AudioStreamPlayer3D = U.spawn_sound_player(assumed_world, impact_position, audio_stream_path)
			impact_sound.pitch_scale = randf_range(1.9, 3.2)
			impact_sound.volume_db = -10.0
			impact_sound.play()
			
			new_smoke_puff.global_position = impact_position
			if collider.is_in_group("actors") and not collider.get("is_wearing_kevlar"):
				new_smoke_puff.get_node("AnimationPlayer").play("fade_red")
			else:
				new_smoke_puff.get_node("AnimationPlayer").play("fade")
	return hit_recipient

func create_impact(actor: PhysicsBody3D, raycast: RayCast3D, damage: int, knockback_force: float = 30, penetration_groups: Array = ["glass_cells"], penetration_depth: int = 3):
	# Handle regular impacts and penetrations
	var first_hit_recipient: Object
	
	first_hit_recipient = create_basic_impact(actor, raycast, damage, knockback_force)
	
	if penetration_groups:
		spawn_impact_penetrator(actor, raycast, damage, knockback_force, penetration_groups, penetration_depth, first_hit_recipient)
	
	return first_hit_recipient


#func create_impact(actor: PhysicsBody3D, raycast: RayCast3D, damage: int, knockback_force: float = 30, penetration_groups: Array = ["glass_cells"], penetration_depth: int = 3):
	## Handle regular impacts and penetrations
	#var first_hit_recipient: Object
	#var hit_recipients: Array = []
	#
	#if penetration_groups:
		#for i in range(penetration_depth):
			#first_hit_recipient = create_basic_impact(actor, raycast, damage, knockback_force)
			#U.spawn_green_marker(Blackboard.current_world, raycast.get_collision_point(), 999.0)
			#var is_penetratable: bool = false
			#for g in penetration_groups:
				#if first_hit_recipient.is_in_group(g):
					#is_penetratable = true
					#break
			#
			#if not is_penetratable:
				##raycast.add_exception(first_hit_recipient)
				#break
			#
			#hit_recipients.append(first_hit_recipient)
			#
		#
		##for hit_recipient in hit_recipients:
			##raycast.remove_exception(hit_recipient)
		#
	#else:
		#first_hit_recipient = create_basic_impact(actor, raycast, damage, knockback_force)
	#return first_hit_recipient


func create_ghost_impact(source_actor: PhysicsBody3D, target_actor: PhysicsBody3D, damage: int, knockback_force: float = 30):
	var hit_recipient: Node3D #PhysicsBody3D
	
	var collider: PhysicsBody3D = target_actor
	if collider:
		hit_recipient = collider
		var impact_position: Vector3
		#if "ghost_position" in collider:
		#if collider.get("ghost_position"):
			#impact_position = collider.ghost_position.global_position
		#else:
			#var adjusted_hit_pos: Vector3 = collider.global_position
			#var y_offset: float = 5.0
			#adjusted_hit_pos.y += y_offset
			#impact_position = adjusted_hit_pos
		
		var adjusted_hit_pos: Vector3 = collider.global_position
		var y_offset: float = 5.0
		adjusted_hit_pos.y += y_offset
		impact_position = adjusted_hit_pos
		
		if collider.is_in_group("hit_takers"):
			collider.hit(damage, U.hit_types.UNDEFINED, source_actor, impact_position)
		
		var new_smoke_puff: Sprite3D = SMOKEPUFF.instantiate()

		collider.add_child(new_smoke_puff)
		var assumed_world = get_tree().get_first_node_in_group("Worlds")
		#assumed_world.add_child(new_smoke_puff)
		new_smoke_puff.global_position = impact_position # raycast.get_collision_point()
		if collider.is_in_group("actors") and not collider.get("is_wearing_kevlar"):
			new_smoke_puff.get_node("AnimationPlayer").play("fade_red")
		else:
			new_smoke_puff.get_node("AnimationPlayer").play("fade")
	return hit_recipient

#func check_for_sounds(actor: CharacterBody3D, hearing_distance: float):
func check_for_sounds(actor: PhysicsBody3D, hearing_distance: float):
	var sounds: Array = get_tree().get_nodes_in_group("world_sounds")
	var sounds_heard: Array
	for sound in sounds:
		if actor.global_position.distance_to(sound.global_position) < hearing_distance:
			sounds_heard.push_front(sound)
			continue
	return sounds_heard

func get_target_candidates(group_list: Array[String]):
	var candidates: Array[CharacterBody3D] = []
	for group in group_list:
		for actor in get_tree().get_nodes_in_group(group):
			candidates.push_front(actor)
	return candidates

func animate(actor: CharacterBody3D, animation_name: String, override: bool = false):
	if not override and actor.anim.assigned_animation == animation_name:
		return
	if override:
		actor.anim.stop()
	actor.anim.play(animation_name)
	return

func is_moving(actor: CharacterBody3D, movement_threshold: float = 10.00, ignore_y: bool = false):
	var velo: Vector3 = actor.velocity
	if ignore_y:
		velo.y = 0.0
	
	if velo.length() > movement_threshold:
		return true
	else:
		return false
	
	return

func distance(source_actor: Node3D, target_actor: Node3D):
	return source_actor.global_position.distance_to(target_actor.global_position)

func gradual_velo_stop(actor: CharacterBody3D, stop_vec: Vector3 = Vector3.ZERO, duration: float = 0.25):
	var tween: Tween = get_tree().create_tween()
	tween.tween_property(actor, "velocity", stop_vec, duration)
	return

#func hillbilly_add_ray_exception(thing: Node3D, offset: float = 999) -> void:
	##thing.global_position.y += offset
	#var colliders: Array = thing.find_children("*", "CollisionShape3D")
	#for collider in colliders:
		#if collider.disabled:
			#continue
		#
		#collider.set_meta("hillbilly_ray_exception", true)
		#collider.disabled = true
	#return
#
#func hillbilly_remove_ray_exception(thing: Node3D, offset: float = 999) -> void:
	##thing.global_position.y -= offset
	#var colliders: Array = thing.find_children("*", "CollisionShape3D")
	#for collider in colliders:
		#if collider.get_meta("hillybilly_ray_exception", false) == true:
			#collider.set_meta("hillbilly_ray_exception", false)
			#collider.disabled = false
	#return


func spawn_impact_penetrator(
	actor: PhysicsBody3D,
	raycast: RayCast3D,
	damage: int,
	knockback_force: float = 30,
	penetration_groups: Array = ["glass_cells"],
	penetration_depth: int = 0,
	first_hit_recipient: Object = null
):
	if penetration_depth == 0:
		return
	var hit_recipients: Array = []
	
	penetration_depth -= 1
	for i in range(penetration_depth):
		var hit_recipient: Object = create_basic_impact(actor, raycast, damage, knockback_force)
		if not hit_recipient:
			continue
		if hit_recipients.has(hit_recipient):
			continue
		#U.spawn_green_marker(Blackboard.current_world, raycast.get_collision_point(), 999.0)
		var is_penetratable: bool = false
		for g in penetration_groups:
			if hit_recipient.is_in_group(g):
				is_penetratable = true
				break
		if not is_penetratable:
			break
		
		
		hit_recipients.append(hit_recipient)
		raycast.add_exception(hit_recipient)
		await get_tree().process_frame
	
	for hit_recipient in hit_recipients:
		if not hit_recipient:
			continue
		raycast.remove_exception(hit_recipient)
	return

func move_nav(actor: CharacterBody3D, face_direction: bool = true, new_position: Vector3 = Vector3.ZERO):
	## I think this is screwed up. It doesn't work with clown_freeling_hecu, anyways
	if not actor.get("nav_agent"):
		prints(self.name, "move_nav called on actor with no nav_agent")
		return
	
	var nav_agent: NavigationAgent3D = actor.nav_agent
	if new_position:
		nav_agent.target_position = new_position
	var next_position: Vector3 = nav_agent.get_next_path_position()
	if actor.get_node("debug_label").visible:
		U.spawn_green_marker(Blackboard.current_world, nav_agent.target_position, .5)
		U.spawn_blue_marker(Blackboard.current_world, next_position, .5)
	if face_direction:
		face_position(actor, next_position)
		apply_move(actor, Vector2(0, -1), actor.move_speed)
	elif not face_direction:
		actor.velocity = (next_position - actor.global_position).normalized() * actor.move_speed
	return

func guess_actor_group(actor: PhysicsBody3D) -> String:
	var all_groups: Array = actor.get_groups()
	var actor_group_candidates: Array = []
	var common_groups: Array = ["actors", "hit_takers"]
	for group in all_groups:
		if common_groups.has(group):
			continue
		actor_group_candidates.append(group)
	return actor_group_candidates[0]
