extends Node

var actors: Dictionary = {}
var current_world: World
var user_scene_root: Node

var dump_table: Dictionary = {
	"recent_punk_sounds": [],
	"freeling_positions": {
		"attack": [],
		"cover": []
	}
}

var tick_interval: float = .25
var accumulated_tick_time: float = 0.0
var cleanup_callables: Array = []
## For the universal world queue,
## I want it to 
var universal_world_queue: Dictionary = {
	# group: {
	# 	"tick_interval": behavior_process_interval
	# 	"tick_gap": 0.0
	# 	"queue": [groupnode1, groupnode2, ...]
	# }
}
var universal_world_queue_tickers: Dictionary = {
	# group: 0.0
}


func _physics_process(delta: float) -> void:
	if current_world and get_tree().get_nodes_in_group("Worlds"):
		current_world.uptime += delta
	
	accumulated_tick_time += delta
	if accumulated_tick_time >= tick_interval:
		accumulated_tick_time = 0.0
		tick_control(delta)
	
	var triggered_world_queues: Array = []
	for world_group in universal_world_queue_tickers.keys():
		universal_world_queue_tickers[world_group] += delta
		if universal_world_queue_tickers[world_group] > universal_world_queue[world_group]["tick_interval"]:
			triggered_world_queues.append(world_group)
			universal_world_queue_tickers[world_group] = 0.0
	for world_group in triggered_world_queues:
		process_world_group_queue(universal_world_queue[world_group]["queue"])
	return

func tick_control(delta: float) -> void:
	for cleanup_func in cleanup_callables:
		cleanup_func.call()
	return

func freeling_position_cleanup() -> void:
	# if there are too many positions in the array, reduce the array to fit the max
	var max_positions: int = 100
	for position_array in dump_table["freeling_positions"].keys():
		if dump_table["freeling_positions"][position_array].size() > max_positions:
			dump_table["freeling_positions"][position_array].resize(max_positions)
			prints(self.name, "Freeling position cache cleanup:", dump_table["freeling_positions"][position_array].size())
	return

#var universal_world_queue: Dictionary = {
	## group: {
	## 	"tick_interval": behavior_process_interval
	## 	"tick_gap": 0.0
	## 	"queue": [groupnode1, groupnode2, ...]
	## }
#}

func clear_universal_world_queue() -> void:
	universal_world_queue.clear()
	universal_world_queue_tickers.clear()
	return

func add_to_universal_world_queue(actor: PhysicsBody3D = null, world_group: String = "") -> void:
	if not actor: return
	if world_group == "":
		world_group = A.guess_actor_group(actor)
	if not universal_world_queue.has(world_group):
		universal_world_queue[world_group] = {
			"tick_interval": actor.DEFAULT_PROCESS_TICK,
			"tick_gap": 0.0,
			"queue": []
		}
		universal_world_queue_tickers[world_group] = 0.0
	
	if not universal_world_queue[world_group]["queue"].has(actor):
		universal_world_queue[world_group]["queue"].append(actor)
		actor.is_in_world_queue = true
	
	return

func remove_from_universal_world_queue(actor: PhysicsBody3D, world_group: String = "") -> void:
	if not actor: return
	if world_group == "":
		world_group = A.guess_actor_group(actor)
	if not universal_world_queue.has(world_group):
		return
	universal_world_queue[world_group]["queue"].erase(actor)
	actor.is_in_world_queue = false
	return

func process_world_group_queue_process_disable(queue: Array) -> void:
	for actor in queue:
		actor.process_mode = Node.PROCESS_MODE_INHERIT
		actor._world_queue_execute()
		for i in range(1):
			await get_tree().process_frame
	await get_tree().process_frame
	for actor in queue:
		actor.process_mode = Node.PROCESS_MODE_DISABLED
	return

func process_world_group_queue(queue: Array, sleepwake: bool = false) -> void:
	for actor in queue:
		if not actor or not is_instance_valid(actor):
			continue
		## wake
		if sleepwake and actor.has_method("set_as_soft_disable"):
			actor.set_as_soft_disable(false)
		actor._world_queue_execute()
		for i in range(1):
			await get_tree().process_frame
	await get_tree().process_frame
	for actor in queue:
		# sleep
		if sleepwake and actor.has_method("set_as_soft_disable"):
			actor.set_as_soft_disable(true)
	return
