extends Node

enum startup_types {
	NEW,
	LOADED
}
var startup_type: int

var current_scene_path: String = ""
var main_menu_path: String = "res://Scenes/main_menu.tscn"
var scenes_in_order: Array = [
	"res://Scenes/dream_sequence.tscn", # Comic intro into tutorial
	"res://Scenes/core_rnd_b.tscn", # Tutorial
	"res://Scenes/Levels/healerphone.tscn",
	"res://Scenes/Levels/e1_tickets_please.tscn",
	"res://Scenes/Levels/maison_de_vela.tscn",
	"res://Scenes/Levels/e2_quiet_please.tscn",
	"res://Scenes/Levels/maison_de_vela_ambush.tscn",
	"res://Scenes/Levels/bravo.tscn",
	"res://Scenes/Levels/hanger.tscn",
	"res://Scenes/Levels/pillmap_driver.tscn"
]

var scene_index: int = 0
var last_tutorial_index: int = 1

var scene_aliases: Dictionary = {
	"e1": "res://Scenes/Levels/e1_tickets_please.tscn",
	"tickets": "res://Scenes/Levels/e1_tickets_please.tscn",
	"e2": "res://Scenes/Levels/e2_quiet_please.tscn",
	"quiet": "res://Scenes/Levels/e2_quiet_please.tscn",
	"hanger": "res://Scenes/Levels/hanger.tscn"
}

var run_on_load: Array[Dictionary] = []

### Speaking sequences \/
var speaking_sequences: Dictionary = {
	"sequence_maisonmeet": {
		0: {
			"world_group": "sequence_speaker_vela",
			"node_query": "sequence_maisonmeet_0"
		},
		1: {
			"world_group": "sequence_speaker_sara",
			"node_query": "sequence_maisonmeet_1"
		},
		2: {
			"world_group": "sequence_speaker_vela",
			"node_query": "sequence_maisonmeet_2"
		}
	},
	"sequence_healersmokes": {
		0: {
			"world_group": "sequence_speaker_noko",
			"node_query": "sequence_healersmokes_0"
		},
		1: {
			"world_group": "sequence_speaker_jenny",
			"node_query": "sequence_healersmokes_1"
		},
		2: {
			"world_group": "sequence_speaker_noko",
			"node_query": "sequence_healersmokes_2"
		},
		3: {
			"world_group": "sequence_speaker_jenny",
			"node_query": "sequence_healersmokes_3"
		},
		4: {
			"world_group": "sequence_speaker_noko",
			"node_query": "sequence_healersmokes_4"
		},
	}
}
### Speaking sequences /\

func new_game():
	startup_type = startup_types.NEW
	current_scene_path = scenes_in_order[scene_index]
	return

func next_scene():
	scene_index += 1
	var last_index: int = len(scenes_in_order) - 1
	if scene_index > last_index:
		return main_menu_path
	current_scene_path = scenes_in_order[scene_index]
	return current_scene_path

func reset():
	scenes_in_order = [
		"res://Scenes/dream_sequence.tscn", # Comic intro into tutorial
		"res://Scenes/core_rnd_b.tscn", # Tutorial
		"res://Scenes/Levels/e1_tickets_please.tscn", # Not actual first level
		"res://Scenes/Levels/hanger.tscn"
	]
	
	scene_index = 0
	return

func add_load_run(node_instance: Node, method_name: String) -> void:
	self.run_on_load.append({
		"node": node_instance,
		"method": method_name
	})
	return

func speak_sequence_ended(sequence_name: String = "", sequence_index: int = 0) -> void:
	#Director.speak_sequence_ended(speak_sequence_name, speak_sequence_index)
	##
	# Is this index the last one?
	#	-- Return (maybe emit sequence ended or something, idk)
	var sequence_position: int = sequence_index + 1
	var final_sequence_position: int = len(speaking_sequences[sequence_name])
	if sequence_position == final_sequence_position:
		prints(self.name, "Final speak sequence reached.")
		for n in get_tree().get_nodes_in_group("speak_sequence_end_listeners"):
			n._speak_sequence_ended(sequence_name)
		return
	
	var next_sequence_index: int = sequence_index + 1
	var next_speaker_group: String = speaking_sequences[sequence_name][next_sequence_index]["world_group"]
	get_tree().get_first_node_in_group(next_speaker_group).sequence_speak_trigger(sequence_name, next_sequence_index)
	var sequence_trigger_listener_group: String = sequence_name + "_trigger_listeners"
	for n in get_tree().get_nodes_in_group(sequence_trigger_listener_group):
		#sequence_healersmokes_trigger_listeners
		n.speak_sequence_triggered(sequence_name, next_sequence_index)
	return
