extends Node

var mouse_sensitivity: float = 12.0
var mouse_sensitivity_scale: float = 6000.0
var default_master_volume: float = -10.00
var master_volume_percent: float = 80.0
const max_master_volume: float = 3.0 # 15 is way too loud
const min_master_volume: float = -55.0 # -80 is overkill
var is_iid_persistent: bool = true
var session_time: float = 0.0

var prop_table: Dictionary = {
	"credits": {
		# [Player]: [credits]
	},
	"slot_manager_cache": {},
	"player_cache": {}
} # Don't remove this lol

var sanitation: Dictionary = {} # Can use this for things like tracking tweens and killing them when freeing nodes

var iid_table: Dictionary = {
	1000: null # magic start index
}

enum skill_levels {
	SWEET_DREAMS,
	ROUGH_NIGHT,
	NIGHT_TERROR,
	PARALYSIS
}
var skill_level: int = skill_levels.SWEET_DREAMS

func new_iid(item_name: String):
	## I thought this was really smart when I first wrote it
	## But it never actually finds the last key
	## BUG: When I pick up a 9mm or Beretta, then Octo
	## Octo gets the previous gun's mag size
	## It's because each new iid overwrites the last one (1003)
	#var key_sum: int = 0
	#for k in iid_table.keys():
		#key_sum += k
	#var last_key: int = key_sum / len(iid_table.keys()) + 1
	#var new_key: int = last_key + 1
	
	var new_key: int = 9999
	for k in iid_table.keys():
		var next_key: int = k + 1
		if iid_table.has(next_key):
			continue
		new_key = next_key
		break
	iid_table[new_key] = item_name
	return new_key

func reset_iid_table():
	iid_table.clear()
	iid_table[1000] = null
	return

func remove_iid(iid: int):
	iid_table.erase(iid)
	return

func weapon_post_init(weapon: Node3D):
	## This doesn't help
	## if the collision you want to exclude
	## and the collision you want to keep
	## are owned by the same PhysicsBody3D
	## :(
	#for col in get_tree().get_nodes_in_group("vehicle_colliders"):
		#for raycast in weapon.find_children("*", "RayCast3D"):
			#raycast.add_exception(col)
	return


func _ready() -> void:
	# Possible fix/workaround to the loss of focus when using the editor and launching the build
	#DisplayServer.window_set_flag(DisplayServer.WINDOW_FLAG_RESIZE_DISABLED, true)
	return

func _physics_process(delta: float) -> void:
	session_time += delta
	return

func parse_mouse_sensitivity():
	return mouse_sensitivity / mouse_sensitivity_scale

func parse_master_volume():
	return lerpf(min_master_volume, max_master_volume, (master_volume_percent/100))

func apply_master_volume():
	var new_volume_level: float = parse_master_volume()
	AudioServer.set_bus_volume_db(0, parse_master_volume())
	prints(self.name, "Volume set:", AudioServer.get_bus_volume_db(0))
	return

func apply_mouse_sensitivity():
	for mouse_user in get_tree().get_nodes_in_group("mouse_users"):
		mouse_user.mouse_sensitivity = parse_mouse_sensitivity()
	return
