extends Node

var prop_table: Dictionary = {
	"credits": {
		# [Player]: [credits]
	}
} # Don't remove this lol

#var iid_table: Dictionary = {
	#1000: null # magic start index
#}

var iid_table: Dictionary = {
	1: {
		1000: null
	}
}

enum skill_levels {
	SWEET_DREAMS,
	ROUGH_NIGHT,
	NIGHT_TERROR,
	PARALYSIS
}
var skill_level: int = skill_levels.SWEET_DREAMS

@rpc("any_peer", "call_local")
func init_peer(peer_id: int):
	iid_table[peer_id] = {
		1000: null
	}
	return

func new_iid(item_name: String):
	var key_sum: int = 0
	for k in iid_table[multiplayer.get_unique_id()].keys():
		key_sum += k
	var last_key: int = key_sum / len(iid_table[multiplayer.get_unique_id()].keys()) + 1
	var new_key: int = last_key + 1
	iid_table[multiplayer.get_unique_id()][new_key] = item_name
	
	if U.is_networked():
		net_update_iid_table.rpc(multiplayer.get_unique_id(), new_key, item_name)
	return new_key

@rpc("any_peer", "call_remote")
func net_update_iid_table(peer_id: int, table_key: int, item_name: String):
	iid_table[peer_id][table_key] = item_name
	return

@rpc("any_peer", "call_local")
func reset_iid_table():
	iid_table[multiplayer.get_unique_id()].clear()
	iid_table[multiplayer.get_unique_id()][1000] = null
	return

@rpc("any_peer", "call_local")
func remove_iid(iid: int):
	iid_table[multiplayer.get_unique_id()].erase(iid)
	return
