extends Node

const FIST_IID: int = -9
var melee_registry: Dictionary = {
	"crowbar": {
		"name": "crowbar",
		"scene": preload("res://Scenes/crowbar.tscn"),
		"world_item": preload("res://Scenes/w_crowbar.tscn")
	},
	"katana": {
		"name": "katana",
		"scene": preload("res://Scenes/katana.tscn"),
		"world_item": preload("res://Scenes/w_katana.tscn")
	}
	
}

var registry: Dictionary = {
	"fist": {
		"name": "fist",
		"slot_num": 1,
		"scene": preload("res://Scenes/fist.tscn"),
		"iid": FIST_IID
	},
	"pistol_9mm": {
		"name": "pistol_9mm",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SEMI_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 18,
		"scene": preload("res://Scenes/pistol_9_mm.tscn"),
		"world_item": preload("res://Scenes/w_pistol_9_mm.tscn"),
		"iid": -1
	},
	"pistol_9mm_s": {
		"name": "pistol_9mm_s",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SEMI_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 18,
		"scene": preload("res://Scenes/pistol_nine_silenced.tscn"),
		"world_item": preload("res://Scenes/w_pistol_nine_silenced.tscn"),
		"iid": -1
	},
	"pistol_anonpm": {
		"name": "pistol_anonpm",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SEMI_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 8,
		"scene": preload("res://Scenes/pistol_anonpm.tscn"),
		"world_item": preload("res://Scenes/w_pistol_anonpm.tscn"),
		"iid": -1
	},
	"python_357": {
		"name": "python_357",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SINGLE_ACTION,
		"ammo_type": U.ammo_types.THREE_FIFTY_SEVEN,
		"ammo_count": 0,
		"mag_size": 6,
		"scene": preload("res://Scenes/python_357.tscn"),
		"world_item": preload("res://Scenes/w_python_357.tscn"),
		"iid": -1
	},
	"beretta_nine": {
		"name": "beretta_nine",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SEMI_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 15,
		"scene": preload("res://Scenes/beretta_nine.tscn"),
		"world_item": preload("res://Scenes/w_beretta_nine.tscn"),
		"weapon_theme": U.weapon_themes.LIGHT,
		"iid": -1
	},
	"beretta_nine_s": {
		"name": "beretta_nine_s",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SEMI_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 15,
		"scene": preload("res://Scenes/beretta_nine_silenced.tscn"),
		"world_item": preload("res://Scenes/w_beretta_nine_silenced.tscn"),
		"iid": -1
	},

	"beretta_nine_r": {
		"name": "beretta_nine_r",
		"slot_num": 2,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 20,
		"scene": preload("res://Scenes/beretta_nine_r.tscn"),
		"world_item": preload("res://Scenes/w_beretta_nine_r.tscn"),
		"iid": -1
	},
	#"beretta_nine_r_s": {
		#"name": "beretta_nine_r_s",
		#"slot_num": 2,
		#"fire_mode": U.fire_modes.SEMI_AUTO,
		#"ammo_type": U.ammo_types.NINE_MM,
		#"ammo_count": 0,
		#"mag_size": 20,
		#"scene": preload("res://Scenes/beretta_nine_r_silenced.tscn"),
		#"world_item": preload("res://Scenes/w_beretta_nine_r_silenced.tscn"),
		#"iid": -1
	#},


	"revolver_octo_45": {
		"name": "revolver_octo_45",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SEMI_AUTO,
		"ammo_type": U.ammo_types.FORTY_FIVE,
		"ammo_count": 0,
		"mag_size": 6,
		"scene": preload("res://Scenes/revolver_octo_45.tscn"),
		"world_item": preload("res://Scenes/w_revolver_octo_45.tscn"),
		"iid": -1
	},
	"pistol_fifty": {
		"name": "pistol_fifty",
		"slot_num": 2,
		"fire_mode": U.fire_modes.SEMI_AUTO,
		"ammo_type": U.ammo_types.FIFTY,
		"ammo_count": 0,
		"mag_size": 7,
		"scene": preload("res://Scenes/pistol_fifty.tscn"),
		"world_item": preload("res://Scenes/w_pistol_fifty.tscn"),
		"iid": -1
	},
	"autopistol_9_mm": {
		"name": "autopistol_9_mm",
		"slot_num": 2,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 24,
		"scene": preload("res://Scenes/autopistol_9_mm.tscn"),
		"world_item": preload("res://Scenes/w_autopistol_9_mm.tscn"),
		"iid": -1
	},
	"mac10_45mm": {
		"name": "mac10_45mm",
		"slot_num": 2,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.FORTY_FIVE,
		"ammo_count": 0,
		"mag_size": 25,
		"scene": preload("res://Scenes/mac10_45mm.tscn"),
		"world_item": preload("res://Scenes/w_mac10_45mm.tscn"),
		"iid": -1
	},
	"imi_uzi": {
		"name": "imi_uzi",
		"slot_num": 4,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 32,
		"scene": preload("res://Scenes/imi_uzi.tscn"),
		"world_item": preload("res://Scenes/w_imi_uzi.tscn"),
		"iid": -1
	},
	"m3a1_45mm": {
		"name": "m3a1_45mm",
		"slot_num": 4,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.FORTY_FIVE,
		"ammo_count": 0,
		"mag_size": 30,
		"scene": preload("res://Scenes/m3a1_45mm.tscn"),
		"world_item": preload("res://Scenes/w_m3a1_45mm.tscn"),
		"iid": -1
	},
	"mp5t_9mm": {
		"name": "mp5t_9mm",
		"slot_num": 4,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 30,
		"scene": preload("res://Scenes/mp5t_9mm.tscn"),
		"world_item": preload("res://Scenes/w_mp5t_9mm.tscn"),
		"iid": -1
	},

	"mp5t_9mm_ext": {
		"name": "mp5t_9mm_ext",
		"slot_num": 4,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 50,
		"scene": preload("res://Scenes/mp5t_9mm_ext.tscn"),
		"world_item": preload("res://Scenes/w_mp5t_9mm_ext.tscn"),
		"iid": -1
	},

	"m_16_nato": {
		"name": "m_16_nato",
		"slot_num": 4,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.NATO,
		"ammo_count": 0,
		"mag_size": 15,
		"scene": preload("res://Scenes/m_16_nato.tscn"),
		"world_item": preload("res://Scenes/w_m_16_nato.tscn"),
		"iid": -1
	},
	"tabas_ak47": {
		"name": "tabas_ak47",
		"slot_num": 4,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.SEVEN_SIXTY_TWO,
		"ammo_count": 0,
		"mag_size": 30,
		"scene": preload("res://Scenes/tabas_ak47.tscn"),
		"world_item": preload("res://Scenes/w_tabas_ak47.tscn"),
		"iid": -1
	},
	"shotgun_buster": {
		"name": "shotgun_buster",
		"slot_num": 3,
		"fire_mode": U.fire_modes.SINGLE_ACTION,
		"ammo_type": U.ammo_types.SHELLS,
		"ammo_count": 0,
		"mag_size": 8,
		"scene": preload("res://Scenes/shotgun_buster.tscn"),
		"world_item": preload("res://Scenes/w_shotgun_buster.tscn"),
		"iid": -1
	},
	"shotgun_spas12": {
		"name": "shotgun_spas12",
		"slot_num": 3,
		"fire_mode": U.fire_modes.SINGLE_ACTION,
		"ammo_type": U.ammo_types.SHELLS,
		"ammo_count": 0,
		"mag_size": 8,
		"scene": preload("res://Scenes/shotgun_spas12.tscn"),
		"world_item": preload("res://Scenes/w_shotgun_spas12.tscn"),
		"iid": -1
	},

	"shotgun_onebarrel": {
		"name": "shotgun_onebarrel",
		"slot_num": 3,
		"fire_mode": U.fire_modes.SINGLE_ACTION,
		"ammo_type": U.ammo_types.SHELLS,
		"ammo_count": 0,
		"mag_size": 1,
		"scene": preload("res://Scenes/shotgun_onebarrel.tscn"),
		"world_item": preload("res://Scenes/w_shotgun_onebarrel.tscn"),
		"iid": -1
	},
	"shotgun_doublebarrel": {
		"name": "shotgun_doublebarrel",
		"slot_num": 3,
		"fire_mode": U.fire_modes.SINGLE_ACTION,
		"consecutive_shots": 2,
		"ammo_type": U.ammo_types.SHELLS,
		"ammo_count": 0,
		"mag_size": 2,
		"scene": preload("res://Scenes/shotgun_doublebarrel.tscn"),
		"world_item": preload("res://Scenes/w_shotgun_doublebarrel.tscn"),
		"iid": -1
	},
	"smg_9mm": {
		"name": "smg_9mm",
		"slot_num": 4,
		"fire_mode": U.fire_modes.FULL_AUTO,
		"ammo_type": U.ammo_types.NINE_MM,
		"ammo_count": 0,
		"mag_size": 30,
		"scene": preload("res://Scenes/smg_9_mm.tscn"),
		"world_item": preload("res://Scenes/w_smg_9_mm.tscn"),
		"iid": -1
	}
}

func by_name(weapon_name: String):
	return registry[weapon_name]

func register(
	weapon_name: String,
	slot_num: int,
	ammo_type: int,
	ammo_count: int,
	mag_size: int,
	scene: Resource,
	world_item: Resource,
	iid: int):
		#if weapon_name in held_items:
		return
