extends Node

var enabled: bool = true
var mouse_mode: int = Input.MOUSE_MODE_VISIBLE :
	set(value):
		mouse_mode = value
		Input.mouse_mode = value
	get:
		return mouse_mode

var event_queue: Array = []
var event_queue_expiration_interval: float = 0.1
var event_queue_expiration_ticker: float = event_queue_expiration_interval
var action_state_table: Dictionary = {}

func _physics_process(delta):
	event_queue_expiration_ticker -= delta
	if event_queue_expiration_ticker < 0.0:
		event_queue_expiration_triggered()
		event_queue_expiration_ticker = event_queue_expiration_interval
	
	#if U.is_networked():
		#pass
	
	### DEBUG ###
	#if U.is_networked():
		#var my_peer: int = multiplayer.get_unique_id()
		#var player_node_peer: int = self.get_parent().get_multiplayer_authority()
		#var player_name_peer: int = self.get_parent().name.to_int()
		#if U.is_networked() and (my_peer != player_node_peer):
			#prints(self.name, "|client:", my_peer, "|player_owner:", player_node_peer, "|player_node_name:", player_name_peer, event_queue)
			#pass
	return

func get_vector(action_left: String, action_right: String, action_forward: String, action_backward: String):
	if not enabled: return Vector2.ZERO
	
	# As a very bad workaround (for now?) this will always return movement keys
	# from the action state table in the input proxy
	# The reason the other method didn't work is it didn't catch all the
	# keys all the time and probably didn't know when keys were
	# released n' stuff
	if U.is_networked():
		return action_state_table["movekeys_vector"]
	
	if not U.is_networked():
		return Input.get_vector(action_left, action_right, action_forward, action_backward)
	
	return

func is_action_just_pressed(action_name: String):
	if not enabled: return false
	
	if U.is_networked():
		return action_state_table[action_name]["is_action_just_pressed"]
	if not U.is_networked():
		return Input.is_action_just_pressed(action_name)

func is_action_just_released(action_name: String):
	if not enabled: return false
	
	if U.is_networked():
		return action_state_table[action_name]["is_action_just_released"]
	if not U.is_networked():
		return Input.is_action_just_released(action_name)

func is_action_pressed(action_name: String):
	if not enabled: return false
	
	if U.is_networked():
		return action_state_table[action_name]["is_action_pressed"]
	if not U.is_networked():
		return Input.is_action_pressed(action_name)

@rpc("any_peer", "call_local")
func update_event_queue(event_dict: Dictionary):
	# For some reason I thought one event happened per tick but that makes no sense.
	# _unhandled_input must call every time an input event fires. Don't clear on update, clear on consumption
	# or timeout or something
	# event_queue.clear() 
	
	# Also, assume these events are only ever mouse motion events (lol)
	
	var new_event: InputEvent = U.dict_to_mouse_motion(event_dict)
	
	### DEBUG ###
	#if multiplayer.get_unique_id() != 1:
		#prints(self.name, "update_event_queue | my_peer:", multiplayer.get_unique_id(), "sender:", multiplayer.get_remote_sender_id())
		#prints(randf(), ">", new_event)
		## confirmed, it's being received by the client as an arg
		## confirmed, new_event is being converted properly
	
	event_queue.append(new_event)
	#if new_event is InputEventMouseMotion:
	if not self.is_multiplayer_authority():
		self.get_parent().unhandled_input_proxy(new_event)
	
	await get_tree().process_frame
	event_queue.erase(new_event)
	return

func event_queue_expiration_triggered():
	event_queue.pop_front() # INTO THE ABYSS
	return

@rpc("any_peer", "call_local")
func update_action_state_table(new_table: Dictionary):
	action_state_table = new_table
	return
