extends Node3D

signal ballprobe_launch_finished(launched_ballprobes)

var actor: Node3D
@onready var nav_agent: NavigationAgent3D = $NavigationAgent3D
@onready var ball_probe_master: RigidBody3D = $actor_ballprobe_master
var ball_spawn_height: float = 4.25
var ballprobes: Array = []
var is_ballprobe_deployed: bool = false
@export var launch_speed: float = 13.0
var max_launch_y: float = 60.0
var min_launch_y: float = 25.0 # 55.0
var base_launch_lift: float = 4.25
var ball_mass: float = 1.57

func _ready() -> void:
	return

func _physics_process(delta: float) -> void:
	#if is_ballprobe_deployed:
		#return
	
	# TEMP (?)
	if ballprobes.size() > 0:
		prints(self.name, "ballprobes array not yet implemented. Clearing ballprobes:", ballprobes.size())
		ballprobes.clear()
	return

func create_ballprobe(launch_impulse: Vector3 = Vector3.ZERO) -> RigidBody3D:
	var new_ball: RigidBody3D = ball_probe_master.duplicate()
	new_ball.name = "actor_ballprobe"
	Blackboard.current_world.add_child(new_ball)
	new_ball.visible = true
	new_ball.mass = self.ball_mass
	new_ball.global_position = self.global_position + Vector3(0, ball_spawn_height, 0)
	new_ball.process_mode = Node.PROCESS_MODE_INHERIT
	ballprobes.append(new_ball)
	if actor:
		new_ball.actor = self.actor
		new_ball.add_collision_exception_with(self.actor)
	
	if launch_impulse:
		new_ball.apply_central_impulse(launch_impulse)
	return new_ball

func launch_ballprobes(directions: Array, viewtarget: PhysicsBody3D) -> Dictionary:
	# For every direction
	# {direction: collider}
	var new_ballprobes: Array = []
	#var launch_speed: float = 13.0
	for direction in directions:
		var newball = create_ballprobe()
		newball.viewtarget = viewtarget
		newball.visible = self.visible
		new_ballprobes.append(newball)
		if actor:
			newball.add_collision_exception_with(self.actor)
		
		
		var launch_vec: Vector3 = Vector3(
			direction.x,
			base_launch_lift,
			direction.y
		).rotated(Vector3.UP, self.global_rotation.y)
		
		launch_vec = launch_vec * launch_speed
		launch_vec.y = clampf(launch_vec.y, min_launch_y, max_launch_y)
		newball.apply_central_impulse(launch_vec)
	
	await get_tree().create_timer(2.0).timeout
	var ballprobe_results: Dictionary = {}
	for new_ballprobe in new_ballprobes:
		ballprobe_results[new_ballprobe] = new_ballprobe.get_viewtarget_collision()
	return ballprobe_results

