extends StaticBody3D

@onready var game_panel: Panel3D = $Panel3D
var game: Control
var user: Node3D
var user_anim: AnimationPlayer
var original_user_transform: Transform3D
var original_user_pos: Vector3
var original_user_rot: Vector3

func _ready():
	return

func _physics_process(delta):
	#if user:
		#user.global_position = $player_position.global_position
		#user.global_rotation = $player_position.global_rotation
	if user:
		animate_user(game.get_node("virtualinput").current_user_anim)
	return

func interact(caller: Node3D):
	caller.player_interface = self
	user = caller
	user_anim = caller.anim
	original_user_transform = user.global_transform
	$Camera3D.make_current()
	freeze_user()
	activate_game()
	await get_tree().create_timer(.1).timeout
	animate_user("arcade_box_idle")
	# BACKUP vv
	original_user_pos = user.global_position
	original_user_rot = user.global_rotation
	# BACKUP ^^
	user.global_position = $player_position.global_position
	user.global_rotation = $player_position.global_rotation
	return

func animate_user(animation_name: String):
	user.anim.play(animation_name)
	return

func freeze_user():
	user.is_input_allowed = false
	user.is_mouselook_locked = true
	
	return

func unfreeze_user():
	user.is_input_allowed = true
	user.is_mouselook_locked = false
	return

func reset_game():
	#set_viewport_scene(_auto_load_ui.instantiate())
	game = game_panel._auto_load_ui.instantiate()
	game.world_instance = self
	game_panel.set_viewport_scene(
		game
	)
	return

func activate_game():
	reset_game()
	game.enable_game()
	game.enable_input()
	return

func deactivate_game():
	reset_game()
	game.disable_game()
	game.disable_input()
	return

func release(caller: Node3D):
	self.remove_from_group("interactables")
	unfreeze_user()
	deactivate_game()
	#user.global_position = original_user_transform.origin
	#user.global_rotation = original_user_transform.origin
	user.global_position = original_user_pos
	user.global_rotation = original_user_rot
	user.player_interface = null
	user = null
	await get_tree().create_timer(.5).timeout
	self.add_to_group("interactables")
	return

func push_event(event: InputEvent):
	return
