extends Node

@export_node_path("Control") var arcade_game_npath
var arcade_game: Control
@export var arcade_player: CharacterBody2D
@export var disabled: bool = false
var current_user_anim: String = "arcade_box_idle"
var idle_time: float

func _ready():
	return


func _process(delta):
	if disabled:
		return
	
	idle_time += delta
	if not arcade_game_npath:
		return
	
	if not arcade_game:
		arcade_game = get_node(arcade_game_npath)
	
	process_input()
	return

func process_input():
	if arcade_game.is_on_title_screen:
		if Input.is_anything_pressed():
			arcade_game.leave_title_screen()
		return
	
	# Handle jump.
	if Input.is_action_just_pressed("ui_accept") and arcade_player.is_on_floor():
		arcade_player.velocity.y = arcade_player.JUMP_VELOCITY

	# Get the input direction and handle the movement/deceleration.
	# As good practice, you should replace UI actions with custom gameplay actions.
	var direction = Input.get_axis("strafe_left", "strafe_right")
	if direction:
		arcade_player.velocity.x = direction * arcade_player.SPEED
	else:
		arcade_player.velocity.x = move_toward(arcade_player.velocity.x, 0, arcade_player.SPEED)
	
	if Input.is_action_pressed("strafe_left"):
		arcade_player.set_facing_dir(arcade_player.DIR_LEFT)
	elif Input.is_action_pressed("strafe_right"):
		arcade_player.set_facing_dir(arcade_player.DIR_RIGHT)
	
	if Input.is_action_just_pressed("special"):
		arcade_player.kick()
	
	if Input.is_action_just_pressed("primary_action"):
		arcade_player.punch()
	
	####
	
	
	
	if Input.is_anything_pressed():
		idle_time = 0.0
	if Input.is_action_pressed("strafe_left") and not Input.is_action_just_pressed("primary_action") and not Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_moveleft"
	elif Input.is_action_pressed("strafe_right") and not Input.is_action_just_pressed("primary_action") and not Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_moveright"
	
	elif Input.is_action_pressed("strafe_left") and Input.is_action_just_pressed("primary_action") and not Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_button_a_moveleft"
	elif Input.is_action_pressed("strafe_left") and not Input.is_action_just_pressed("primary_action") and Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_button_b_moveleft"
		
	elif Input.is_action_pressed("strafe_right") and Input.is_action_just_pressed("primary_action") and not Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_button_a_moveright"
	elif Input.is_action_pressed("strafe_right") and not Input.is_action_just_pressed("primary_action") and Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_button_b_moveright"
	
	elif not Input.is_action_pressed("strafe_left") and not Input.is_action_pressed("strafe_right") and Input.is_action_just_pressed("primary_action") and not Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_button_a"
	elif not Input.is_action_pressed("strafe_left") and not Input.is_action_pressed("strafe_right") and not Input.is_action_just_pressed("primary_action") and Input.is_action_just_pressed("special"):
		current_user_anim = "arcade_button_b"
	else:
		if idle_time > 0.4:
			current_user_anim = "arcade_box_idle"
	return
