extends StaticBody3D

@export var is_explosive: bool = true
var model: Node3D
@onready var exploding_model: Node3D = $exploded_barrel
var health: int = 24
var blast_radius: float = 17.0
var raw_damage: int = 360 #180

func _ready():
	if is_explosive:
		model = $model_explosive
	else:
		model = $model_non_explosive
	
	$exploded_barrel/barrel_cell_013.visible = false
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	#self.global_position.y += 1
	health -= damage
	if health > 0:
		return
	
	$CollisionShape3D.disabled = true
	self.remove_from_group("hit_takers")
	
	for hit_taker in get_tree().get_nodes_in_group("hit_takers"):
		if hit_taker.name == "mook_biker_2":
			pass
		var distance: float = hit_taker.global_position.distance_to(self.global_position)
		if distance > blast_radius:
			continue
		if hit_taker == self:
			continue
		var adjusted_damage: int = snappedi((distance / blast_radius) * raw_damage, 1)
		
		hit_taker.hit(adjusted_damage, U.hit_types.UNDEFINED, self, self.global_position)
		if is_instance_of(hit_taker, CharacterBody3D):
			if hit_taker.has_method("flinch_control"):
				hit_taker.flinch_control()
			hit_taker.velocity.y += 25.0 #22.0 #15.0
		
	
	#$CollisionShape3D.disabled = true
	model.visible = false
	exploding_model.visible = true
	#$explosion_2/AnimationPlayer.play("activate")
	exploding_model.get_node("AnimationPlayer").play("Animation")
	
	$explode_sound.play()
	$debris_sound.play()
	
	$explosion_static/AnimationPlayer.play("activate")
	$explosion_static.visible = true
	await get_tree().create_timer(1.0).timeout
	$explosion_static.visible = false
	return
