extends Node3D

var actor: CharacterBody3D
var hand: int = -1
var hud_name: String = "beretta_nine_r"
var size: int = U.weapon_sizes.PISTOL
var fire_mode: int = U.fire_modes.FULL_AUTO
var fire_rate: float = 750 #600.00
var sound_distance: float = 80.0
@onready var raycast: RayCast3D = $RayCast3D
@onready var anim: AnimationPlayer = $model/AnimationPlayer
@onready var aim_dot: MeshInstance3D = $aim_dot
@onready var mag_model: Node3D = $Cache/pistol_9mm_mag

var default_shoot_sound_pitch: float = 1
var default_aim_dot_color: Color = Color(1, 1, 1, 1)
@export var target_aim_dot_color: Color = Color(1, 0, 0, 0.5216)
@export var notarget_aim_dot_color: Color = Color(1, 1, 1, 1)

@export var prop_weapon: bool = false
@export var suppress_aimdot: bool = false

@onready var shoot_sounds: Array = $Sounds.find_children("s_shoot_*")

var damage: int = 12
var knockback_force: float = 15.0
var recoil: float = 2.5
var primary_action_type: int = U.primary_action_types.HOLD
var is_shooting: bool = false
var is_fire_ready: bool = true
var shoot_caller: Node
#var shoot_time: float = 0.1
var callback_data: Dictionary
var finished_shot_callback: Callable
var shoot_tick_counter: float = -1.0

var burst_shot_limit: int = 3
var burst_shot_count: int = 0

var csgbox: Resource = preload("res://Scenes/csg_box_subtract_test.tscn")

func _ready():
	if prop_weapon:
		raycast.enabled = false
		aim_dot.visible = false
	return


#func _process(delta):
func _physics_process(delta):
	if not prop_weapon:
		aim_dot_control()
	
	if is_shooting:
		#shoot_tick_counter += delta
		#if shoot_tick_counter > (60/fire_rate):
		if shoot_tick_counter < 0.0:
			shoot()
			shoot_tick_counter = (60/fire_rate)
			burst_shot_count += 1
			if burst_shot_count >= burst_shot_limit:
				shoot_tick_counter = 999.0 # hack to allow shoot delay
				await get_tree().create_timer(.1).timeout
				is_shooting = false
				
				burst_shot_count = 0
		
		shoot_tick_counter -= delta
	return

func aim_dot_control():
	if suppress_aimdot:
		aim_dot.visible = false
		return
	
	if raycast.is_colliding():
		var collision_point: Vector3 = raycast.get_collision_point()
		var aim_distance: float = self.global_position.distance_to(collision_point)
		if aim_distance < 2.0:
			aim_dot.visible = false
		else:
			aim_dot.visible = true
		
		var aim_dot_material: Material = aim_dot.get_active_material(0)
		var collider: Object = raycast.get_collider()
		if collider and raycast.get_collider().is_in_group("actors"):
			aim_dot_material.albedo_color = target_aim_dot_color #Color(1, 0, 0, 0.5216)
		else:
			aim_dot_material.albedo_color = notarget_aim_dot_color #default_aim_dot_color
		aim_dot.global_position = collision_point
	else:
		aim_dot.visible = false
	return

func shell_casing_control():
	var new_shell_casing: Node3D = $'Lazy Cache/9_mm_shell_casing'.duplicate()
	var assumed_world = get_tree().get_first_node_in_group("Worlds")
	assumed_world.add_child(new_shell_casing)
	new_shell_casing.global_position = $'Lazy Cache/9_mm_shell_casing'.global_position
	new_shell_casing.global_rotation = $'Lazy Cache/9_mm_shell_casing'.global_rotation
	var anim_choice_index: int = randi_range(0, 2)
	var anim_name: String = ["eject", "eject_2", "eject_3"][anim_choice_index]
	new_shell_casing.get_node("AnimationPlayer").play(anim_name)
	new_shell_casing.process_mode = Node.PROCESS_MODE_INHERIT
	return

func semi_auto_shoot(caller):
	anim.stop()
	anim.play("shoot semi")
	#impact_control()
	return

func full_auto_shoot(caller):
	randomize_shoot_pitch()
	if is_shooting:
		return
	
	#$shoot_timer.start(shoot_time)
	is_shooting = true
	anim.play("shoot auto")
	#impact_control() # Called in animation
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position)
		caller.recoil_kick(recoil)
	return

func stop_action():
	trigger_up()
	
	anim.stop()
	anim.play("idle")
	return

func randomize_shoot_pitch():
	var new_pitch: float = randf_range(0.9, 1.1)
	#var first_step: int = randi_range(0, 2)
	#if first_step == 0:
		#new_pitch = randf_range(1.3, 1.5)
	#elif first_step == 1:
		#new_pitch = randf_range(1.5, 1.7)
	#elif first_step == 2:
		#new_pitch = 2.0
	for shoot_sound in shoot_sounds:
		shoot_sound.pitch_scale = new_pitch
	return

func primary_action(caller):
	#full_auto_shoot(caller)
	trigger_down(caller)
	return

func trigger_down(caller: Node):
	if is_shooting:
		return
	if not is_fire_ready:
		return
	
	is_fire_ready = false
	shoot_caller = caller
	is_shooting = true
	return

func trigger_up():
	#if is_shooting: return
	#shoot_caller = null
	#is_shooting = false
	is_fire_ready = true
	shoot_tick_counter = -1.0
	return

func shoot():
	if not shoot_caller:
		return
	randomize_shoot_pitch()
	anim.play("shoot")
	#U.random_choice(shoot_sounds).play()
	if burst_shot_count > (shoot_sounds.size() - 1):
		U.random_choice(shoot_sounds).play()
	else:
		shoot_sounds[burst_shot_count].play()
	
	flash_muzzle_flare()
	
	A.create_impact(actor, raycast, damage, knockback_force)
	
	if not prop_weapon:
		U.spawn_sound_ball(actor, actor.global_position, sound_distance)
		shoot_caller.recoil_kick(recoil)
	
	# Called immediately and not after the animation.
	# I don't think that's a problem.
	if finished_shot_callback:
		finished_shot_callback.call(callback_data["hand"], callback_data["iid"])
	
	$muzzle_flare
	return

func reload(caller):
	$Sounds/reload.play()
	#anim.play("reload")
	anim.queue("idle")
	drop_mag()
	return

func dry_fire(caller):
	stop_action()
	$Sounds/dryfire.play()
	return

func _on_delayed_ticker_timeout():
	return

func show_as_empty():
	anim.stop()
	anim.play("empty")
	return

func flash_muzzle_flare():
	$muzzle_flare.visible = true
	$muzzle_flare_light.visible = true
	await get_tree().create_timer(.07).timeout
	$muzzle_flare.visible = false
	$muzzle_flare_light.visible = false
	return

func drop_mag():
	mag_model.position = Vector3.ZERO
	
	var new_mag_model: Node3D = mag_model.duplicate()
	Blackboard.current_world.add_child(new_mag_model)
	new_mag_model.global_position = mag_model.global_position
	new_mag_model.visible = true
	var duration: float = 1.2
	var final_global_position: Vector3 = new_mag_model.global_position
	final_global_position += Vector3(0.3, -5.4, 0.0)
	var final_global_rotation: Vector3 = new_mag_model.global_rotation
	final_global_rotation += Vector3(25.0, 0.0, 5.0)
	get_tree().create_tween().tween_property(new_mag_model, "global_position", final_global_position, duration).set_trans(Tween.TRANS_QUAD) #.set_trans(Tween.TRANS_BACK)
	get_tree().create_tween().tween_property(new_mag_model, "global_rotation", final_global_rotation, duration).set_trans(Tween.TRANS_CUBIC)
	await get_tree().create_timer(duration).timeout
	new_mag_model.queue_free()
	return
