extends StaticBody3D

@export var book_content: PackedScene
@export var spawn_opened: bool = false
@onready var anim: AnimationPlayer = $mazander_book_oga/AnimationPlayer
@export var book_file_name: String = "kjv.txt"
var book_lines: PackedStringArray
var book_index: int :
	get:
		return book_index
	set(value):
		book_index = value
		update_book_index_display()
		

var is_reading: bool = false
var previous_user: Node
var previous_user_camera: Camera3D
var scroll_offset: float = 0.050
var zero_scroll_pos: float = -0.299

func _ready():
	#$dummy.visible = false
	#$mazander_book_oga.visible = true
	if spawn_opened:
		anim.play("booktop_opening_smooth")
	if book_file_name == "kjv.txt":
		book_index = 47
	return

func interact(caller: Node3D):
	if is_reading:
		$book_camera/AnimationPlayer.play("stop_interact")
		await get_tree().create_timer(0.5).timeout
		previous_user_camera.make_current()
		previous_user_camera = null
		is_reading = false
		unload_book()
		close_book()
		return
	
	$book_camera/AnimationPlayer.play("start_interact")
	$book_camera/AnimationPlayer.queue("loop")
	previous_user = caller
	previous_user_camera = get_viewport().get_camera_3d()
	$book_camera.make_current()
	
	prints(self.name, "calling open_book()")
	open_book()
	prints(self.name, "calling load_book()")
	load_book()
	prints(self.name, "calling display_page_text()")
	display_page_text(book_index)
	
	is_reading = true
	previous_user.is_reading = true
	previous_user.current_book = self
	return

func open_book():
	$paper_sound_2.play()
	anim.play("booktop_opening_smooth")
	return

func close_book():
	$paper_sound_2.play()
	anim.play_backwards("booktop_opening_smooth")
	return

func fake_pageturn():
	close_book()
	
	await get_tree().create_timer(
		anim.get_animation("booktop_opening_smooth").length
	).timeout
	
	open_book()
	return

func next_page():
	$paper_sound_1.play()
	book_index += 1
	if book_index > (book_lines.size() - 1):
		book_index = 0
	#fake_pageturn()
	display_page_text(book_index)
	return

func previous_page():
	$paper_sound_1.play()
	book_index -= 1
	if book_index < 0:
		book_index = (book_lines.size() - 1)
	#fake_pageturn()
	display_page_text(book_index)
	return

func scroll_page(direction: int = 1):
	if direction == 0:
		return
	if direction == 1:
		$book_content_display.position.z -= scroll_offset
		return
	if direction == -1:
		$book_content_display.position.z += scroll_offset
		return
	return

func load_book():
	var book_file = FileAccess.open("res://Content/Books/" + book_file_name, FileAccess.READ)
	book_lines = PackedStringArray(book_file.get_as_text().split("\n"))
	update_book_index_display()
	return

func unload_book():
	book_lines.clear()
	$book_content_display.text = ""
	return

func display_page_text(index: int):
	$book_content_display.position.z = zero_scroll_pos
	var new_text = book_lines[index]
	$book_content_display.text = book_lines[index]
	return

func update_book_index_display():
	$book_index_display.text = "i " + str(book_index)
	return
