extends Noko

@onready var bravura_anim: AnimationPlayer = $graphics/noko/detective_bravura/AnimationPlayer
var torso_cam_original_rot: Vector3 = Vector3(0.0, -180.0, 0.0)
var torso_cam_crouch_rot: Vector3 = torso_cam_original_rot + Vector3(12.0, 0.0, 0.0)
var torso_cam_crouch_pistol_rot: Vector3 = torso_cam_original_rot + Vector3(42.0, 0.0, 0.0)
var torso_cam_original_pos: Vector3 = Vector3(0.0, 0.46, 0.7)
var torso_cam_crouch_pos: Vector3 = torso_cam_original_pos + Vector3(0.0, 0.62, 0.20)
var torso_cam_crouch_pistol_pos: Vector3 = torso_cam_original_pos + Vector3(0.0, 1.12, 0.20)


func _post_init() -> void:
	var bravura_anim_lib: AnimationLibrary = bravura_anim.get_animation_library("")
	for new_animation_name in bravura_anim_lib.get_animation_list():
		var new_animation: Animation = bravura_anim_lib.get_animation(new_animation_name)
		anim.get_animation_library("").add_animation(new_animation_name, new_animation)
	#anim.get_animation_library("").add_animation("unarmed_run_alt", bravura_anim_lib.get_animation("unarmed_run"))
	
	crouch_cam_offset_y = 2.0
	heavy_punch_damage = 57
	self.kick_combo_enabled = false
	footlift_criteria = ["is_crouching", "is_kick_sliding"]
	default_dance_anim = "gesture_maxy_dance_1"
	return

func _proc_insert() -> void:
	#if self.is_crouching and not self.is_kick_sliding:
		#$hitbox_feet.disabled = false
	#else:
		#$hitbox_feet.disabled = true
	
	
	if not self.is_freecarrot:
		proc_custom_camrot()
	#if self.is_crouching and self.torso_cam.current:
		## Adjust for pistol vs non-pistol since the animation hunches the back!
		#var adjusted_rot: Vector3
		#var adjusted_pos: Vector3
		#var rhand_weap: Node3D = slot_manager.get_held_weapon(U.hands.RIGHT)
		#if rhand_weap.get("size") == U.weapon_sizes.PISTOL or not self.is_armed_twohanded:
			#adjusted_rot = torso_cam_crouch_pistol_rot
			#adjusted_pos = torso_cam_crouch_pistol_pos
		#else:
			#adjusted_rot = torso_cam_crouch_rot
			#adjusted_pos = torso_cam_crouch_pos
		#self.torso_cam.rotation_degrees = adjusted_rot
		##self.torso_cam.rotation_degrees *= Vector3(adjusted_rot.x, 1, adjusted_rot.z)
		#self.torso_cam.position = adjusted_pos
	#else:
		##self.torso_cam.rotation_degrees = torso_cam_original_rot
		#self.torso_cam.rotation_degrees *= Vector3(torso_cam_original_rot.x, 1, torso_cam_original_rot.z)
		#self.torso_cam.position = torso_cam_original_pos
	return

func proc_custom_camrot() -> void:
	if self.is_crouching and self.torso_cam.current:
		# Adjust for pistol vs non-pistol since the animation hunches the back!
		var adjusted_rot: Vector3
		var adjusted_pos: Vector3
		var rhand_weap: Node3D = slot_manager.get_held_weapon(U.hands.RIGHT)
		if not rhand_weap:
			return
		if rhand_weap.get("size") == U.weapon_sizes.PISTOL or not self.is_armed_twohanded:
			adjusted_rot = torso_cam_crouch_pistol_rot
			adjusted_pos = torso_cam_crouch_pistol_pos
		else:
			adjusted_rot = torso_cam_crouch_rot
			adjusted_pos = torso_cam_crouch_pos
		self.torso_cam.rotation_degrees = adjusted_rot
		#self.torso_cam.rotation_degrees *= Vector3(adjusted_rot.x, 1, adjusted_rot.z)
		self.torso_cam.position = adjusted_pos
	else:
		#self.torso_cam.rotation_degrees = torso_cam_original_rot
		self.torso_cam.rotation_degrees *= Vector3(torso_cam_original_rot.x, 1, torso_cam_original_rot.z)
		self.torso_cam.position = torso_cam_original_pos
	return

func kick_slide() -> void:
	if self.is_kick_sliding:
		return
	self.velocity.y += 8
	super.kick_slide()
	return
