extends CharacterBody3D


# Next
# - Explosive "barrels"
# - Narrative elements
# - AI: Civilians

# Fixes
# ...

# Ideas
# - Add Rooster (companion? Enemy? Dev second player?)
# x Doom Berserk mode, like steroids. Give Noko temporary huuuuuuuge punches (haymakers, massive damage, y'know). Maybe play a heartbeat sound like blood is bumpin' through the bicep veins haha
# - Landing sound/feedback. This might make it easier to do consecutive jumps.
# - Unarmed "focus" = GRAB! Pick up! Whee! Don't be fancy! (LATER NOTE: plan to use for comms, maybe ctrl+E instead?)
# x Different kicks:
# 	- "breach kick", mod+kick, opens doors, knocks enemies back
#	- If jumping, spin kick
# - Dance moves, gestures, taunts (easy to implement!)
# - equilibrium style animations combined with shooting (camera?)
# - defined map interactions, like sitting (think poseballs), getting a drink, typing on computer, etc
# - +predefined map interactions: Kick triggers pushing over a table!
# - Kicking certain things into enemies (like chairs) hurts them or knocks them down!

signal akimbo_type_changed(new_value)
signal health_changed(new_value)
signal armor_changed(new_value)
signal micro_ticker_timeout

var offline_id: int = 1
const SPEED = 12.0 # 14.0
const JUMP_VELOCITY = 22.5
var dive_lift: float = 23.0
var dive_thrust: float = 33.0
var dive_basis: Basis
var carry_speed = SPEED * .6
var movement_lerp_scale: float = .1
@export var camera_velocity_tilt_scale: float = 2

@export var health: int = 100:
	get:
		return health
	set(value):
		health_changed.emit(value)
		health = value
var low_health_threshold: int = 35
var armor: int = 0:
	get:
		return armor
	set(value):
		armor_changed.emit(value)
		armor = value
@export var spawn_loadout: Array[String] = []
@export var spawn_ammo: Dictionary = {
	U.ammo_types.NINE_MM: 0,
	U.ammo_types.FORTY_FIVE: 0,
	U.ammo_types.FIFTY: 0,
	U.ammo_types.NATO: 0,
	U.ammo_types.SEVEN_SIXTY_TWO: 0,
	U.ammo_types.SHELLS: 0
}
@export var auto_equip: bool = true

@onready var hud: Control = $HUD
@onready var shader_camshake: ColorRect = $HUD/shader_camshake

# Get the gravity from the project settings to be synced with RigidBody nodes.
var gravity = (ProjectSettings.get_setting("physics/3d/default_gravity") * 6)
@onready var cam_base: Node3D = $cam_base
@onready var main_cam: Camera3D = $cam_base/SpringArm3D/Camera3D
@onready var tight_cam: Camera3D = $cam_base/tight_cam
@onready var torso_cam: Camera3D = $graphics/noko/Armature/Skeleton3D/attach_hitbox_torso/anchor/torso_cam
@onready var ads_cam: Camera3D = $cam_base/ads_cam
@onready var death_cam: Camera3D = $cam_base/death_cam
var cam_data: Dictionary = {}
var default_ads_sidecar_pos: Vector3 = Vector3(0.34, -0.02, 0.08)
var default_ads_positions: Dictionary = {
	"default": Vector3(-0.01, 0.1, 0.07),
	"m_16_nato": Vector3(-0.015, 0.48, 0.15),
	"tabas_ak47": Vector3(-0.015, 0.48, 0.15),
	"shotgun_buster": Vector3(-0.021, 0.26, -0.505),
	"revolver_octo_45": Vector3(-0.005, 0.205, 0.185),
	"smg_9mm": Vector3(-0.01, 0.145, 0.375)
}

@onready var graphics: Node3D = $graphics
@onready var bravura_model: Node3D = $graphics/noko/detective_bravura
@onready var bravura_anim: AnimationPlayer = $graphics/noko/detective_bravura/AnimationPlayer
@onready var interact_area: Area3D = $interact_area
@onready var chest_raycast: RayCast3D = $chest_raycast
@onready var left_shoulder_feeler: RayCast3D = $graphics/noko/Armature/Skeleton3D/attach_torso/left_shoulder_feeler
@onready var right_shoulder_feeler: RayCast3D = $graphics/noko/Armature/Skeleton3D/attach_torso/right_shoulder_feeler
@onready var ground_clip_sensor: RayCast3D = $graphics/noko/Armature/Skeleton3D/attach_hitbox_legs/ground_clip_sensor
@onready var step_raycast_toes: RayCast3D = $step_raycast_toes
@onready var step_raycast_knees: RayCast3D = $step_raycast_knees
@onready var world_item_anchor: Node3D = $graphics/noko/Armature/Skeleton3D/attach_rhand/world_item_anchor
@onready var aiming_anchor: Node3D = $cam_base/SpringArm3D/aiming_anchor #$graphics/aiming_anchor
@onready var rhand_ik: SkeletonIK3D = $graphics/noko/Armature/Skeleton3D/right_hand_ik
@onready var lhand_ik: SkeletonIK3D = $graphics/noko/Armature/Skeleton3D/left_hand_ik
@onready var head_anchor: Node3D = $graphics/noko/Armature/Skeleton3D/attach_hitbox_head/anchor
@onready var rhand_anchor: Node3D = $graphics/noko/Armature/Skeleton3D/attach_rhand/anchor
@onready var lhand_anchor: Node3D = $graphics/noko/Armature/Skeleton3D/attach_lhand/anchor
@onready var rfoot_anchor: Node3D = $graphics/noko/Armature/Skeleton3D/attach_rfoot/anchor
@onready var torso_anchor: Node3D = $graphics/noko/Armature/Skeleton3D/attach_torso/anchor
@onready var kicker: Node3D = $graphics/noko/Armature/Skeleton3D/attach_hitbox_torso/anchor/kicker
@onready var noko_anim: AnimationPlayer = $graphics/noko/AnimationPlayer
@onready var anim: AnimationPlayer = $graphics/noko/AnimationPlayer # Alias for compatibility
@onready var footsteps_player: AnimationPlayer = $Sound/footsteps_player
@onready var footsteps_player_alt: AnimationPlayer = $Sound/footsteps_player_alt
@onready var sound_punch1: AudioStreamPlayer3D = $Sound/punch1
@onready var sound_punch2: AudioStreamPlayer3D = $Sound/punch2
@onready var sound_kick: AudioStreamPlayer3D = $Sound/kick1
@onready var sound_hit: AudioStreamPlayer3D = $Sound/hit_sound
@onready var tight_cam_timer: Timer = $cam_base/tight_cam/tight_cam_timer
@onready var special_timer: Timer = $special_timer
@onready var reload_timer: Timer = $reload_timer
@onready var punch_timer: Timer = $punch_timer
@onready var block_timer: Timer = $block_timer
@onready var coyote_timer: Timer = $coyote_timer
@onready var flinch_timer: Timer = $flinch_timer
@onready var sound_cooloff: Timer = $sound_cooloff
@onready var hitbox_lower_anim: AnimationPlayer = $hitbox_lower/AnimationPlayer
@onready var slot_manager: Node = $slot_manager
@onready var pointing_finger_right: RayCast3D = $graphics/noko/Armature/Skeleton3D/attach_rhand/pointing_finger_right
@onready var pointing_finger_left: RayCast3D = $graphics/noko/Armature/Skeleton3D/attach_lhand/pointing_finger_left
@onready var pointing_mesh: MeshInstance3D = $graphics/pointing_mesh
@onready var pos_actor_carry: Marker3D = $graphics/pos_actor_carry
var pointing_finger: RayCast3D

var last_saved_global_position: Vector3 = Vector3.ZERO
var last_saved_global_rotation: Vector3 = Vector3.ZERO
var last_saved_graphics_rotation: Vector3 = Vector3.ZERO
var last_saved_cam_rotation: Vector3 = Vector3.ZERO
var last_saved_carrot_spatial: Node3D = Node3D.new()
var last_saved_external_carrot_base_spatial: Node3D = Node3D.new()
var ghost_global_rotation: Node3D = Node3D.new()
var ghost_graphics_rotation: Node3D = Node3D.new()
var ghost_cam_rotation: Node3D = Node3D.new()
var mouse_sensitivity: float = 0.002
var crouch_cam_offset_y: float = 3
var step_offset: float = 2.2
var run_scale: float = 2
var crouch_scale: float = 0.5
var move_slide_scale: float = 0.5
var kick_slide_speed_threshold: float = 8.0
@export var is_observer: bool = false
var is_menu_enabled: bool = false
@export var is_input_allowed: bool = true
@export var is_cam_tight: bool = false
@export var is_mouselook_locked: bool = false
@export var is_freecam: bool = false
@export var is_freecarrot: bool = false
@export var is_rotation_locked: bool = false
var cam_side: int # Use hand enums
@export var is_crouching: bool = false
@export var is_jumping: bool = false
var is_wall_jumping: bool = false
var is_diving: bool = false
@export var is_flipped: bool = false
@export var is_coyote_time: bool = false
@export var is_kicking: bool = false
@export var is_heavy_kicking: bool = false
@export var is_kick_sliding: bool = false
@export var is_punching: bool = false
@export var is_heavy_punching: bool = false
var is_mad: bool = false
var is_punch_allowed: bool = true
@export var is_melee_blocking: bool = false
@export var is_reloading: bool = false
@export var is_flinching: bool = false
@export var is_gesturing: bool = false
@export var is_sitting: bool = false
@export var is_slippery: bool = false
var is_reading: bool = false
var is_pointing: bool = false
var is_focusing: bool = false
var is_lifting: bool = false
var is_throwing: bool = false
var is_carrying_world_item: bool = false
var is_carrying_actor: bool = false
var carried_actor: CharacterBody3D
var carried_actor_instance_id: int
var choke_actor: PhysicsBody3D
var is_dancing: bool = false
var is_static_gesture: bool = false
var is_pumping_shotgun: bool = false
@export var is_dead: bool = false
var is_being_choked: bool = false
var is_stepping: bool = false
var is_casual_animset: bool = false
var is_armed_twohanded: bool = false
var is_ads_mode: bool = false
var is_ads_sidecar_mode: bool = false
var exit_mode: bool = false
var focus_speed_penalty: float = .6
var heavy_punch_callback: Callable
var punch_anim_idx: int = 0
var punch_anims: Array[String] = ["melee_primary", "melee_primary_alt"]
var punch_b_anims: Array[String] = ["punch_b_right", "punch_b_left"]
var punch_sounds: Array[AudioStreamPlayer3D] = []
@onready var taunt_sound_container: Node3D = $Sound/taunts
@onready var ouch_sounds: Array = [
	$Sound/ouch1,
	$Sound/ouch2,
	$Sound/ouch3,
	$Sound/ouch4
]
@onready var low_health_ouch_sounds: Array = [
	$Sound/ouch_low_health_1,
	$Sound/ouch_low_health_2,
	$Sound/ouch_low_health_3,
	$Sound/ouch_low_health_4,
	$Sound/ouch_low_health_5,
	$Sound/ouch_low_health_6
]
@onready var command_attack_sounds: Array = [
	$Sound/comms/command_attack_1,
	$Sound/comms/command_attack_2,
	$Sound/comms/command_attack_3
]
@onready var command_goto_here_sounds: Array = [
	$Sound/comms/command_goto_here_1,
	$Sound/comms/command_goto_here_2,
	$Sound/comms/command_goto_here_3,
	$Sound/comms/command_goto_here_4
]
@onready var command_goto_there_sounds: Array = [
	$Sound/comms/command_goto_there_1,
	$Sound/comms/command_goto_there_2,
	$Sound/comms/command_goto_there_3,
	$Sound/comms/command_goto_there_4
]

var door_keys: Array = []
var current_book: Node3D
var armed_type: int = U.armed_types.UNARMED
var active_slot: int = 1
var equip_slots: Dictionary = {}
var last_equipped_iid_left: int
var last_equipped_slot_left: int
var last_equipped_iid_right: int
var last_equipped_slot_right: int

var is_view_chain_started: bool = false
var is_view_control_blocked: bool = false

@onready var original_external_carrot_position: Vector3
#var original_carrot_right_position: Vector3
#var original_carrot_left_position: Vector3
@onready var carrot_right: Marker3D = $graphics/carrot
@onready var carrot_left: Marker3D = $graphics/carrot_left
@onready var external_carrot_base: Node3D = $external_carrot_base
@onready var external_carrot: Marker3D = $external_carrot_base/external_carrot
@onready var choke_carrot: Marker3D = $external_carrot_base/choke_carrot

var akimbo_switch_index: int = U.hands.RIGHT
var akimbo_type: int = U.akimbo_types.LINKED
var akimbo_types: Array[int] = [
	U.akimbo_types.LINKED,
	U.akimbo_types.UNLINKED,
	U.akimbo_types.SWITCH
]

var queued_anims: Array[String] = []
var last_anim: String = ""
var anim_set: Dictionary = {
	"idle": "unarmed_idle",
	"run": "unarmed_run",
	"reload": "reload",
	"jump": "unarmed_jump",
	"handstand": "unarmed_handstand",
	"crouch": "crouch",
	"melee_secondary": "melee_secondary",
	"flinch": "flinch",
	"die": "die1"
}
var anim_set_previous: Dictionary = anim_set.duplicate()
var gesture_slots: Dictionary = {
	"slot_5": "", # Stand
	"slot_6": "", # Static
	"slot_7": "" # Dynamic
}
var is_aimdot_sweeping: bool = false

var delta_count: float = 0.0
var micro_ticker_max_delta: float = 0.2
var micro_ticker_count: float = 0.0
var time_in_air: float = 0.0

var punch_delta: float = 0.0
@export var punch_cooloff: float = 0.25
var linked_shoot_semi_ticker: float = -1.0
var is_mixed_linked_shooting: bool = false

var player_minions: Array = []
enum comms_states {
	IDLE,
	CHOOSING,
	COMMANDING
}
var comms_state: int = comms_states.IDLE
var comms_actor_choice: Node3D
var comms_command_point: Vector3

var player_interface: Node = null

@onready var derringer: Node3D = $graphics/noko/Armature/Skeleton3D/attach_rhand/derringer_anchor/derringer
var is_derringer_equipped: bool = false
var is_derringer_shooting: bool = false
var derringer_ammo: int = 2

var active_world_item: Node3D = null
var active_world_item_props: Dictionary = {}

var active_platform: PhysicsBody3D = null

var accessories: Node3D
var accessories_armature: Skeleton3D
var is_wearing_kevlar: bool = false

##########
# Stats?
var actors_killed: Array[CharacterBody3D] = []
##########

# Settings
@export var enable_flip_mouse_invert: bool = true
var cam_flip_threshold: float = 155

func _ready():
	if is_observer:
		self.remove_from_group("players")
		self.visible = false
		hud.visible = false
	
	mouse_sensitivity = Global.mouse_sensitivity
	if "health" in Global.prop_table:
		health = Global.prop_table["health"]
	elif "health" not in Global.prop_table:
		Global.prop_table["health"] = health
	
	for ray in [left_shoulder_feeler, right_shoulder_feeler, step_raycast_toes, step_raycast_knees, ground_clip_sensor]:
		ray.add_exception(self)
	
	
	Input.mouse_mode = Input.MOUSE_MODE_CAPTURED
	punch_sounds.append(sound_punch1)
	punch_sounds.append(sound_punch2)
	kicker.actor = self
	anim_h(anim_set["idle"])
	$HUD/addhealth_screen.modulate = Color(1.0, 1.0, 1.0, 0.0)
	$HUD/addhealth_screen.visible = true
	$HUD/madwater_screen.modulate = Color(0.54, 0.0, 0.0, 0.0)
	$HUD/madwater_screen.visible = true
	
	for cam in [main_cam, torso_cam, tight_cam, ads_cam]:
		cam_data[cam] = {"unzoomed_fov": cam.fov}
	
	self.connect("micro_ticker_timeout", _on_micro_ticker_timeout)
	
	slot_manager.connect("hand_state_changed", _hand_state_changed)
	slot_manager.equip_unarmed()
	
	comms_actor_choice = get_tree().get_first_node_in_group("player_minions")
	
	hud.set_doom_message("")
	
	for item_name in spawn_loadout:
		pickup(item_name)
	for ammo_key in spawn_ammo:
		slot_manager.add_ammo(ammo_key, spawn_ammo[ammo_key])
	
	var arcade_box_animations: AnimationLibrary = load("res://Resources/arcade_user_animlib.tres")
	for new_animation_name in arcade_box_animations.get_animation_list():
		if anim.get_animation(new_animation_name):
			continue
		var new_animation: Animation = arcade_box_animations.get_animation(new_animation_name)
		anim.get_animation_library("").add_animation(new_animation_name, new_animation)
	
	var bravura_anim_lib: AnimationLibrary = bravura_anim.get_animation_library("")
	for new_animation_name in bravura_anim_lib.get_animation_list():
		var new_animation: Animation = bravura_anim_lib.get_animation(new_animation_name)
		anim.get_animation_library("").add_animation(new_animation_name, new_animation)
	
	
	return


func _unhandled_input(event):
	if is_dead: return
	
	if is_being_choked:
		choke_mouse_control(event)
		return
	
	if player_interface:
		player_interface.push_event(event)
	
	if is_freecam:
		freecam_mouselook(event)
		return
	
	if is_freecarrot:
		freecarrot_mouselook(event)
		return
	
	if current_book:
		if Input.is_action_just_pressed("ui_right"):
			current_book.next_page()
		if Input.is_action_just_pressed("ui_left"):
			current_book.previous_page()
		if Input.is_action_just_pressed("ui_up"):
			current_book.scroll_page(1)
		if Input.is_action_just_pressed("ui_down"):
			current_book.scroll_page(-1)
	
	if Input.is_action_just_released("focus") and not Input.is_action_pressed("mod"):
		deactivate_cam_zoom()
		#for cam in cam_data.keys():
			#if not cam:
				#break # hackfix? "previously freed"R
			#var cur_cam: Camera3D = cam
			#get_tree().create_tween().tween_property(cur_cam, "fov", cam_data[cur_cam]["unzoomed_fov"], .5)
			##cam_data[cur_cam].erase("unzoomed_fov")
	
	#if event is InputEventMouseMotion:
	if event is InputEventMouseMotion and not is_mouselook_locked:
		cam_base.rotation.x -= (event.relative.y * mouse_sensitivity)
		cam_base.rotation_degrees.x = clamp(cam_base.rotation_degrees.x, -180, 180)
		
		if is_rotation_locked:
			cam_base.rotation.y -= (event.relative.x * mouse_sensitivity)
			return
		
		
		graphics.rotation.x -= (event.relative.y * mouse_sensitivity)
		graphics.rotation_degrees.x = clamp(graphics.rotation_degrees.x, -180, 180)
		
		
		if not enable_flip_mouse_invert:
			# Default left-and-right looking
			self.rotation.y -= (event.relative.x * mouse_sensitivity)

		#if cam_base.rotation_degrees.x < -90 or cam_base.rotation_degrees.x > 90:
		if cam_base.rotation_degrees.x < -cam_flip_threshold or cam_base.rotation_degrees.x > cam_flip_threshold:
			if enable_flip_mouse_invert:
				self.rotation.y += (event.relative.x * mouse_sensitivity)
			is_flipped = true
		else:
			if enable_flip_mouse_invert:
				self.rotation.y -= (event.relative.x * mouse_sensitivity)
			is_flipped = false
	
	
	return

func _process(delta):
	micro_ticker_count += delta
	if micro_ticker_count >= micro_ticker_max_delta:
		micro_ticker_timeout.emit()
		micro_ticker_count = 0.0

	if punch_delta >= punch_cooloff:
		punch_delta = 0.0
		is_punching = false
	
	if is_punching:
		punch_delta += delta
	
	if is_mixed_linked_shooting:
		linked_shoot_semi_ticker -= delta
	return

func _physics_process(delta):
	delta_count += delta
	
	#$debug_label.text = "comms_actor_choice: " + str(comms_actor_choice)
	
	if is_being_choked:
		choke_control()
		return
	
	
	if Input.is_action_just_pressed("dev_button") and Input.is_action_pressed("mod"):
		var assumed_world: World = get_tree().get_first_node_in_group("Worlds")
		if assumed_world.get_node("world_camera").current:
			main_cam.make_current()
		else:
			#assumed_world.get_node("world_camera").make_current()
			var world_cam: Camera3D = assumed_world.get_node("world_camera")
			world_cam.make_current()
	
	if not is_input_allowed and is_mouselook_locked and Input.is_action_just_pressed("use"):
		release_player_interface()
	
	if player_interface:
		return
	
	if is_input_allowed and Input.is_action_just_pressed("gesture"):
		is_dancing = !is_dancing
		toggle_freecam()
		if is_dancing:
			anim_h("gesture_dance_swimcon_1", false, true)
		return
	
	#var foot_collider: Node3D = $foot_raycast.get_collider()
	#if foot_collider and foot_collider.is_in_group("platforms"):
		#active_platform = foot_collider
	#elif not foot_collider and active_platform:
		#await get_tree().create_timer(1.0).timeout
		#if not $foot_raycast.get_collider():
			#active_platform = null
		##self.velocity -= (self.global_position - foot_collider.global_position)
	#
	#if active_platform:
		#self.velocity += (self.global_position - foot_collider.global_position)
	
	if is_dancing:
		return

####
	#if is_static_gesture:
		#if is_input_allowed and Input.is_action_just_pressed("slot_6") and not Input.is_action_pressed("mod"):
			#toggle_freecam()
			#is_static_gesture = false
		#return # I can't shoot hahaha
	
####
	
	if is_sitting:
		if Input.is_action_just_pressed("use"):
			stop_sitting()
		return
	
	if Input.is_action_just_pressed("camera_control") and not Input.is_action_pressed("mod"):
		#toggle_freecam()
		toggle_freecarrot()
	
	if Input.is_action_just_pressed("camera_control") and Input.is_action_pressed("mod"):
		#toggle_freecarrot()
		toggle_freecam()
	
	# Add the gravity.
	if not is_on_floor():
		velocity.y -= gravity * delta
		time_in_air += delta
		
		if coyote_timer.is_stopped() and not is_jumping:
			coyote_timer.start()
			is_coyote_time = true if time_in_air < coyote_timer.wait_time else false
	
	# Add persistent force
	if is_diving:
		#A.apply_move(self, Vector2.UP, dive_thrust)
		A.apply_move_with_axis(dive_basis, self, Vector2.UP, dive_thrust)
	
	if is_menu_enabled:
		return
	
	if is_dead:
		velocity.y -= gravity * delta
		move_and_slide()
		
		if Input.is_action_just_pressed("use"):
			restart_level()
			return
		if Input.is_action_just_pressed("primary_action"):
			restart_level()
			return
		return
	
	if health < 1:
		#graphics.rotation_degrees.x = 90
		
		queued_anims.clear()
		anim_h(anim_set["die"], false, true)
		death_cam.make_current()
		hud.hide_hud()
		hud.set_doom_message("You have died.")
		$Sound/no_health.play()
		is_dead = true
		return
	
	
	if is_carrying_actor:
		actor_carry_control(delta)
		return
	
	if is_pointing:
		update_pointing_finger()
		var pointing_collider: Node3D = pointing_finger.get_collider()
		if pointing_collider:
			#slot_manager.suppress_weapon_dots()
			point_dot_control(pointing_collider)
	
	if is_flipped and not is_punching and not is_kicking:
		anim_h(anim_set["handstand"])
	# Handle Jump.
	if is_input_allowed and Input.is_action_just_pressed("jump") and not Input.is_action_pressed("mod") and (
		is_on_floor() or chest_raycast.is_colliding() or is_coyote_time
	):
		if chest_raycast.is_colliding():
			just_walljumped()
		
		var jump_force: float
		if is_flipped:
			jump_force = (JUMP_VELOCITY * 1.2)
		else:
			jump_force = JUMP_VELOCITY
		#velocity.y = JUMP_VELOCITY
		velocity.y = jump_force
		
		if not is_heavy_punching and not is_heavy_kicking and not is_wall_jumping:
			anim_h(anim_set["jump"], false)
		
		footsteps_player_alt.play("jump")
		is_jumping = true
	
	### DIVE \/
	if is_input_allowed and Input.is_action_just_pressed("jump") and Input.is_action_pressed("mod") and (
		is_on_floor() or chest_raycast.is_colliding() or is_coyote_time
	):
		dive_basis = self.transform.basis
		stunt_dive()
	### DIVE /\
	
	var input_dir: Vector2
	if is_input_allowed:
		input_dir = Input.get_vector("strafe_left", "strafe_right", "forward", "backward")
	var speed_modifier: float = 1.0 if not is_crouching else crouch_scale
	
	if is_input_allowed and Input.is_action_pressed("use") and Input.is_action_pressed("mod"):
		mod_interaction_control()
	
	if is_input_allowed and Input.is_action_pressed("use") and not Input.is_action_pressed("mod"):
		interaction_control()
		if is_sitting:
			return
	
	if is_input_allowed and Input.is_action_just_pressed("drop_item"):
		if is_carrying_world_item:
			drop_world_item()
		else:
			drop_hand_items()
		return
	
	if is_input_allowed and Input.is_action_just_pressed("comms") and not Input.is_action_pressed("mod"):
		if comms_actor_choice:
			comms_state = comms_states.COMMANDING
		comms_control()
	
	if is_input_allowed and Input.is_action_just_pressed("comms") and Input.is_action_pressed("mod"):
		# context menu, some easy way to choose
		pass
	
#	if is_input_allowed and Input.is_action_just_pressed(GESTURE?):
#		is_gesturing = true
#		anim_h("bow_to_camera", false, true)
#		await get_tree().create_timer(2.0).timeout
#		is_gesturing = false
	
	
	if Input.is_action_pressed("focus") and (
		comms_state == comms_states.CHOOSING or \
		comms_state == comms_states.COMMANDING or \
		comms_actor_choice
	):
		if armed_type == U.armed_types.UNARMED:
			pointing_mesh.visible = true
		is_pointing = true
	
	if Input.is_action_just_released("focus"):
		slot_manager.reset_weapon_dots()
		pointing_mesh.visible = false
		pointing_mesh.position = Vector3(0.0, 4.0, 0.0)
		is_pointing = false
	
	if Input.is_action_pressed("focus") and comms_state == comms_states.IDLE:
		speed_modifier -= (speed_modifier * focus_speed_penalty)
	
	if is_carrying_actor:
		speed_modifier -= (speed_modifier * focus_speed_penalty)
	
	if is_input_allowed and Input.is_action_pressed("mode_shift"):
		speed_modifier *= (run_scale * 1.2)
		if not is_heavy_punching:
			noko_anim.speed_scale = run_scale
		footsteps_player.speed_scale = (1.2 * run_scale)
	elif is_input_allowed and not Input.is_action_pressed("mode_shift"):
		noko_anim.speed_scale = 1
		footsteps_player.speed_scale = 1.2
	
	# Original
	#var direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	
	var direction: Vector3
	if not (is_freecam or is_freecarrot):
		direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	else:
		#var cam_adjusted_basis: Basis = cam_base.global_transform.basis.rotated(Vector3.UP, deg_to_rad(-90))
		var cam_adjusted_basis: Basis = cam_base.global_transform.basis
		direction = (cam_adjusted_basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	
	var is_moving_blocked: bool = (
		is_static_gesture
	)
	if not is_moving_blocked:
		if direction:
	#		velocity.x = direction.x * SPEED * speed_modifier # Last working line 20231013
	#		velocity.z = direction.z * SPEED * speed_modifier # Last working line 20231013
			var new_velo_x = direction.x * SPEED * speed_modifier
			var new_velo_z = direction.z * SPEED * speed_modifier
			if is_slippery or is_kick_sliding:
				velocity.x = lerp(velocity.x, new_velo_x, delta)
				velocity.z = lerp(velocity.z, new_velo_z, delta)
			else:
				velocity.x = lerp(velocity.x, new_velo_x, movement_lerp_scale)
				velocity.z = lerp(velocity.z, new_velo_z, movement_lerp_scale)
		elif not direction and not is_kick_sliding:
			velocity.x = move_toward(velocity.x, 0, move_slide_scale) #SPEED * speed_modifier)
			velocity.z = move_toward(velocity.z, 0, move_slide_scale) #SPEED * speed_modifier)
	
	move_and_slide()
	
	
	var tilt_max: float = input_dir.x * camera_velocity_tilt_scale
	var tilt_step: float = .1
	var tilt_amount = lerpf(
		0,
		tilt_max,
		self.velocity.length() * tilt_step
	)
	
#	for cam in [main_cam, tight_cam, torso_cam]:
#		cam.rotation_degrees.z = -tilt_amount
	
	main_cam.rotation_degrees.z = -tilt_amount
	tight_cam.rotation_degrees.z = -tilt_amount * 1.2
	torso_cam.rotation_degrees.z = -tilt_amount * 1.2
	
	var anim_already_busy: bool = (
		is_kicking or \
		is_punching or \
		is_heavy_punching or \
		is_heavy_kicking or \
		is_melee_blocking or \
		is_reloading or \
		is_flipped or \
		is_flinching or \
		is_kick_sliding or \
		is_gesturing or \
		is_pumping_shotgun or \
		is_throwing or \
		is_wall_jumping or \
		is_static_gesture or \
		is_diving
	)
	
	if not self.velocity.is_zero_approx() and not is_jumping and not anim_already_busy:
		anim_h(anim_set["run"])
		footsteps_player.play("walking")
		
	elif self.velocity.is_zero_approx() and not is_jumping and not anim_already_busy:
		anim_h(anim_set["idle"])
	
	if self.velocity.is_zero_approx() or not self.is_on_floor() or is_crouching:
		footsteps_player.play("silence")
	
	if is_input_allowed and Input.is_action_just_pressed("view") and is_ads_mode:
		if is_ads_sidecar_mode and Input.is_action_pressed("mod"):
			is_ads_sidecar_mode = !is_ads_sidecar_mode
			toggle_ads_mode()
			toggle_ads_mode() # Double calling as a hack to avoid more code
		elif is_ads_sidecar_mode and not Input.is_action_pressed("mod"):
			toggle_cam_side()
		elif is_view_chain_started:
			if Input.is_action_pressed("mod"):
				toggle_ads_mode()
			elif not Input.is_action_pressed("mod"):
				is_ads_sidecar_mode = !is_ads_sidecar_mode
				toggle_ads_mode()
				toggle_ads_mode() # Double calling as a hack to avoid more code
			is_view_chain_started = false
			hud.set_chain_status("")
			is_view_control_blocked = true
			get_tree().create_tween().tween_callback(func(): is_view_control_blocked = false).set_delay(.3)
		elif not is_view_chain_started:
			if Input.is_action_pressed("mod"):
				is_view_chain_started = true
				hud.set_chain_status("[VIEW] [MOD+VIEW]")
			else:
				toggle_cam_side()
	
	if is_input_allowed and Input.is_action_just_pressed("view") and not is_ads_mode and not is_view_control_blocked:
		# START original first person view
		#if Input.is_action_pressed("mod"):
			#toggle_torso_cam()
		#else:
			#toggle_cam_side()
		# END original first person view
		
		### I think what I'll do for the ADS is make CTRL + V be a chain
		### So maybe CTRL + V, CTRL + V will be ADS
		### and CTRL + V, V will be old torso cam
		if torso_cam.current:
			toggle_torso_cam()
		else:
			if Input.is_action_pressed("mod"):
				if is_view_chain_started:
					toggle_torso_cam()
					is_view_chain_started = false
					hud.set_chain_status("")
				elif not is_view_chain_started:
					is_view_chain_started = true
					hud.set_chain_status("[VIEW] [MOD+VIEW]")
			elif not Input.is_action_pressed("mod"):
				if is_view_chain_started:
					toggle_ads_mode()
					is_view_chain_started = false
					hud.set_chain_status("")
				elif not is_view_chain_started:
					toggle_cam_side()
		
		

		
	
	if is_input_allowed and Input.is_action_just_pressed("crouch") and not is_kick_sliding:
		toggle_crouch()
	
	
	### DEBUGvv
	#if is_input_allowed and Input.is_action_just_pressed("slot_0") and not Input.is_action_pressed("mod"):
		#$Sound/special/temp_voice.play()
		##slot_manager.equip_both_fists()
		#self.velocity += (pos_actor_carry.global_position - self.global_position) * 50 # DEBUG
	#if is_input_allowed and Input.is_action_just_pressed("slot_0") and not Input.is_action_pressed("mod"):
	#	$graphics/noko/Armature/Skeleton3D/attach_rhand/derringer_anchor.get_node("derringer").shoot()
	### DEBUG^^
	
	if is_input_allowed and Input.is_action_just_pressed("slot_1") and Input.is_action_pressed("mod"):
		if is_carrying_world_item:
			drop_world_item()
		toggle_hand_item(U.hands.LEFT)
	if is_input_allowed and Input.is_action_just_pressed("slot_2") and Input.is_action_pressed("mod"):
		if is_carrying_world_item:
			drop_world_item()
		toggle_hand_item(U.hands.RIGHT)
	
	if is_input_allowed and Input.is_action_just_pressed("slot_1") and not Input.is_action_pressed("mod"):
		if is_carrying_world_item:
			drop_world_item()
		if is_ads_mode: toggle_ads_mode()
		slot_manager.request(1)
	if is_input_allowed and Input.is_action_just_pressed("slot_2") and not Input.is_action_pressed("mod"):
		if is_carrying_world_item:
			drop_world_item()
		if is_ads_mode: toggle_ads_mode()
		slot_manager.request(2)
	
	if is_input_allowed and Input.is_action_just_pressed("slot_3") and not Input.is_action_pressed("mod"):
		var is_hand_chosen: bool = (slot_manager.slot_step != slot_manager.slot_steps.HAND)
		if is_hand_chosen:
			slot_manager.request(3)
	if is_input_allowed and Input.is_action_just_pressed("slot_4") and not Input.is_action_pressed("mod"):
		var is_hand_chosen: bool = (slot_manager.slot_step != slot_manager.slot_steps.HAND)
		if is_hand_chosen:
			slot_manager.request(4)
	if is_input_allowed and Input.is_action_just_pressed("slot_5") and not Input.is_action_pressed("mod"):
		var chosen_gesture_stand: String = "gesture_stand_1"
		if not gesture_slots["slot_5"] or anim_set["idle"] != gesture_slots["slot_5"]:
			gesture_slots["slot_5"] = chosen_gesture_stand
			anim_set_previous["idle"] = anim_set["idle"]
			anim_set_previous["run"] = anim_set["run"]
			anim_set["idle"] = chosen_gesture_stand
			anim_set["run"] = "unarmed_run_alt"
		elif gesture_slots["slot_5"] and anim_set["idle"] == gesture_slots["slot_5"]:
			gesture_slots["slot_5"] = ""
			anim_set["idle"] = anim_set_previous["idle"]
			anim_set["run"] = anim_set_previous["run"]
	if is_input_allowed and Input.is_action_just_pressed("slot_6") and not Input.is_action_pressed("mod"):
		var chosen_gesture_pose: String = "gesture_static_shoot_1"
		if not gesture_slots["slot_6"] and not is_static_gesture:
			is_static_gesture = true
			toggle_freecam()
			anim_h(chosen_gesture_pose, false, true)
			#self.velocity = self.velocity * .5
			A.gradual_velo_stop(self, self.velocity * .2, .8)
			#is_aimdot_sweeping = true
			#var rhand_weap: Node3D = slot_manager.get_held_weapon(U.hands.RIGHT)
			#rhand_weap.aim_dot_controller = self
			#var aimdot_callback: Callable = func():
				#self.is_aimdot_sweeping = false
				#rhand_weap.aim_dot_controller = rhand_weap.aim_dot_controller
			#get_tree().create_tween().tween_callback(aimdot_callback).set_delay(1.0)
		elif is_static_gesture:
			toggle_freecam()
			is_static_gesture = false
			
	if is_input_allowed and Input.is_action_just_pressed("slot_7") and not Input.is_action_pressed("mod"):
		## DEBUG vv
		$Sound/special/temp_voice.play()
		pass
		
		## DEBUG ^^
	
	if is_input_allowed and Input.is_action_just_pressed("special"):
		#var is_moving_fast_enough: bool = (self.velocity.length() >= kick_slide_speed_threshold)
		#if is_crouching and is_moving_fast_enough:
		if Input.is_action_pressed("mod"):
			heavy_kick()
		elif is_crouching and Input.is_action_pressed("forward"):
			kick_slide()
		elif is_crouching and Input.is_action_pressed("backward"):
			back_kick_slide()
		elif not is_crouching and Input.is_action_pressed("backward") and not is_freecam:
			back_kick()
		else:
			kick()

	if (Input.is_action_pressed("primary_action") or Input.is_action_just_released("primary_action")) and not Input.is_action_pressed("mod"):
		if sound_cooloff.is_stopped() and armed_type != U.armed_types.UNARMED:
			sound_cooloff.start()
		primary_action_control()
	if (Input.is_action_pressed("primary_action") or Input.is_action_just_released("primary_action")) and Input.is_action_pressed("mod"):
		if sound_cooloff.is_stopped() and armed_type != U.armed_types.UNARMED:
			sound_cooloff.start()
		#mod_action_control()
	if Input.is_action_pressed("primary_action") and Input.is_action_pressed("mod"):
		if not is_diving:
			mod_action_control()
	
	if Input.is_action_pressed("reload") and not Input.is_action_pressed("mod"):
		reload_control()
	if Input.is_action_just_pressed("reload") and Input.is_action_pressed("mod") and armed_type == U.armed_types.AKIMBO:
		# Change 'fire selection' (just akimbo for now)
		cycle_akimbo_types()
	
	#if Input.is_action_just_released("reload"):
		#var left_item: Node = slot_manager.get_held_weapon(U.hands.LEFT)
		#var right_item: Node = slot_manager.get_held_weapon(U.hands.RIGHT)
		#if armed_type == U.armed_types.ARMED and slot_manager.get_held_weapon(U.hands.RIGHT).fire_mode == U.fire_modes.SINGLE_ACTION:
			#is_reloading = false
		#elif armed_type == U.armed_types.ARMEDLEFT and slot_manager.get_held_weapon(U.hands.RIGHT).fire_mode == U.fire_modes.SINGLE_ACTION:
			#is_reloading = false
		#if armed_type == U.armed_types.AKIMBO and \
			#slot_manager.get_held_weapon(U.hands.LEFT).fire_mode == U.fire_modes.SINGLE_ACTION and \
			#slot_manager.get_held_weapon(U.hands.RIGHT).fire_mode == U.fire_modes.SINGLE_ACTION:
			#is_reloading = false
	if Input.is_action_just_released("reload"):
		var left_item: Node = slot_manager.get_held_weapon(U.hands.LEFT)
		var right_item: Node = slot_manager.get_held_weapon(U.hands.RIGHT)
		if armed_type == U.armed_types.ARMED and right_item and right_item.fire_mode == U.fire_modes.SINGLE_ACTION:
			is_reloading = false
		elif armed_type == U.armed_types.ARMEDLEFT and left_item and left_item.fire_mode == U.fire_modes.SINGLE_ACTION:
			is_reloading = false
		if armed_type == U.armed_types.AKIMBO and \
			right_item.fire_mode == U.fire_modes.SINGLE_ACTION and \
			left_item.fire_mode == U.fire_modes.SINGLE_ACTION:
			is_reloading = false

	
	if armed_type == U.armed_types.AKIMBO and akimbo_type == U.akimbo_types.UNLINKED:
		akimbo_unlinked_shoot()
	#elif armed_type == U.armed_types.AKIMBO and akimbo_type != U.akimbo_types.UNLINKED:
	elif (
			armed_type != U.armed_types.AKIMBO and not is_armed_twohanded
		) or (
			armed_type == U.armed_types.AKIMBO and akimbo_type != U.akimbo_types.UNLINKED
	):
		if is_input_allowed and Input.is_action_pressed("focus") and not Input.is_action_pressed("mod"):
			is_focusing = true
			update_pointing_finger()
			focus_toggle(true)
		if is_input_allowed and Input.is_action_just_released("focus") and not Input.is_action_pressed("mod"):
			is_focusing = false
			focus_toggle(false)
	elif armed_type != U.armed_types.AKIMBO and is_armed_twohanded:
		# Increase FOV on press,
		# Return FOV on release
		focus_zoom_control()
	
	if is_input_allowed and Input.is_action_just_pressed("focus") and Input.is_action_pressed("mod"):
		#toggle_casual_anims()
		toggle_armed_twohanded()
	
	return

func toggle_ads_mode(ads_cam_position: Vector3 = U.silly_vector):
	var ads_hand: int
	if armed_type == U.armed_types.AKIMBO:
		ads_hand = akimbo_switch_index
	elif armed_type == U.armed_types.ARMED and not is_crouching:
		ads_hand = U.hands.RIGHT
	elif armed_type == U.armed_types.ARMEDLEFT and not is_crouching:
		ads_hand = U.hands.LEFT
	
	var ads_weapon: Node3D = slot_manager.get_held_weapon(ads_hand)
	if not ads_weapon: return
	
	#var cam_position: Vector3 = Vector3(0.34, -0.02, 0.08)
	if ads_cam_position == U.silly_vector and is_ads_sidecar_mode:
		ads_cam_position = default_ads_sidecar_pos #= Vector3(0.34, -0.02, 0.08)
	elif ads_cam_position == U.silly_vector and not is_ads_sidecar_mode:
		if ads_weapon.hud_name in default_ads_positions:
			ads_cam_position = default_ads_positions[ads_weapon.hud_name]
		else:
			ads_cam_position = default_ads_positions["default"]
	
	if is_ads_mode:
		is_ads_mode = false
		ads_cam.get_parent().remove_child(ads_cam)
		cam_base.add_child(ads_cam)
		ads_cam.position = Vector3.ZERO
		main_cam.make_current()
	elif not is_ads_mode:
		is_ads_mode = true
		ads_cam.get_parent().remove_child(ads_cam)
		ads_weapon.add_child(ads_cam)
		ads_cam.position.x = ads_cam_position.x #-.02
		ads_cam.position.y = ads_cam_position.y #.08
		ads_cam.position.z = ads_cam_position.z #0.34
		ads_cam.make_current()
	return

func focus_zoom_control():
	if exit_mode: return
	
	var cur_cam: Camera3D = get_viewport().get_camera_3d()
	
	## Moving this out so it can be recognized in more contexts
	#if Input.is_action_just_released("focus") and not Input.is_action_pressed("mod"):
		#get_tree().create_tween().tween_property(cur_cam, "fov", cam_data[cur_cam]["unzoomed_fov"], .5)
		#cam_data[cur_cam].erase("unzoomed_fov")
	
	#if not cur_cam in cam_data:
		#cam_data[cur_cam] = {}
	#if not "unzoomed_fov" in cam_data[cur_cam]:
		#cam_data[cur_cam]["unzoomed_fov"] = cur_cam.fov
	
	if Input.is_action_pressed("focus") and not Input.is_action_pressed("mod"):
		get_tree().create_tween().tween_property(cur_cam, "fov", cam_data[cur_cam]["unzoomed_fov"] * .55, .5)
	return

func actor_carry_control(delta):
	if is_carrying_actor and carried_actor:
		carried_actor.global_position = $graphics/pos_actor_carry/anchor.global_position
		carried_actor.global_rotation = $graphics/pos_actor_carry/anchor.global_rotation
	
	var input_dir: Vector2
	if is_input_allowed:
		input_dir = Input.get_vector("strafe_left", "strafe_right", "forward", "backward")
	
	if is_input_allowed and Input.is_action_pressed("mode_shift"):
		noko_anim.speed_scale = 1.1
		footsteps_player.speed_scale = 1.1
	elif is_input_allowed and not Input.is_action_pressed("mode_shift"):
		noko_anim.speed_scale = .6
		footsteps_player.speed_scale = .6
	
	var direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	if direction:
#		velocity.x = direction.x * SPEED * speed_modifier # Last working line 20231013
#		velocity.z = direction.z * SPEED * speed_modifier # Last working line 20231013
		var new_velo_x = direction.x * carry_speed
		var new_velo_z = direction.z * carry_speed
		if is_slippery:
			velocity.x = lerp(velocity.x, new_velo_x, delta)
			velocity.z = lerp(velocity.z, new_velo_z, delta)
		else:
			velocity.x = lerp(velocity.x, new_velo_x, movement_lerp_scale)
			velocity.z = lerp(velocity.z, new_velo_z, movement_lerp_scale)
	elif not direction:
		velocity.x = move_toward(velocity.x, 0, move_slide_scale) #SPEED * speed_modifier)
		velocity.z = move_toward(velocity.z, 0, move_slide_scale) #SPEED * speed_modifier)
	
	move_and_slide()
	
	if not self.velocity.is_zero_approx() and not is_lifting and not is_throwing:
		anim_h("lifter_run", false, true)
		footsteps_player.play("walking")
	elif self.velocity.is_zero_approx() and not is_lifting and not is_throwing:
		anim_h("lifter_idle", false, true)
	
	if self.velocity.is_zero_approx() or not self.is_on_floor():
		footsteps_player.play("silence")
	
	if is_input_allowed and Input.is_action_just_pressed("primary_action"):
		is_throwing = true
		
		## TEMP vv
		var throw_damage: int = 25
		var throw_knockback: float = 13.0
		var throw_speed: float = 20.0
		
		if not carried_actor:
			carried_actor = instance_from_id(carried_actor_instance_id)
		carried_actor.global_position = $graphics/pos_actor_throw/anchor.global_position
		carried_actor.stop_being_carried(self)
		carried_actor.hit(throw_damage, U.hit_types.UNDEFINED, self, self.global_position)
		A.apply_move(carried_actor, Vector2.UP, throw_speed)
		carried_actor.velocity.y = (JUMP_VELOCITY * .75)
		carried_actor.move_and_slide()
		
		var hurt_ball: Node3D = U.spawn_hurt_ball(Blackboard.current_world, $graphics/pos_actor_throw/anchor.global_position)
		hurt_ball.hurt_damage = throw_damage
		hurt_ball.hurt_knockback = throw_knockback
		hurt_ball.hurt_sound = $Sound/throw_hit_sound
		hurt_ball.follow_spatial = carried_actor
		hurt_ball.hurt_mode = hurt_ball.hurt_modes.ONE_EACH
		hurt_ball.exceptions.append(self)
		hurt_ball.exceptions.append(carried_actor)
		
		if not carried_actor.is_dead:
			carried_actor.remove_collision_exception_with(self)
		
		
		carried_actor = null
		anim_h("lifter_throw", false, true)
		await noko_anim.animation_finished
		is_carrying_actor = false
		
		
		## TEMP ^^
		# - Make getting up animation for the thrown actor
		# - Make a throw/falling mechanic
		#	-- throw a long box rigid body
		#	-- hurt anyone it hits (once)
		#	-- get up on floor hit or after timeout, whichever is easier
		await get_tree().create_timer(0.8).timeout
		is_throwing = false
	return

func update_pointing_finger():
	match armed_type:
		U.armed_types.ARMEDLEFT:
			pointing_finger = pointing_finger_left
		_:
			pointing_finger = pointing_finger_right
	return

func comms_control():
	# Remake this
	# ---
	# T -> quick action
	#	if focusing: act on raycast choice (if actor, attack, if not, nav point, etc.)
	#	if not focusing:
	#		if not following, follow
	#		if following, stop following, maybe face the way the player's facing
	# ctrl+T -> context action
	#	[1][choose minion]
	#	[2][engagement: free fire, return fire]
	#	[3][formation: loose, behind, ahead(?), left side, right side]
	#	[4][follow/unfollow]
	#	[5][drop weapon]
	
	
	if not is_focusing:
		comms_actor_choice.interact(self)
		return
	
	match comms_state:
		comms_states.IDLE:
			#$Sound/selected_sound.play()
			$Sound/negative_sound.play()
			comms_state = comms_states.CHOOSING
			return
		
		comms_states.CHOOSING:
			var pointing_finger_choice: Node3D = pointing_finger.get_collider()
			if not pointing_finger_choice:
				comms_state = comms_states.IDLE
				return
			
			if is_instance_of(pointing_finger_choice, StaticBody3D) and comms_actor_choice:
				$Sound/selected_sound.play()
				comms_state = comms_states.COMMANDING
				return
			
			if pointing_finger_choice.is_in_group("player_minions") and pointing_finger_choice.boss_actor == self:
				$Sound/selected_sound.play()
				comms_actor_choice = pointing_finger_choice
				comms_state = comms_states.COMMANDING
				return
			
			$Sound/negative_sound.play()
			return
		
		comms_states.COMMANDING:
			var pointing_finger_collider: Node3D = pointing_finger.get_collider()
			if not pointing_finger_collider:
				$sound_kick.play() #lol
				push_error("No finger collider!")
				return
			
			var comms_marker: Node3D = U.spawn_comms_marker(Blackboard.current_world, pointing_mesh.global_position, 1.0)
			comms_marker.global_rotation = pointing_mesh.global_rotation
				
			if pointing_finger_collider == comms_actor_choice:
				comms_actor_choice.whatever()
				return
			#if pointing_finger_collider and is_instance_of(pointing_finger_collider, CharacterBody3D):
			if pointing_finger_collider and is_instance_of(pointing_finger_collider, PhysicsBody3D) and pointing_finger_collider.is_in_group("actors"):
				#$Sound/positive_sound.play()
				var voice_chance: float = .25
				var voice_chance_triggered: bool = randf_range(0.0, 0.99) < voice_chance
				if voice_chance_triggered:
					U.random_choice(command_attack_sounds).play()
				
				comms_actor_choice.boss_target = pointing_finger_collider
				comms_actor_choice.boss_command()
				comms_state = comms_states.IDLE
				
				pointing_mesh.visible = false
				return
			
			
			var pointing_finger_choice: Vector3 = pointing_finger.get_collision_point()
			if not pointing_finger_choice:
				$Sound/negative_sound.play()
				comms_state = comms_states.IDLE
				pointing_mesh.visible = false
				return
			
			#$Sound/positive_sound.play()
			comms_command_point = pointing_finger_choice
			
			var voice_chance: float = .25
			var voice_chance_triggered: bool = randf_range(0.0, 0.99) < voice_chance
			if voice_chance_triggered:
				var command_point_distance: float = self.global_position.distance_to(comms_command_point)
				if command_point_distance < 15.0:
					U.random_choice(command_goto_here_sounds).play()
				else:
					U.random_choice(command_goto_there_sounds).play()
			
			if pointing_finger_collider and not pointing_finger_collider.is_in_group("actors") and pointing_finger_collider.is_in_group("interactables"):
				comms_actor_choice.interaction_target = pointing_finger_collider
			comms_actor_choice.boss_command(comms_command_point)
			comms_state = comms_states.IDLE
			
			pointing_mesh.visible = false
			return

	return

func lazy_unarmed_anim_set():
	anim_set["idle"] = "unarmed_idle"
	anim_set["run"] = "unarmed_run"
	anim_set["reload"] = "reload" # Nothing to reload?!
	anim_set["jump"] = "unarmed_jump"
	anim_set["crouch"] = "crouch"
	anim_set["melee_secondary"] = "melee_secondary"
	anim_set["flinch"] = "flinch"
	anim_set["handstand"] = "unarmed_handstand"
	return

func point_dot_control(point_dot_collider: Node3D):
	pointing_mesh.global_position = pointing_finger.get_collision_point()
	var pointing_mesh_material: Material = pointing_mesh.get_active_material(0)
	
	var active_color: Color = Color.ORANGE
	var inactive_color: Color = Color.WHITE
	
	match comms_state:
		comms_states.IDLE:
			active_color = Color.RED
			inactive_color = Color.SKY_BLUE
			
			if point_dot_collider and point_dot_collider.is_in_group("actors"):
				pointing_mesh_material.albedo_color = active_color
			else:
				pointing_mesh_material.albedo_color = inactive_color
		
		comms_states.CHOOSING:
			active_color = Color.GREEN
			
			if point_dot_collider and point_dot_collider.is_in_group("player_minions"):
				pointing_mesh_material.albedo_color = active_color
			else:
				pointing_mesh_material.albedo_color = inactive_color
		
		comms_states.COMMANDING:
			active_color = Color.RED
			inactive_color = Color.SKY_BLUE
			
			if point_dot_collider and point_dot_collider.is_in_group("actors"):
				pointing_mesh_material.albedo_color = active_color
			else:
				pointing_mesh_material.albedo_color = inactive_color
			# Fun stuff to happen if the player asks the minion to attack themselves
			# - Pretend to shoot themselves in the head
			# - Give the player a noogie
			# - Throw their gun down like they're angry
	
	return

func toggle_casual_anims():
	if not is_casual_animset:
		lazy_unarmed_anim_set()
	elif is_casual_animset:
		set_armed_type(armed_type)
	is_casual_animset = !is_casual_animset
	
	return

func toggle_armed_twohanded():
	is_armed_twohanded = !is_armed_twohanded
	set_armed_type(armed_type)
	return

func toggle_hand_item(hand: int):
	if is_ads_mode:
		is_ads_mode = false
		ads_cam.get_parent().remove_child(ads_cam)
		cam_base.add_child(ads_cam)
		ads_cam.position = Vector3.ZERO
		main_cam.make_current()
	
	if slot_manager.get_active_item(hand):
		slot_manager.equip_fist(hand)
	else:
		var last_slot: int = slot_manager.last_slot_sequence[hand]["slot"]
		var last_item: int = slot_manager.last_slot_sequence[hand]["item"]
		if last_item < 0:
			last_item = 0
		slot_manager.request(hand)
		slot_manager.request(last_slot)
		slot_manager.request(last_item)
		# rhand_anchor # lol what is this doing here?
#var last_slot_sequence: Dictionary = {
#	U.hands.LEFT: {"slot": 1, "item": 1},
#	U.hands.RIGHT: {"slot": 1, "item": 1}
#}
	return

func drop_world_item():
	if not is_carrying_world_item: return
	
	# Pasted from throw throw_world_item()
	## Should duplicate the original world item and save it
	## If dropping, drop the duplicate here
	## If throwing, queue_free() the duplicate
	## If equipping a gun, drop_world_item()
	var assumed_root_item: Node3D = active_world_item_props["assumed_root_item"]
	Blackboard.current_world.add_child(assumed_root_item)
	assumed_root_item.process_mode = Node.PROCESS_MODE_INHERIT
	assumed_root_item.global_position = rhand_anchor.global_position
	var dropping_speed: float = 0.20
	var dumb_dropper = U.spawn_dumb_dropper(Blackboard.current_world, rhand_anchor.global_position, dropping_speed)
	dumb_dropper.remote_spatial = assumed_root_item
	
	if active_world_item:
		active_world_item.queue_free()
	#active_world_item_props.clear()
	active_world_item = null
	await get_tree().create_timer(.3).timeout
	is_carrying_world_item = false
	set_armed_type(U.armed_types.UNARMED)
	return

func drop_hand_items():
	if is_ads_mode:
		toggle_ads_mode()
	
	for hand in [U.hands.LEFT, U.hands.RIGHT]:
		var weapon: Node3D = slot_manager.get_held_weapon(hand)
		slot_manager.weapon_cease(hand) # Added to fix a potential infinite shotty bug when being disarmed
		if not weapon:
			continue
		
		var weapon_name: String = weapon.hud_name
		var world_item: RigidBody3D = Weapons.by_name(weapon_name)["world_item"].instantiate()
		if "weapon_theme" in weapon:
			world_item.weapon_theme = weapon.weapon_theme
		Blackboard.current_world.add_child(world_item)
		world_item.add_collision_exception_with(self)
		slot_manager.ammo_inventory[world_item.ammo_type] += world_item.ammo_count
		world_item.ammo_count = 0
		if hand == U.hands.LEFT:
			world_item.global_position = lhand_anchor.global_position
			world_item.global_rotation_degrees.y = self.global_rotation_degrees.y + 180
			slot_manager.drop_left_hand()
		if hand == U.hands.RIGHT:
			world_item.global_position = rhand_anchor.global_position
			world_item.global_rotation_degrees.y = self.global_rotation_degrees.y + 180
			slot_manager.drop_right_hand()
	
#	await get_tree().process_frame
#	slot_manager.set_hand_state()
	slot_manager.equip_fist(U.hands.LEFT)
	slot_manager.equip_fist(U.hands.RIGHT)
	
	if comms_actor_choice and self.global_position.distance_to(comms_actor_choice.global_position) < 9:
		comms_actor_choice.drop_weapon()
	return

func apply_raw_move(input_dir: Vector2):
	var direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y))
	if direction:
		velocity.x = direction.x
		velocity.z = direction.z
	return

func cycle_akimbo_types():
	var end_index: int = len(akimbo_types) - 1
	var next_index: int = akimbo_type + 1
	if next_index > end_index:
		next_index = 0
	akimbo_type = akimbo_types[next_index]
	akimbo_type_changed.emit(akimbo_type)
	$Sound/selected_sound.play()
	return

func input_control():
	return

func add_madwater(extra_health: int):
	var new_health: int = health + extra_health
	hud.set_doom_message("You drank a flask. You feel a bit mad!")
	var start_alpha: float = 0.55
	var end_alpha: float = 0.0
	# Quick fade time = 5.0 (you should diversify punch anims if you use this)
	# Slow fade time = 25.0 (DOOM-like?)
	var fade_time: float = 35.0
	var t_modulate: Tween = get_tree().create_tween()
	t_modulate.tween_method(
		func (value): $HUD/madwater_screen.modulate = value,
		Color(1.0, 0.0, 0.0, start_alpha),
		Color(1.0, 0.0, 0.0, end_alpha),
		fade_time
	)
	
	health = new_health
	is_mad = true
	await get_tree().create_timer(fade_time).timeout
	is_mad = false
	return

func add_health(extra_health: int, overfill: bool = false):
	var new_health: int = health + extra_health
	if extra_health > 50:
		hud.set_doom_message("You drank a flask. Feeling wonderful.")
	else:
		hud.set_doom_message("You drank a flask. Feeling a little better.")
	var start_alpha: float = 0.55
	var end_alpha: float = 0.0
	var t_modulate: Tween = get_tree().create_tween()
	t_modulate.tween_method(
		func (value): $HUD/addhealth_screen.modulate = value,
		Color(1.0, 1.0, 1.0, start_alpha),
		Color(1.0, 1.0, 1.0, end_alpha),
		.25
	)
	
	if overfill:
		health = new_health
		return
	
	if not overfill and new_health > health:
		health = 100
		return
	return

func interaction_control():
	if not $interact_timer.is_stopped():
		return
	
	#var is_interacting: bool = false
	var touching_distance: float = 5.0
	var poseballs: Array = get_tree().get_nodes_in_group("poseballs")
	for poseball in poseballs:
		if self.global_position.distance_to(poseball.global_position) < touching_distance:
			poseball.interact(self)
			return
	# -------------- #
	
	var area_bodies: Array[Node3D] = interact_area.get_overlapping_bodies()
	if area_bodies.is_empty():
		return
	
	if len(area_bodies) == 1 and area_bodies[0] == self:
		return
	
	var interactables: Array[Object] = []
	for body in area_bodies:
		if body.is_in_group("interactables"):
			interactables.append(body)
			break # DEBUG
	
	for interactable in interactables:
		interactable.interact(self)
		#is_interacting = true
	
	#if not is_interacting:
		#$Sound/failed_interact_sound.play()
	$interact_timer.start()
	return

func mod_interaction_control():
	if carried_actor:
		return
	
	if not $interact_timer.is_stopped():
		return
	
	$interact_timer.start()
	
	var area_bodies: Array[Node3D] = interact_area.get_overlapping_bodies()
	if area_bodies.is_empty():
		return
	
	var mod_interactables: Array[Node3D] = []
	for body in area_bodies:
		if body.is_in_group("mod_interactables"):
			mod_interactables.append(body)
	
	for interactable in mod_interactables:
		interactable.mod_interact(self)
		break # Added to stop mass-interacting
		if carried_actor:
			carried_actor.add_collision_exception_with(self)
			carried_actor_instance_id = carried_actor.get_instance_id()
			break
	
	if carried_actor:
		is_lifting = true
		is_carrying_actor = true
		noko_anim.stop()
		noko_anim.play("lifter_pick_up")
		var carry_pos_offset: float = 1.5
		$graphics/pos_actor_carry/anchor.position.y -= carry_pos_offset
		await noko_anim.animation_finished
		$graphics/pos_actor_carry/anchor.position.y += carry_pos_offset
		is_lifting = false
	
	return

func stop_sitting():
	$interact_timer.start()
	is_sitting = false
	is_rotation_locked = false
	self.global_position = last_saved_global_position
	self.global_rotation = last_saved_global_rotation
	cam_base.global_rotation = last_saved_cam_rotation
	graphics.global_rotation = last_saved_graphics_rotation
	last_saved_global_rotation = Vector3.ZERO
	last_saved_cam_rotation = Vector3.ZERO
	self.velocity = Vector3.ZERO
	A.gradual_velo_stop(self, Vector3.ZERO, .3) # Stop flying away?
	return

func sit(caller, type: String):
	if is_sitting:
		#is_sitting = false
		return
	
	match type:
		"sit_chair":
			last_saved_global_position = self.global_position
			last_saved_global_rotation = self.global_rotation
			last_saved_cam_rotation = cam_base.global_rotation
			last_saved_graphics_rotation = graphics.global_rotation
			is_sitting = true
			is_rotation_locked = true
			anim_h("sit_chair", false, true)
			footsteps_player.play("silence")
			self.global_position = caller.global_position
			self.global_rotation = caller.global_rotation
			$graphics.global_rotation = caller.global_rotation
			return
		_:
			return
	return

func ammo_from_item(ammo_type: int, ammo_count: int):
	slot_manager.add_ammo(ammo_type, ammo_count)
	$Sound/pickup_sound.play()
	hud._ammo_changed()
	hud.set_doom_message("You picked up " + str(ammo_count) + " pieces of " + U.ammo_types.keys()[ammo_type])
	return

func add_credits(credits_amount: int):
	if not Global.prop_table["credits"].has([self.offline_id]):
		Global.prop_table["credits"][self.offline_id] = 0
	
	Global.prop_table["credits"][self.offline_id] += credits_amount
	hud.set_doom_message("You picked up " + str(credits_amount) + " credits!")
	return

func focus_toggle(focus_state: bool):
	if is_diving:
		focus_state = false
		return # MIGHT BREAK
	
	if is_heavy_kicking:
		focus_state = false
	if is_pumping_shotgun:
		focus_state = false
	
	var ik_nodes: Array[SkeletonIK3D]
	#if rhand_anchor.get_child_count() > 0:
	
	if (
		rhand_anchor.get_child_count() > 0 or \
		(armed_type == U.armed_types.UNARMED and is_pointing)
		):
		ik_nodes.append(rhand_ik)
	if lhand_anchor.get_child_count() > 0:
		ik_nodes.append(lhand_ik)
	
	if ik_nodes.is_empty():
		#push_error("Function focus_toggle called with focus_state = true and ik_node is an empty array.")
		# Assuming melee, if so, hold out right hand
		ik_nodes.append(rhand_ik)
	
	rhand_ik.target_node = carrot_right.get_path()
	lhand_ik.target_node = carrot_left.get_path()
	for ik_node in ik_nodes:
		if focus_state and not ik_node.is_running():
			ik_node.start()
	
	if not focus_state:
		rhand_ik.stop()
		lhand_ik.stop()
#	for ik_node in ik_nodes:
#		if not focus_state and ik_node.is_running():
#			ik_node.stop()
	return

func toggle_cam_side():
	if is_view_chain_started: return
	
	if is_ads_mode and is_ads_sidecar_mode:
		if ads_cam.position == default_ads_sidecar_pos:
			toggle_ads_mode()
			toggle_ads_mode(default_ads_sidecar_pos * -1)
		else:
			toggle_ads_mode()
			toggle_ads_mode(default_ads_sidecar_pos)
		return
	
	if is_ads_mode and not is_ads_sidecar_mode:
		if ads_cam.rotation_degrees.y < 180:
			ads_cam.rotation_degrees.y = 180
			ads_cam.fov = 120
		elif ads_cam.rotation_degrees.y >= 180:
			ads_cam.rotation_degrees.y = 0
			ads_cam.fov = 90
		return
	
	var cam_clipper = cam_base.get_node("SpringArm3D")
	cam_clipper.position.x = -cam_clipper.position.x
	if cam_clipper.position.x > 0:
		cam_side = U.hands.RIGHT # didn't want to use a string, didn't want to make another enum
	elif cam_clipper.position.x < 0:
		cam_side = U.hands.LEFT # didn't want to use a string, didn't want to make another enum
	
	tight_cam.position.x = -tight_cam.position.x
	return

func toggle_torso_cam():
	if exit_mode: return
	if is_ads_mode: return
	
	if torso_cam.current and is_cam_tight:
		tight_cam.make_current()
	elif torso_cam.current and not is_cam_tight:
		main_cam.make_current()
	else:
		torso_cam.make_current()
	return

func reload_control():
	if not is_input_allowed: return
	if is_reloading:
		return
	
	match slot_manager.hand_state:
		U.hand_states.EMPTY:
			block()
		U.hand_states.SINGLE_LEFT:
			is_reloading = true
			reload_timer.start()
			noko_anim.speed_scale = .5
			var is_reload_successful: bool = slot_manager.weapon_reload(U.hands.LEFT)
			if is_reload_successful:
				anim_h(anim_set["reload"], false, true)
			
		U.hand_states.SINGLE_RIGHT:
			is_reloading = true
			reload_timer.start()
			noko_anim.speed_scale = .5
			var is_reload_successful: bool = slot_manager.weapon_reload(U.hands.RIGHT)
			if is_reload_successful:
				anim_h(anim_set["reload"], false, true)
			
		U.hand_states.AKIMBO:
			is_reloading = true
			
			reload_timer.start()
			noko_anim.speed_scale = .5
			var is_left_reload_successful: bool = slot_manager.weapon_reload(U.hands.LEFT)
			var is_right_reload_successful: bool = slot_manager.weapon_reload(U.hands.RIGHT)
			if is_left_reload_successful or is_right_reload_successful:
				anim_h(anim_set["reload"], false, true)
			
	
	
#	if rhand_anchor.get_child_count() < 1:
#		return
#
#	var rhand_held := rhand_anchor.get_child(0)
#	if is_input_allowed and Input.is_action_just_pressed("reload") and rhand_held.name == "fist":
#		block()
#		return
#
#	if is_input_allowed and Input.is_action_just_pressed("reload"):
#		rhand_held.reload(self)
#		is_reloading = true
#		reload_timer.start()
#		noko_anim.speed_scale = .5
#		anim_h(anim_set["reload"], false, true)
	return


func block():
	return # Block might be a lot of time/work
		   # Thinking of doing some kind of cheap counter moving thing
		   # instead
	is_melee_blocking = true
	block_timer.start()
	anim_h("block", false, true)
	return

func primary_action_control():
	if not is_input_allowed: return
	if is_reloading: return
	if is_heavy_punching: return
	
	if is_carrying_world_item:
		throw_world_item()
		return
	
	var action_event: int = slot_manager.primary_action()
	
	if action_event == -1: push_error(self.name + " Primary action event is -1. Bad!")
	
	match action_event:
		U.action_events.MELEE_PUNCH:
			if Input.is_action_just_pressed("primary_action") and not Input.is_action_pressed("mod") and is_punch_allowed:
				if not is_mad:
					punch()
				elif is_mad:
					madwater_punch()
				is_punch_allowed = false
			if Input.is_action_just_pressed("primary_action") and Input.is_action_pressed("mod") and is_punch_allowed:
				heavy_punch()
				is_punch_allowed = false
		
		U.action_events.SHOOT:
			shoot_action()
		
		U.action_events.IGNORED:
			if Input.is_action_just_released("primary_action"):
				is_punch_allowed = true
	
	return

func mod_action_control():
	if not is_input_allowed: return
	if is_reloading: return
	
	if armed_type == U.armed_types.UNARMED:
		heavy_punch()
	else:
		armed_melee_attack()
	return

func akimbo_unlinked_shoot():
	if not is_input_allowed: return
	if is_reloading: return
	if akimbo_type != U.akimbo_types.UNLINKED: return
	
	# I haven't seen this in a while, why is the hand index the left one? Who or what is shooting the--
	# Oh okay it's probably already shooting elsewhere and this is just tagging along. My guess.
	var hand_idx: int = U.hands.LEFT
	var weapon: Node3D = slot_manager.get_held_weapon(hand_idx)
	if not weapon:
		slot_manager.set_hand_state()
		return
	
	var is_tapper: bool = (weapon.primary_action_type == U.primary_action_types.TAP)
	var is_holder: bool = (weapon.primary_action_type == U.primary_action_types.HOLD)
	if is_tapper and Input.is_action_just_pressed("focus") and not Input.is_action_pressed("mod"):
		slot_manager.weapon_attack(hand_idx)
	elif is_holder and Input.is_action_pressed("focus") and not Input.is_action_pressed("mod"):
		slot_manager.weapon_attack(hand_idx)
	elif is_holder and Input.is_action_just_released("focus") and not Input.is_action_pressed("mod"):
		slot_manager.weapon_cease(hand_idx)

	return

func mod_shoot_action():
	return

func shoot_action():
	var hand_indexes: Array[int] = []
	match armed_type:
		U.armed_types.ARMED:
			hand_indexes.append(U.hands.RIGHT)
		U.armed_types.ARMEDLEFT:
			hand_indexes.append(U.hands.LEFT)
		U.armed_types.AKIMBO:
			hand_indexes.append(U.hands.RIGHT)
			hand_indexes.append(U.hands.LEFT)
		U.armed_types.UNARMED:
			push_error("Shooting unarmed. Was this supposed to happen?")
	
	var is_special_akimbo: bool = (
		armed_type == U.armed_types.AKIMBO and akimbo_type != U.akimbo_types.LINKED
	)
	
	if not is_special_akimbo:
		## 20240324T0620
		## When linked shooting, holding down attack will shoot a semi once and full auto continuously.
		## Editing so the semi auto will pretend to be a full auto if a full auto is present.
		
		#for hand_idx in hand_indexes:
			#var weapon: Node3D = slot_manager.get_held_weapon(hand_idx)
			#var is_tapper: bool = (weapon.primary_action_type == U.primary_action_types.TAP)
			#var is_holder: bool = (weapon.primary_action_type == U.primary_action_types.HOLD)
			#if is_tapper and Input.is_action_just_pressed("primary_action"):
				#slot_manager.weapon_attack(hand_idx)
			#elif is_holder and Input.is_action_pressed("primary_action"):
				#slot_manager.weapon_attack(hand_idx)
			#elif is_holder and Input.is_action_just_released("primary_action"):
				#slot_manager.weapon_cease(hand_idx)
				
		var is_mixed_firemode: bool = false
		var hand_weapons: Array = []
		for hand_idx in hand_indexes:
			var weapon: Node3D = slot_manager.get_held_weapon(hand_idx)
			var is_tapper: bool = (weapon.primary_action_type == U.primary_action_types.TAP)
			var is_holder: bool = (weapon.primary_action_type == U.primary_action_types.HOLD)
			if is_holder:
				is_mixed_firemode = true
			hand_weapons.append({"node": weapon, "hand": hand_idx, "tapper": is_tapper, "holder": is_holder})
		
		if is_mixed_firemode and Input.is_action_pressed("primary_action"): # Linked shooting assumed because of the block we're in
			is_mixed_linked_shooting = true
		elif is_mixed_firemode and Input.is_action_just_released("primary_action"):
			is_mixed_linked_shooting = false
		
		# If it's linked and both are full auto
		# Or if it's linked and both are semi auto
		for hand_weapon in hand_weapons:
			var hand_idx = hand_weapon["hand"]
			var is_tapper = hand_weapon["tapper"]
			var is_holder = hand_weapon["holder"]
			
			if not is_mixed_firemode:
				if is_tapper and Input.is_action_just_pressed("primary_action"):
					slot_manager.weapon_attack(hand_idx)
				elif is_holder and Input.is_action_pressed("primary_action"):
					slot_manager.weapon_attack(hand_idx)
				elif is_holder and Input.is_action_just_released("primary_action"):
				#elif Input.is_action_just_released("primary_action"):
					slot_manager.weapon_cease(hand_idx)
				continue
			elif is_mixed_firemode:
				if is_tapper and Input.is_action_pressed("primary_action"):
					# If is_tapper, check ticker
					# If ticker < 0.0, shoot and reset
					if linked_shoot_semi_ticker < 0.0:
						slot_manager.weapon_attack(hand_idx)
						var random_fire_rate: float = randf_range(hand_weapon["node"].fire_rate, hand_weapon["node"].fire_rate * 1.6)
						linked_shoot_semi_ticker = (60/random_fire_rate)
				elif is_holder and Input.is_action_pressed("primary_action"):
					slot_manager.weapon_attack(hand_idx)
				elif is_holder and Input.is_action_just_released("primary_action"):
					slot_manager.weapon_cease(hand_idx)
				continue
		
	elif is_special_akimbo:
		var hand_idx: int = -1
		match akimbo_type:
			U.akimbo_types.LINKED:
				pass # This should have been handled in previous "not is_special_akimbo" block
			U.akimbo_types.UNLINKED:
				hand_idx = U.hands.RIGHT
			U.akimbo_types.SWITCH:
				hand_idx = akimbo_switch_index

				var left_item: Dictionary = slot_manager.get_active_item(U.hands.LEFT)
				var right_item: Dictionary = slot_manager.get_active_item(U.hands.RIGHT)
				var is_left_empty: bool = left_item["ammo_count"] < 1
				var is_right_empty: bool = right_item["ammo_count"] < 1
				
				if is_left_empty and not is_right_empty:
					hand_idx = U.hands.RIGHT
				elif not is_left_empty and is_right_empty:
					hand_idx = U.hands.LEFT
				elif is_left_empty and is_right_empty:
					hand_idx = U.hands.RIGHT
		
		var weapon: Node3D = slot_manager.get_held_weapon(hand_idx)
		var is_tapper: bool = (weapon.primary_action_type == U.primary_action_types.TAP)
		var is_holder: bool = (weapon.primary_action_type == U.primary_action_types.HOLD)
		
		if is_tapper and Input.is_action_just_pressed("primary_action"):
			slot_manager.weapon_attack(hand_idx)
		elif is_tapper and Input.is_action_just_released("primary_action"):
			cycle_akimbo_switch_index()
		elif is_holder and Input.is_action_pressed("primary_action"):
			slot_manager.weapon_attack(hand_idx)
		elif is_holder and Input.is_action_just_released("primary_action"):
			slot_manager.weapon_cease(hand_idx)
			cycle_akimbo_switch_index()
	return

func cycle_akimbo_switch_index():
	match akimbo_switch_index:
		U.hands.RIGHT:
			akimbo_switch_index = U.hands.LEFT
		U.hands.LEFT:
			akimbo_switch_index = U.hands.RIGHT
	return

func toggle_freecam(choice: int = -1):
	if is_freecarrot:
		return
	
	if not is_freecam or choice == 1:
		ghost_global_rotation.global_rotation = self.global_rotation
		ghost_cam_rotation.global_rotation = cam_base.global_rotation
		ghost_graphics_rotation.global_rotation = graphics.global_rotation
	elif is_freecam or choice == 0:
		graphics.rotation_degrees.x = cam_base.rotation_degrees.x
		self.global_rotation.y = cam_base.global_rotation.y
		cam_base.rotation_degrees.y = 0
	
		#cam_base.rotation_degrees.x = ghost_cam_rotation.rotation_degrees.x
		#graphics.rotation_degrees.y = 0
	
	if choice == 1:
		is_freecam = true
	elif choice == 0:
		is_freecam = false
	else:
		is_freecam = !is_freecam
	
	return

func freecam_mouselook(event: InputEvent):
	# Couldn't smash this one out.
	# The solution is simple I think.
	# There are ghost variables that keep the original rotation for switching back to standard cam
	# The parent node...
	if event is InputEventMouseMotion and not is_mouselook_locked:
		cam_base.rotation.x -= (event.relative.y * mouse_sensitivity)
		cam_base.rotation_degrees.x = clamp(cam_base.rotation_degrees.x, -180, 180)
		
		## Move camera's Y regardless of lock
		#if is_rotation_locked:
			#cam_base.rotation.y -= (event.relative.x * mouse_sensitivity)
			#return
		
		cam_base.rotation.y -= (event.relative.x * mouse_sensitivity)
		
		## Don't rotate character
		#graphics.rotation.x -= (event.relative.y * mouse_sensitivity)
		#graphics.rotation_degrees.x = clamp(graphics.rotation_degrees.x, -180, 180)
		
		## Don't rotate character
		#if not enable_flip_mouse_invert:
			## Default left-and-right looking
			#self.rotation.y -= (event.relative.x * mouse_sensitivity)
		
		## Don't rotate character
		#if cam_base.rotation_degrees.x < -cam_flip_threshold or cam_base.rotation_degrees.x > cam_flip_threshold:
			#if enable_flip_mouse_invert:
				#self.rotation.y += (event.relative.x * mouse_sensitivity)
			#is_flipped = true
		#else:
			#if enable_flip_mouse_invert:
				#self.rotation.y -= (event.relative.x * mouse_sensitivity)
			#is_flipped = false
	
	return


func toggle_freecarrot():
	if is_freecam:
		return
	
	if not is_freecarrot:
		last_saved_carrot_spatial.position = carrot_right.position
		last_saved_carrot_spatial.rotation = carrot_right.rotation
		last_saved_external_carrot_base_spatial.position = external_carrot_base.position
		last_saved_external_carrot_base_spatial.rotation = external_carrot_base.rotation

	elif is_freecarrot:
		graphics.rotation_degrees.x = cam_base.rotation_degrees.x
		self.global_rotation.y = cam_base.global_rotation.y
		cam_base.rotation_degrees.y = 0
		carrot_right.position = last_saved_carrot_spatial.position
		carrot_right.rotation = last_saved_carrot_spatial.rotation
		external_carrot_base.position = last_saved_external_carrot_base_spatial.position
		external_carrot_base.rotation = last_saved_external_carrot_base_spatial.rotation
		
		#torso_cam.rotation_degrees.x = 0
		torso_cam.rotation_degrees.y = -180
		#torso_cam.rotation_degrees.z = 0
	
	is_freecarrot = !is_freecarrot
	return

func freecarrot_mouselook(event: InputEvent):
	# Couldn't smash this one out.
	# The solution is simple I think.
	# There are ghost variables that keep the original rotation for switching back to standard cam
	# The parent node...
	if event is InputEventMouseMotion and not is_mouselook_locked:
		torso_cam.rotation.y -= (event.relative.x * mouse_sensitivity)
		torso_cam.rotation_degrees.y = clamp(cam_base.rotation_degrees.y, -96, 33) - 180
		
		cam_base.rotation.y -= (event.relative.x * mouse_sensitivity)
		cam_base.rotation.x -= (event.relative.y * mouse_sensitivity)
		cam_base.rotation_degrees.x = clamp(cam_base.rotation_degrees.x, -180, 180)
		cam_base.rotation_degrees.y = clamp(cam_base.rotation_degrees.y, -96, 33)
		
		external_carrot_base.rotation.y -= (event.relative.x * mouse_sensitivity)
		external_carrot_base.rotation.x -= (event.relative.y * mouse_sensitivity)
		external_carrot_base.rotation_degrees.x = clamp(external_carrot_base.rotation_degrees.x, -180, 180)
		external_carrot_base.rotation_degrees.y = clamp(external_carrot_base.rotation_degrees.y, -96, 33)
		
		carrot_right.global_position = external_carrot.global_position
		carrot_right.global_rotation = external_carrot.global_rotation
		
		## Move camera's Y regardless of lock
		#if is_rotation_locked:
			#cam_base.rotation.y -= (event.relative.x * mouse_sensitivity)
			#return

		
		## Don't rotate character
		#graphics.rotation.x -= (event.relative.y * mouse_sensitivity)
		#graphics.rotation_degrees.x = clamp(graphics.rotation_degrees.x, -180, 180)
		
		## Don't rotate character
		#if not enable_flip_mouse_invert:
			## Default left-and-right looking
			#self.rotation.y -= (event.relative.x * mouse_sensitivity)
		
		## Don't rotate character
		#if cam_base.rotation_degrees.x < -cam_flip_threshold or cam_base.rotation_degrees.x > cam_flip_threshold:
			#if enable_flip_mouse_invert:
				#self.rotation.y += (event.relative.x * mouse_sensitivity)
			#is_flipped = true
		#else:
			#if enable_flip_mouse_invert:
				#self.rotation.y -= (event.relative.x * mouse_sensitivity)
			#is_flipped = false
	
	return



func toggle_crouch():
	is_crouching = !is_crouching
	var carrot_left_height_scale: float = 1
	var carrot_left_rotation_x_offset: float = 0
	var carrot_left_rotation_y_offset: float = 0 # 12
	var carrot_left_rotation_z_offset: float = 0
	
	if is_crouching:
		$hitbox_feet.disabled = false
		var crouch_offset_y: float = 3
		self.global_position.y += crouch_offset_y
		cam_base.get_node("SpringArm3D").position.y -= crouch_cam_offset_y
		tight_cam.position.y -= (crouch_cam_offset_y * .8)
		
		last_saved_carrot_spatial.position.y -= crouch_cam_offset_y
		external_carrot.position.y -= crouch_cam_offset_y
		carrot_right.position.y -= crouch_cam_offset_y
		carrot_left.position.y -= (crouch_cam_offset_y * carrot_left_height_scale)
		carrot_left.rotation_degrees.x -= carrot_left_rotation_x_offset
		carrot_left.rotation_degrees.y -= carrot_left_rotation_y_offset
		carrot_left.rotation_degrees.z -= carrot_left_rotation_z_offset
		hitbox_lower_anim.play("half")
		
		if is_armed_twohanded:
			set_armed_type(armed_type)
		else:
			anim_set["idle"] = "crouch"
			anim_set["run"] = "crouch_run"
			anim_set["reload"] = "crouch_reload"
			anim_set["jump"] = "crouch"
			anim_set["melee_secondary"] = "crouch_kick"
			anim_set["flinch"] = "crouch_flinch"
		
		if is_jumping: anim_h(anim_set["crouch"])
		if is_reloading: anim_h(anim_set["reload"])
	
	
	if not is_crouching:
		$hitbox_feet.disabled = true
		if not is_casual_animset:
			set_armed_type(armed_type)
		else:
			lazy_unarmed_anim_set()
		self.global_position.y += 1
		cam_base.get_node("SpringArm3D").position.y += crouch_cam_offset_y
		tight_cam.position.y += (crouch_cam_offset_y * .8)
		
		last_saved_carrot_spatial.position.y += crouch_cam_offset_y
		external_carrot.position.y += crouch_cam_offset_y
		carrot_right.position.y += crouch_cam_offset_y
		carrot_left.position.y += (crouch_cam_offset_y * carrot_left_height_scale)
		carrot_left.rotation_degrees.x += carrot_left_rotation_x_offset
		carrot_left.rotation_degrees.y += carrot_left_rotation_y_offset
		carrot_left.rotation_degrees.z += carrot_left_rotation_z_offset
		hitbox_lower_anim.play("full")
		var popped_anim: Variant = queued_anims.pop_front()
		if popped_anim:
			anim_h(popped_anim)
	return


func anim_h(anim_name: String, is_queued: bool = true, force_anim: bool = false):
	if player_interface:
		return
	
	if anim_name == last_anim and not force_anim:
		return
	noko_anim.play(anim_name)
	if is_queued:
		queued_anims.push_back(anim_name)
	last_anim = anim_name
	return


func set_armed_type(new_armed_type):
	match new_armed_type:
		U.armed_types.UNARMED:
			anim_set["idle"] = "unarmed_idle"
			anim_set["run"] = "unarmed_run"
			anim_set["reload"] = "reload" # Nothing to reload?!
			anim_set["jump"] = "unarmed_jump"
			anim_set["crouch"] = "crouch"
			anim_set["melee_secondary"] = "melee_secondary"
			anim_set["flinch"] = "flinch"
			anim_set["handstand"] = "unarmed_handstand"
		U.armed_types.ARMED:
			if is_armed_twohanded:
				set_twohanded_anims()
				#anim_set["idle"] = "armedlong_idle"
				#anim_set["run"] = "armedlong_run"
				#anim_set["reload"] = "armedlong_reload"
				#anim_set["jump"] = "armed_jump"
				#anim_set["crouch"] = "armedlong_crouch"
				#anim_set["melee_secondary"] = "melee_secondary"
				#anim_set["flinch"] = "flinch"
				#anim_set["handstand"] = "armed_handstand"
			elif not is_armed_twohanded:
				var reload_anim: String = "reload"
				if not is_carrying_world_item and slot_manager.get_held_weapon(U.hands.RIGHT).fire_mode == U.fire_modes.SINGLE_ACTION:
					reload_anim = "armedpistol_reload_shell"
				
				anim_set["idle"] = "armed_idle"
				anim_set["run"] = "armed_run"
				anim_set["reload"] = reload_anim
				anim_set["jump"] = "armed_jump"
				anim_set["crouch"] = "crouch"
				anim_set["melee_secondary"] = "melee_secondary"
				anim_set["flinch"] = "flinch"
				anim_set["handstand"] = "armed_handstand"
		U.armed_types.ARMEDLEFT:
			var reload_anim: String = "reload"
			if slot_manager.get_held_weapon(U.hands.LEFT).fire_mode == U.fire_modes.SINGLE_ACTION:
				reload_anim = "armedlongLEFT_reload_shell"
			
			anim_set["idle"] = "armedLEFT_idle"
			anim_set["run"] = "armedLEFT_run"
			anim_set["reload"] = reload_anim
			anim_set["jump"] = "armedLEFT_jump"
			anim_set["crouch"] = "crouch"
			anim_set["melee_secondary"] = "melee_secondary"
			anim_set["flinch"] = "flinch"
			anim_set["handstand"] = "armedLEFT_handstand"
		U.armed_types.AKIMBO:
			anim_set["idle"] = "akimbo_idle"
			anim_set["run"] = "akimbo_run"
			anim_set["reload"] = "reload"
			anim_set["jump"] = "akimbo_jump"
			anim_set["crouch"] = "crouch"
			anim_set["melee_secondary"] = "melee_secondary"
			anim_set["flinch"] = "flinch"
			anim_set["handstand"] = "armed_handstand"
	
	if is_crouching: # Don't know why this is here but it's probably here for a reason.
		#anim_set["idle"] = "crouch"
		#anim_set["run"] = "crouch_run"
		#anim_set["reload"] = "crouch_reload"
		#anim_set["jump"] = "crouch"
		if armed_type == U.armed_types.ARMED and is_armed_twohanded:
			#anim_set["idle"] = "armedlong_crouch"
			#anim_set["run"] = "armedlong_crouch_run"
			#anim_set["reload"] = "crouch_reload"
			#anim_set["jump"] = "crouch"
			set_twohanded_anims()
		else:
			anim_set["idle"] = "crouch"
			anim_set["run"] = "crouch_run"
			anim_set["reload"] = "crouch_reload"
			anim_set["jump"] = "crouch"
	
	armed_type = new_armed_type
	return

func set_twohanded_anims():
	# Assume right hand. When I set up the animations
	# for the left hand I'll figure out some logic.
	# Probably just check which hand has a weapon
	# in it and determine left/right from that.
	var weapon: Node3D = slot_manager.get_held_weapon(U.hands.RIGHT)
	
	if not weapon:
		return
	# --- Crouching --- #
	if is_crouching and weapon.size == U.weapon_sizes.LONG:
		anim_set["idle"] = "armedlong_crouch"
		anim_set["run"] = "armedlong_crouch_run"
		anim_set["reload"] = "crouch_reload"
		anim_set["jump"] = "crouch"
	elif is_crouching and weapon.size == U.weapon_sizes.SHORT:
		anim_set["idle"] = "armedshort_crouch"
		anim_set["run"] = "armedshort_crouch_run"
		anim_set["reload"] = "crouch_reload"
		anim_set["jump"] = "crouch"
	elif is_crouching and weapon.size == U.weapon_sizes.PISTOL:
		anim_set["idle"] = "armedpistol_crouch"
		anim_set["run"] = "armedpistol_crouch_run"
		anim_set["reload"] = "crouch_reload"
		anim_set["jump"] = "crouch"
	
	if is_crouching: return
	
	# --- Standing --- #
	if weapon.size == U.weapon_sizes.LONG:
		anim_set["idle"] = "armedlong_idle"
		anim_set["run"] = "armedlong_run"
		anim_set["reload"] = "armedlong_reload"
		anim_set["jump"] = "armed_jump"
		anim_set["crouch"] = "armedlong_crouch"
		anim_set["melee_secondary"] = "melee_secondary"
		anim_set["flinch"] = "flinch"
		anim_set["handstand"] = "armed_handstand"
	elif weapon.size == U.weapon_sizes.SHORT:
		anim_set["idle"] = "armedshort_idle"
		anim_set["run"] = "armedshort_run"
		anim_set["reload"] = "armedshort_reload"
		anim_set["jump"] = "armed_jump"
		anim_set["crouch"] = "armedshort_crouch"
		anim_set["melee_secondary"] = "melee_secondary"
		anim_set["flinch"] = "flinch"
		anim_set["handstand"] = "armed_handstand"
	elif weapon.size == U.weapon_sizes.PISTOL:
		anim_set["idle"] = "armedpistol_idle"
		anim_set["run"] = "armedpistol_run"
		anim_set["reload"] = "armedpistol_reload"
		anim_set["jump"] = "armed_jump"
		anim_set["crouch"] = "armedpistol_crouch"
		anim_set["melee_secondary"] = "melee_secondary"
		anim_set["flinch"] = "flinch"
		anim_set["handstand"] = "armed_handstand"
	return

func get_fist_node():
	return $graphics/noko/Armature/Skeleton3D/attach_torso/anchor.get_node("fist")

func punch():
	var fist: Node3D = get_fist_node()
	
	is_punching = true
	#punch_timer.start() # Trying to use punch_delta instead
	if is_crouching:
		anim_h("crouch_punch", false, true)
	elif Input.is_action_pressed("mode_shift"):
		anim_h(punch_anims[punch_anim_idx], false, true)
		if fist:
			fist.is_speed_punching = true
	else:
		anim_h(punch_b_anims[punch_anim_idx], false, true)
		if fist:
			fist.is_speed_punching = false
	#var punch_sound: AudioStreamPlayer3D
	punch_sounds[punch_anim_idx].play()
	punch_anim_idx = 0 if punch_anim_idx == 1 else 1
	return

func heavy_punch():
	#var fist: Node3D = get_fist_node()
	if is_punching or is_heavy_punching:
		return
	
	is_punching = true # Keeping this in because.. well, I'm scared to take it out.
	is_heavy_punching = true
	
	noko_anim.speed_scale = 1.0
	var punch_anim_name: String
	if is_crouching:
		punch_anim_name = "crouch_heavy_punch_1"
	else:
		punch_anim_name = "heavy_punch_1"
	anim_h(punch_anim_name, false, true)
	
	trigger_delayed_heavy_punch_hit()
	
	#await noko_anim.animation_finished
	await get_tree().create_timer(
		noko_anim.get_animation(punch_anim_name).length
	).timeout
	is_heavy_punching = false
	return

func madwater_punch():
	if is_heavy_punching:
		return
	is_heavy_punching = true
	anim_h("madwater_punch_1", false, true)
	var hit_takers: Array = get_hand_prox_hit_takers()
	if hit_takers:
		$Sound/madpunch_hit.play()
	
	var madpunch_damage: int = 100
	var knockback_speed: float = 5.0
	#####
	var is_crouch_punch: bool
	for hit_taker in hit_takers:
		if not is_crouching:
			is_crouch_punch = false
			hit_taker.hit(madpunch_damage, U.hit_types.UNDEFINED, self, rhand_anchor.global_position)
			if is_instance_of(hit_taker, CharacterBody3D):
				A.apply_move(hit_taker, Vector2.DOWN, knockback_speed)
		if is_crouching:
			is_crouch_punch = true
			hit_taker.hit(madpunch_damage, U.hit_types.UNDEFINED, self, rhand_anchor.global_position)
			if is_instance_of(hit_taker, CharacterBody3D):
				A.apply_move(hit_taker, Vector2.DOWN, knockback_speed)
				#hit_taker.velocity.y = JUMP_VELOCITY
		
		if is_instance_of(hit_taker, CharacterBody3D):
			hit_taker.move_and_slide()
	######
	
	var wait_time: float = noko_anim.get_animation("madwater_punch_1").length * .9
	await get_tree().create_timer(wait_time).timeout
	is_heavy_punching = false
	return

func get_hand_prox_hit_takers(proximity: float = 8.0):
	var hit_candidates: Array = get_tree().get_nodes_in_group("hit_takers")
	var hand_prox_hit_takers: Array = []
	for candidate in hit_candidates:
		if candidate.is_in_group("players"):
			continue
		if rhand_anchor.global_position.distance_to(candidate.global_position) < proximity:
			hand_prox_hit_takers.append(candidate)
			continue
	return hand_prox_hit_takers

func get_foot_prox_hit_takers(proximity: float = 8.0):
	var hit_candidates: Array = get_tree().get_nodes_in_group("hit_takers")
	var foot_prox_hit_takers: Array = []
	for candidate in hit_candidates:
		if candidate.is_in_group("players"):
			continue
		if rfoot_anchor.global_position.distance_to(candidate.global_position) < proximity:
			foot_prox_hit_takers.append(candidate)
			continue
	return foot_prox_hit_takers

func trigger_delayed_heavy_punch_hit():
	
	var delay_before_heavy_punch: float
	## Not using the fist from mod_action().
	## It uses the hitbox which is attached
	## to the chest, which MOVES ALL OVER THE PLACE! ;_;
	#get_tree().create_tween().tween_callback(
		#func():
			#slot_manager.mod_action()
			#punch_sounds[punch_anim_idx].play()
	#).set_delay(delay_before_heavy_punch)
	if not is_crouching:
		delay_before_heavy_punch = 0.65 # 0.6
	elif is_crouching:
		delay_before_heavy_punch = 0.4
	get_tree().create_tween().tween_callback(
		func():
			custom_heavy_punch_hit()
			punch_sounds[punch_anim_idx].play()
	).set_delay(delay_before_heavy_punch)
	return

func custom_heavy_punch_hit():
	var heavy_punch_damage: int = 45 # 65 # I like 65 but it's probably best for BERSERK mode
	var uppercut_damage: int = int(heavy_punch_damage * .75)
	var knockback_speed: float = 9.0
	var hit_takers: Array = get_hand_prox_hit_takers()
	if hit_takers:
		$Sound/heavy_punched_sound.play()
		camshake(3.0, .2)
	
	var is_actor_in_hit_takers: bool = false
	for hit_taker in hit_takers:
		if hit_taker.is_in_group("actors"):
			is_actor_in_hit_takers = true
			break
	
	var is_crouch_punch: bool
	for hit_taker in hit_takers:
		if is_actor_in_hit_takers and not hit_taker.is_in_group("actors"):
			continue # avoid unexpected barrel death
		if not is_crouching:
			is_crouch_punch = false
			hit_taker.hit(heavy_punch_damage, U.hit_types.UNDEFINED, self, rhand_anchor.global_position)
			if is_instance_of(hit_taker, CharacterBody3D):
				A.apply_move(hit_taker, Vector2.DOWN, knockback_speed)
		if is_crouching:
			is_crouch_punch = true
			hit_taker.hit(uppercut_damage, U.hit_types.UNDEFINED, self, rhand_anchor.global_position)
			if is_instance_of(hit_taker, CharacterBody3D):
				A.apply_move(hit_taker, Vector2.DOWN, knockback_speed)
				hit_taker.velocity.y = JUMP_VELOCITY
		
		if is_instance_of(hit_taker, CharacterBody3D):
			hit_taker.move_and_slide()
	
	#if is_crouch_punch and is_crouching:
	if is_crouching:
		self.velocity.y += (JUMP_VELOCITY * .5)
		await get_tree().create_timer(.25).timeout
		toggle_crouch()
	
	return

func trigger_delayed_heavy_kick_hit():
	var delay_before_heavy_kick: float
	if not is_crouching:
		delay_before_heavy_kick = 0.5
	elif is_crouching:
		delay_before_heavy_kick = 0.4
	get_tree().create_tween().tween_callback(
		func():
			custom_heavy_kick_hit()
			$Sound/kick1.play()
	).set_delay(delay_before_heavy_kick)
	return

func custom_heavy_kick_hit():
	var heavy_kick_damage: int = 55
	var uppercut_damage: int = int(heavy_kick_damage * .75)
	var knockback_speed: float = 15.0
	var hit_takers: Array = get_foot_prox_hit_takers()
	if hit_takers:
		$Sound/heavy_punched_sound.play()
		camshake(3.0, .2)
	
	var is_crouch_kick: bool
	
	var is_actor_in_hit_takers: bool = false
	for hit_taker in hit_takers:
		if hit_taker.is_in_group("actors"):
			is_actor_in_hit_takers = true
			break
	
	for hit_taker in hit_takers:
		if is_actor_in_hit_takers and not hit_taker.is_in_group("actors"):
			continue # Trying this to avoid unexpected barrel death
		if not is_crouching:
			is_crouch_kick = false
			hit_taker.hit(heavy_kick_damage, U.hit_types.UNDEFINED, self, rfoot_anchor.global_position)
			if is_instance_of(hit_taker, CharacterBody3D):
				A.apply_move(hit_taker, Vector2.DOWN, knockback_speed)
		if is_crouching:
			is_crouch_kick = true
			hit_taker.hit(uppercut_damage, U.hit_types.UNDEFINED, self, rfoot_anchor.global_position)
			if is_instance_of(hit_taker, CharacterBody3D):
				A.apply_move(hit_taker, Vector2.DOWN, knockback_speed)
				hit_taker.velocity.y = (JUMP_VELOCITY * .75)
		if is_instance_of(hit_taker, CharacterBody3D):
			hit_taker.move_and_slide()
	
	if is_crouch_kick and is_crouching:
		self.velocity.y += (JUMP_VELOCITY * .5)
		await get_tree().create_timer(.50).timeout
		toggle_crouch()
	
	return

func kick():
	is_kicking = true
	special_timer.start()
	anim_h(anim_set["melee_secondary"], false, true)
	if not is_kick_sliding:
		sound_kick.play()
	if is_crouching:
		kicker.crouch_kick(self)
	if not is_crouching:
		kicker.primary_action(self, U.primary_action_types.TAP)
	return

func heavy_kick():
	#var fist: Node3D = get_fist_node()
	#if is_kicking or is_heavy_kicking:
	if is_heavy_kicking:
		return
	
	is_kicking = true
	is_heavy_kicking = true
	
	#noko_anim.speed_scale = 1.5
	var kick_anim_name: String
	if is_crouching:
		noko_anim.speed_scale = 1.5
		kick_anim_name = "crouch_heavy_kick_1"
	else:
		noko_anim.speed_scale = 2.0
		kick_anim_name = "heavy_kick_1"
	
	anim_h(kick_anim_name, false, true)
	
	trigger_delayed_heavy_kick_hit()
	
	await get_tree().create_timer(
		noko_anim.get_animation(kick_anim_name).length - (noko_anim.get_animation(kick_anim_name).length * .1)
	).timeout
	is_kicking = false
	is_heavy_kicking = false
	return

func back_kick():
	is_kicking = true
	special_timer.start()
	anim_h("back_kick", false, true)
	sound_kick.play()
	kicker.back_kick(self, U.primary_action_types.TAP)
	return

func raw_kick_hurter():
	kicker.primary_action(self, U.primary_action_types.TAP)
	return

func kick_slide():
	if is_kick_sliding: return
	
	$sequencer.speed_scale = .75
	var slide_force: float = -33 # -25
	#self.velocity.y = (JUMP_VELOCITY * .60)
	apply_raw_move(Vector2(0, slide_force))
	$Sound/kick_slide_sound.play()
	
	$sequencer.play("kick_slide")
	
	$hitbox_head_col.disabled = true
	await get_tree().create_timer(1.0).timeout
	$hitbox_head_col.disabled = false
	return
	
func back_kick_slide():
	if is_kick_sliding: return
	
	$sequencer.speed_scale = 1
	var slide_force: float = -33
	apply_raw_move(Vector2(0, -slide_force))
	$Sound/kick_slide_sound.play()
	
	$sequencer.play("back_kick_slide")
	
	$hitbox_head_col.disabled = true
	await get_tree().create_timer(1.0).timeout
	$hitbox_head_col.disabled = false
	return

func set_prone_carrots():
	carrot_right = $graphics/prone_carrot
	carrot_left = $graphics/prone_carrot
	return

func set_hand_carrots():
	carrot_right = $graphics/carrot
	carrot_left = $graphics/carrot_left
	return

func ground_clip_control():
	if ground_clip_sensor.get_collider():
		self.velocity.y += 11
	return

func tight_cam_control():
	if is_dead: return
	if exit_mode: return
	if is_ads_mode: return
	
	var is_left_touching: bool = (left_shoulder_feeler.get_collider() != null)
	var is_right_touching: bool = (right_shoulder_feeler.get_collider() != null)
	
	var is_main_cam_gutter_touching: bool
	var assumed_world: World = get_tree().get_first_node_in_group("Worlds")
	var exclude_colliders: Array[RID] = [self.get_rid()]
	var world_raycast_result: Dictionary = U.world_raycast(
		assumed_world,
		main_cam.global_position,
		torso_anchor.global_position,
		exclude_colliders
	)
	if world_raycast_result.is_empty():
		is_main_cam_gutter_touching = false
	elif world_raycast_result:
		is_main_cam_gutter_touching = true
	#if left_shoulder_feeler.get_collider() and right_shoulder_feeler.get_collider():
	if (is_left_touching and is_right_touching) or is_main_cam_gutter_touching:
		# Tight space!
		is_cam_tight = true
		if torso_cam.current:
			return
		
		tight_cam.make_current()
		tight_cam_timer.start()
	else:
		# Not a tight space.
		is_cam_tight = false
	return

func step_lift_control():
	if step_raycast_toes.is_colliding() and not step_raycast_knees.is_colliding() and $step_timer.is_stopped():
		self.global_position.y += step_offset
		is_stepping = true
	if step_raycast_toes.is_colliding() and step_raycast_knees.is_colliding():
		is_stepping = false
		$step_timer.start() # For slopes? If it doesn't look like a step, wait a sec before stepping if it does
	return

func camshake(amount: float, duration: float):
	shader_camshake.visible = true
	var shader: Material = shader_camshake.material
	shader.set_shader_parameter("ShakeStrength", amount)
	get_tree().create_tween().tween_method(
		func(value): shader.set_shader_parameter("ShakeStrength", value),
		amount,
		0.00,
		duration
	)
	await get_tree().create_timer(duration + 0.1).timeout
	shader_camshake.visible = false
	return

func pickup(item_name: String, weapon_theme: int = -1):
	var picked_up_item: Dictionary = slot_manager.add_item(item_name, weapon_theme)
	$Sound/pickup_sound.play()
	
	if auto_equip:
		var equip_hand: int = -1
		var free_hand_idx: int = -1
		if armed_type == U.armed_types.ARMED:
			equip_hand = U.hands.LEFT
		elif armed_type == U.armed_types.ARMEDLEFT:
			equip_hand = U.hands.RIGHT
		else:
			equip_hand = U.hands.RIGHT
		free_hand_idx = (equip_hand - 1)
		slot_manager.equip_item(
			slot_manager.hand_nodes[free_hand_idx],
			picked_up_item["item"],
			equip_hand
		)
	return

func receive_world_pickup(world_pickup: Dictionary):
	if is_carrying_world_item: return
	
	if "node" in world_pickup:
		world_pickup["node"].reparent(world_item_anchor, false)
		active_world_item = world_pickup["node"]
	
	if "props" in world_pickup:
		active_world_item_props = world_pickup["props"]
	else:
		active_world_item_props.clear()
	
	var left_held: Node3D = slot_manager.get_held_weapon(U.hands.LEFT)
	var right_held: Node3D = slot_manager.get_held_weapon(U.hands.RIGHT)
	if left_held:
		toggle_hand_item(U.hands.LEFT)
	if right_held:
		toggle_hand_item(U.hands.RIGHT)
	
	is_carrying_world_item = true
	set_armed_type(U.armed_types.ARMED)
	return

func throw_world_item():
	is_throwing = true
	anim_h("melee_primary", false, true)
	
	is_carrying_world_item = false
	var dumb_projectile: Node3D = load("res://Scenes/dumb_projectile.tscn").instantiate()
	Blackboard.current_world.add_child(dumb_projectile)
	dumb_projectile.projectile_props = active_world_item_props
	dumb_projectile.projectile_initiator = self
	dumb_projectile.global_position = external_carrot.global_position
	#dumb_projectile.global_rotation = self.global_rotation
	dumb_projectile.set_projectile(active_world_item)
	
	#if active_world_item_props and "kill_callback" in active_world_item_props:
		#dumb_projectile.kill_callback = active_world_item_props["kill_callback"]
	active_world_item = null
	#active_world_item_props.clear()
	
	await get_tree().create_timer(.3).timeout
	is_throwing = false
	set_armed_type(U.armed_types.UNARMED)
	return

func recoil_kick(raw_recoil: float):
	var recoil: float = raw_recoil
	if is_armed_twohanded:
		recoil *= .5
	
	if is_freecam or is_freecarrot:
		var orig_graphics_x: float = graphics.rotation_degrees.x
		var orig_cam_base_x: float = cam_base.rotation_degrees.x
		var duration: float = .1
		get_tree().create_tween().tween_property(graphics, "rotation_degrees:x", orig_graphics_x, duration)
		get_tree().create_tween().tween_property(cam_base, "rotation_degrees:x", orig_cam_base_x, duration)
	
	if (is_freecam or is_freecarrot or is_being_choked) and armed_type == U.armed_types.AKIMBO and akimbo_type == U.akimbo_types.LINKED:
		camshake(recoil * .8, 0.1)
	else:
		graphics.rotation_degrees.x += recoil
		cam_base.rotation_degrees.x += recoil
	return

func _on_debug_ticker_timeout():
	return

func smooth_unrecoil(recoil:float, duration: float = .1):
	# Can't figure it out yet. Pushing down too much.
	# I would have to figure out like.. I don't know,
	# where it would be if there were no recoil
	# or something. I don't know.
	get_tree().create_tween().tween_method(func(step):
		graphics.rotation_degrees.x -= step
		cam_base.rotation_degrees.x -= step,
		duration/recoil,
		duration/recoil,
		duration)
	return

func _on_delayed_ticker_timeout():
	# Check for things here if not needed every frame
	if is_jumping and self.is_on_floor():
		is_jumping = false
		footsteps_player_alt.play("land")
		if not queued_anims.is_empty():
			anim_h(queued_anims.pop_front())
	if self.is_on_floor() and time_in_air > 0.0:
		time_in_air = 0.0
	
	health_screen_control()
	#tight_cam_control()
	return

func _on_special_timer_timeout():
	is_kicking = false
	return


func _on_punch_timer_timeout():
	is_punching = false
	return


func _on_coyote_timer_timeout():
	is_coyote_time = false
	return


func _on_block_timer_timeout():
	is_melee_blocking = false
	return


func _on_reload_timer_timeout():
	is_reloading = false
	return

func turn_on_lowhealth_screen():
	return

func turn_off_lowhealth_screen():
	return

func hurt_screen(amount: float, duration: float):
	if amount == 0.0:
		return
	
	elif duration < 0.0:
		$HUD/shader_hurt.visible = true
		$HUD/shader_hurt.material.set_shader_parameter("hurt_strength", amount)
		return
	
	elif amount > 0.0:
		get_tree().create_tween().tween_method(
			func(value): $HUD/shader_hurt.material.set_shader_parameter("hurt_strength", value),
			amount,
			0.0,
			duration
		)
		return
	return

func health_screen_control():
	#if health > low_health_threshold:
		#hurt_screen(0.6, 0.25)
		#return
	if is_dead:
		hurt_screen(0.6, -1)
		return
	
	var really_low_health: int = int(low_health_threshold / 2)
	if health > low_health_threshold:
		$HUD/lowhealth_screen.visible = false
	elif health > really_low_health and health < low_health_threshold:
		#hurt_screen(0.25, -1)
		$HUD/lowhealth_screen.visible = true
	elif health <= really_low_health:
		#hurt_screen(0.66, -1)
		#var mat: Material = $HUD/shader_hurt.material
		#mat.set_shader_parameter("speed:y", -0.02)
		$HUD/lowhealth_screen.visible = true
	return

#func hit(damage: int, hit_type: int, caller: CharacterBody3D, hit_pos: Vector3):
func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	if is_observer: return
	if is_dead: return
	
	for sound in taunt_sound_container.get_children():
		sound.stop()
	
	camshake(damage * 0.5, 0.25)
	if hit_type == U.hit_types.UNDEFINED:
		if armor > 0:
			armor -= int(float(damage) * .5)
			if armor < 1:
				armor = 0
				disable_kevlar()
		else:
			health -= damage
		
		if health > 0:
			if not is_wearing_kevlar:
				flinch_timer.start()
				is_flinching = true
				if not is_heavy_punching and not is_heavy_kicking and not is_carrying_actor and not is_diving:
					anim_h(anim_set["flinch"], true, .2)
			sound_hit.play()
			
			if health > low_health_threshold:
				hurt_screen(0.6, 0.25)
				if U.coin_flip():
					ouch_sounds[
						randi_range(0, len(ouch_sounds)-1)
					].play()
			elif health <= low_health_threshold:
				
				var altsound_chance: float = 0.2
				var altsound_chance_triggered: bool = randf_range(0.0, 0.99) < altsound_chance
				if altsound_chance_triggered:
					U.random_choice(low_health_ouch_sounds).play()
				else:
					U.random_choice(ouch_sounds).play()
		return
	return

func choke_hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	if is_observer: return
	if is_dead: return
	
	if not is_being_choked:
		is_being_choked = true
		var choke_pos: Vector3 = hit_pos
		var y_offset: float = 2.0
		choke_pos.y -= y_offset
		self.global_position = choke_pos
		#self.global_position -= (self.global_position - head_anchor.global_position)
		A.face_position(self, choke_actor.global_position)
		anim_h("choked_gun", false, true)
		$cam_base/choke_cam.make_current()
	for sound in taunt_sound_container.get_children():
		sound.stop()
	
	camshake(damage * 0.5, 0.25)
	if hit_type == U.hit_types.UNDEFINED:
		health -= damage
		if health < 0:
			is_being_choked = false
			choke_actor = null
		if health > 0:
			sound_hit.play()
			
			hurt_screen(0.6, 0.25)
			# Play ouch sound
			if (U.coin_flip() and U.coin_flip() and U.coin_flip()):
				$Sound/special/oh_hh.play()
		return
	return

func choke_release():
	main_cam.make_current()
	unequip_derringer()
	choke_focus(false)
	var health_refill_level: int = health + 12
	get_tree().create_tween().tween_property(self, "health", health_refill_level, 2.2)
	anim_h("flinch", false, true)
	is_being_choked = false
	return

func choke_mouse_control(event: InputEvent):
	if event is InputEventMouseMotion:
		choke_carrot.position.y -= (event.relative.y * mouse_sensitivity)
		choke_carrot.position.x += (event.relative.x * mouse_sensitivity)
	return

func choke_focus(focus_state: bool):
	#var ik_nodes: Array[SkeletonIK3D]
	rhand_ik.target_node = choke_carrot.get_path()
	#for ik_node in ik_nodes:
	#	if focus_state and not ik_node.is_running():
	#		ik_node.start()
	if focus_state:
		rhand_ik.start()
	
	if not focus_state:
		rhand_ik.stop()
	return

func choke_control():
	var left_held: Node3D = slot_manager.get_held_weapon(U.hands.LEFT)
	var right_held: Node3D = slot_manager.get_held_weapon(U.hands.RIGHT)
	if left_held:
		toggle_hand_item(U.hands.LEFT)
	if not right_held:
		equip_derringer()
	if not rhand_ik.is_running():
		choke_focus(true)
	
	choke_carrot.position.x += randf_range(-0.02, 0.03)
	choke_carrot.position.y += randf_range(-0.035, 0.01)
	
	if is_derringer_equipped and Input.is_action_just_pressed("primary_action") and not is_derringer_shooting:
		if derringer_ammo > 0:
			derringer.shoot()
			is_derringer_shooting = true
			derringer_ammo -= 1
			await get_tree().create_timer(.1).timeout
			is_derringer_shooting = false
		else:
			derringer.shoot_empty()
	if not is_derringer_equipped and Input.is_action_just_pressed("primary_action"):
		primary_action_control()
		await get_tree().create_timer(.1).timeout
		slot_manager.weapon_cease(U.hands.RIGHT)
	
	return

func just_walljumped():
	is_wall_jumping = true
	anim_h("wallclimb", false, true)
	var walljump_time: float = 1.0
	get_tree().create_tween().tween_callback(func():
		is_wall_jumping = false
		if is_jumping:
			anim_h(anim_set["jump"], false, true)
	).set_delay(walljump_time)
	return

func _hit_taker_died(hit_taker: CharacterBody3D):
	if hit_taker not in actors_killed:
		actors_killed.append(hit_taker)
		prints(self.name, "slayed", hit_taker.name)
		var taunt_chance: float = 0.10
		#var taunt_chance_triggered: bool = randf_range(0.0, 0.99) < taunt_chance
		var taunt_chance_triggered: bool = false
		if taunt_chance_triggered:
			await get_tree().create_timer(0.35).timeout
			U.random_choice(taunt_sound_container.get_children()).play()
	return

func _back_kick_landed(hit_taker: CharacterBody3D):
	camshake(3.0, .2)
	return

func _punch_landed(hit_taker: CharacterBody3D):
	camshake(.45, .2)
	return

func _kick_landed(hit_taker: CharacterBody3D):
	camshake(.45, .2)
	return

func _minion_follow_start(caller: CharacterBody3D):
	U.random_choice([
		$Sound/comms/follow_1,
		$Sound/comms/follow_2,
		$Sound/comms/follow_3,
		$Sound/comms/follow_4
	]).play()
	return

func _minion_unfollow_start(caller: CharacterBody3D):
	U.random_choice([
		$Sound/comms/wait_here_1,
		$Sound/comms/wait_here_2
	]).play()
	return


func _on_tight_cam_timer_timeout():
	if exit_mode: return
	if is_being_choked: return
	
	if is_dead:
		death_cam.make_current()
		return
	if torso_cam.current:
		return
	if left_shoulder_feeler.get_collider() and right_shoulder_feeler.get_collider():
		tight_cam_timer.start()
		return
	main_cam.make_current()
	return


func _on_step_timer_timeout():
	return


func _on_interact_timer_timeout():
	return


func _hand_state_changed(hand_state: int):
	# lol this is not good, these two enums need to be merged
	match hand_state:
		U.hand_states.EMPTY:
			slot_manager.equip_unarmed()
			set_armed_type(U.armed_types.UNARMED)
			hud.selector_label.text = ""
		U.hand_states.SINGLE_LEFT:
			set_armed_type(U.armed_types.ARMEDLEFT)
			hud.selector_label.text = ""
		U.hand_states.SINGLE_RIGHT:
			set_armed_type(U.armed_types.ARMED)
			hud.selector_label.text = ""
		U.hand_states.AKIMBO:
			set_armed_type(U.armed_types.AKIMBO)
			akimbo_type_changed.emit(akimbo_type)
	return


func _on_flinch_timer_timeout():
	is_flinching = false
	return



func _on_micro_ticker_timeout():
	tight_cam_control()
	ground_clip_control()
	return


func _on_sound_cooloff_timeout():
	return


func trigger_exit_mode():
	hud.visible = false
	exit_mode = true
	return

func restart_level():
	#Blackboard.user_scene_root.restart_level() 
	var game_tree: Node = get_tree().get_first_node_in_group("game_tree")
	game_tree.restart_level()
	return

func pump_shotgun():
	#focus_toggle(false) RR
	
	is_pumping_shotgun = true
	var prev_speed_scale: float = noko_anim.speed_scale
	noko_anim.speed_scale = .2
	
	var pump_anim: String
	if armed_type == U.armed_types.AKIMBO:
		pump_anim = "armedlong_akimbopump_1"
	elif armed_type == U.armed_types.ARMED and not is_crouching:
		pump_anim = "armedlong_pump_1"
	elif armed_type == U.armed_types.ARMEDLEFT and not is_crouching:
		pump_anim = "armedlongLEFT_pump_3"
	elif armed_type == U.armed_types.ARMED and is_crouching:
		pump_anim = "crouch_armedpump"
	elif armed_type == U.armed_types.ARMEDLEFT and is_crouching:
		pump_anim = "crouch_armedpumpLEFT"
	
	anim_h(pump_anim, false, true)
	await get_tree().create_timer(.2).timeout
	noko_anim.speed_scale = prev_speed_scale
	is_pumping_shotgun = false
	return

func release_player_interface():
	is_input_allowed = true
	is_mouselook_locked = false
	player_interface.release(self)
	anim_h("unarmed_idle", false, true)
	main_cam.make_current()
	await get_tree().create_timer(.5).timeout
	#queued_anims.clear()
	#last_anim = "<release>"
	#anim_h("t_pose", false, true)
	return
#

func add_doorkey(keyname: String):
	door_keys.append(keyname)
	hud.update_key(keyname)
	hud.set_doom_message("You picked up " + keyname)
	return

func apply_body_kickback(origin: Vector3, kickback_force: float):
	var kickback_direction: Vector3 = (self.global_position - origin).normalized() * kickback_force
	self.velocity += kickback_direction
	#if cam_base.rotation_degrees.x < -30:
		#self.velocity.y += knockback_force
	#else:
		#A.apply_move(self, Vector2.DOWN, knockback_force)
	return

func equip_derringer():
	derringer.visible = true
	is_derringer_equipped = true
	return

func unequip_derringer():
	derringer.visible = false
	is_derringer_equipped = false
	return

func add_kevlar(amount: int):
	armor += amount
	if not is_wearing_kevlar:
		enable_kevlar()
	hud.set_doom_message("You picked up Kevlar")
	return

func enable_kevlar():
	if not accessories:
		load_accessories()
	
	is_wearing_kevlar = true
	#for mesh in accessories_armature.get_children():
	#	mesh.visible = true
	for mesh in accessories_armature.find_children("kevlar_vest*"):
		mesh.visible = true
	
	$graphics/noko/Armature/Skeleton3D/gb_top.visible = false
	accessories_armature.get_node("gb_top_tucked").visible = true
	
	return

func disable_kevlar():
	if not accessories:
		load_accessories()
	
	is_wearing_kevlar = false
	#for mesh in accessories_armature.get_children():
		#mesh.visible = false
	for mesh in accessories_armature.find_children("kevlar_vest*"):
		mesh.visible = false
	
	accessories_armature.get_node("gb_top_tucked").visible = false
	$graphics/noko/Armature/Skeleton3D/gb_top.visible = true
	return

func load_accessories():
	accessories = load("res://Staging/Models/noko_accessories.glb").instantiate()
	$graphics.add_child(accessories)
	accessories.position.y = -3.789
	accessories.rotation_degrees.y = -180
	accessories_armature = accessories.get_node("Armature").get_node("Skeleton3D")
	for mesh in accessories_armature.get_children():
		mesh.skeleton = $graphics/noko/Armature/Skeleton3D.get_path()
	return

func armed_melee_attack():
	#is_punching = true
	is_reloading = true # Lazy hack, could cause problems
	var attack_anim: String = ""
	if armed_type == U.armed_types.AKIMBO:
		attack_anim = "armed_melee_1"
	elif armed_type == U.armed_types.ARMED:
		var weapon: Node3D = slot_manager.get_held_weapon(U.hands.RIGHT)
		if weapon.size == U.weapon_sizes.LONG:
			attack_anim = "armedlong_melee_1"
		elif weapon.size == U.weapon_sizes.SHORT:
			attack_anim = "armedshort_melee_1"
		else:
			attack_anim = "armed_melee_1"
	elif armed_type == U.armed_types.ARMEDLEFT:
		attack_anim = "armed_melee_1"
	anim_h(attack_anim, false, true)
	
	await get_tree().create_timer(.2).timeout
####
#func custom_heavy_punch_hit():
	var melee_damage: int = 25 # 65 # I like 65 but it's probably best for BERSERK mode
	var knockback_speed: float = 9.0
	var hit_takers: Array = get_hand_prox_hit_takers()
	if hit_takers:
		$Sound/armed_melee_hit_sound.play()
		camshake(1.0, .2)
	
	var is_actor_in_hit_takers: bool = false
	for hit_taker in hit_takers:
		if hit_taker.is_in_group("actors"):
			is_actor_in_hit_takers = true
			break
	
	for hit_taker in hit_takers:
		if is_actor_in_hit_takers and not hit_taker.is_in_group("actors"):
			continue # avoid unexpected barrel death
		hit_taker.hit(melee_damage, U.hit_types.UNDEFINED, self, rhand_anchor.global_position)
		if is_instance_of(hit_taker, CharacterBody3D):
			A.apply_move(hit_taker, Vector2.DOWN, knockback_speed)
		
		if is_instance_of(hit_taker, CharacterBody3D):
			hit_taker.move_and_slide()
	
	await get_tree().create_timer(anim.get_animation(anim.assigned_animation).length * .9).timeout
	is_reloading = false # Lazy hack, could cause problems
	#is_punching = false
	return
# RRR

func deactivate_cam_zoom():
	for cam in cam_data.keys():
		if not cam:
			break # hackfix? "previously freed"
		var cur_cam: Camera3D = cam
		get_tree().create_tween().tween_property(cur_cam, "fov", cam_data[cur_cam]["unzoomed_fov"], .5)
		#cam_data[cur_cam].erase("unzoomed_fov")
	return

func stunt_dive():
	if is_diving: return
	if is_focusing:
		focus_toggle(false)
	
	var is_footbox_previously_disabled: bool = $hitbox_feet.disabled
	if not is_footbox_previously_disabled:
		$hitbox_feet.disabled = true
	
	is_diving = true
	is_slippery = true
	hitbox_lower_anim.play("half")
	anim_h("dive_akimbo_N", false, true)
	
	velocity.y += dive_lift
	#A.apply_move(self, Vector2.UP, dive_thrust)
	await get_tree().create_timer(0.8).timeout
	anim_h("dive_akimbo_N_getup", false, true)
	await get_tree().create_timer(.2).timeout
	
	var crouch_offset_y: float = 3
	self.global_position.y += crouch_offset_y
	
	if not is_footbox_previously_disabled:
		$hitbox_feet.disabled = false
	hitbox_lower_anim.play("full")
	is_diving = false
	is_slippery = false
	return
