extends StaticBody3D

@export var health: int = 50
var heavy_jacket_health: int = health + 20
@export var spawn_weapon: String = "beretta_nine"
@export var force_phys_death: bool = false
#@export var is_smoking: bool = false
var active_weapon: Node3D
@onready var model: Node3D = $model
@onready var anim: AnimationPlayer = $model/AnimationPlayer
var phys_anim: AnimationPlayer
@onready var eyes: Node3D = $mid_anchor/eyes
@onready var rhand_anchor: Node3D = $model/Armature/Skeleton3D/BoneAttachment3D/anchor
@onready var raycast: RayCast3D = $RayCast3D
const BASE_TARGET_DISTANCE_THRESHOLD: float = 45.0
var target_distance_threshold: float = BASE_TARGET_DISTANCE_THRESHOLD
var melee_distance_threshold: float = 7.0
var hearing_distance: float = 30.0
var engage_distance: float = 20.0
var passive_target: PhysicsBody3D
var active_target: PhysicsBody3D
var is_dead: bool = false
#@onready var gun: Node3D = $model/Armature/Skeleton3D/BoneAttachment3D/anchor/beretta_nine
@onready var attack_cooloff: Timer = $cooloff
@export var reaction_time: float = .3
var sounds_heard: Array
var latest_sound_position: Vector3
var last_hurt_position: Vector3

var phys_model: Node3D
var is_phys_dying: bool = false

var weapon_ammo: int = 0
const BASE_TRIGGER_PULL_TIME: float = 0.2
var trigger_pull_time: float = BASE_TRIGGER_PULL_TIME
var is_reloading: bool = false
var is_aiming: bool = false
var is_changing_position: bool = false
var is_ducking: bool = false
var alert_expire_tick: float = 0.0
var alert_expire_tick_reset: float = 20.0 #seconds
var is_ever_seen_target: bool = false

var anim_set: Dictionary = {
	"idle": "unarmed_idle",
	"shoot": "armed_idle",
}
var suppress_impact_calls: bool = false

func _ready():
	if spawn_weapon:
		active_weapon = Weapons.registry[spawn_weapon]["scene"].instantiate()
		rhand_anchor.add_child(
			active_weapon
		)
	
	if active_weapon.size == U.weapon_sizes.LONG:
		anim_set["shoot"] = "armedlong_idle"
	else:
		anim_set["shoot"] = U.random_choice([
			"armed_idle",
			"aim_pistol_1",
			"aim_pistol_2",
			"aim_pistol_3"
		])
	
	anim.play(anim_set["idle"])
	#gun.actor = self
	#gun.prop_weapon = true
	active_weapon.actor = self
	active_weapon.prop_weapon = true
	#weapon_ammo = Weapons.registry[active_weapon.hud_name]["mag_size"]
	weapon_ammo = randi_range(1, Weapons.registry[active_weapon.hud_name]["mag_size"])
	if active_weapon.fire_mode == U.fire_modes.FULL_AUTO:
		trigger_pull_time = .8
		set_fullauto_clothes()
		health = heavy_jacket_health
	else:
		$model/Armature/Skeleton3D/burglar_jacket_3.visible = false
		$model/Armature/Skeleton3D/burglar_facemask.visible = false
	
	if health < 1:
		hit(1, U.hit_types.UNDEFINED, self, self.global_position)
	
	# hack fix for the hacky way I do things!
	if $model.rotation_degrees.y == 0.0:
		$model.rotation_degrees.y = -180
	return

func _physics_process(delta):
	#if $debug_label.visible:
		##$debug_label.text = str(health) + " " + str(weapon_ammo)
		#$debug_label.text = str(active_target)

	
	if not is_dead:
		hearing_control()
		if alert_expire_tick > 0.0:
			alert_expire_tick -= delta
	return

func behavior_tick():
	if is_dead: return
	if is_aiming: return
	if is_changing_position: return
	
	var target_visible: bool = A.is_actor_viewable(self, raycast, active_target)
	
	if target_visible:
		is_ever_seen_target = true
		
		var chance_to_duck: bool = (U.coin_flip() and U.coin_flip() and U.coin_flip() and U.coin_flip())
		if chance_to_duck and not is_ducking and not is_changing_position:
			is_changing_position = true
			anim.play("move_to_duck")
			await anim.animation_finished
			is_ducking = true
			$CollisionShape3D.disabled = true
			$ducked_collision.disabled = false
			is_changing_position = false
	
	var chance_to_stand: bool = (U.coin_flip() and U.coin_flip() and U.coin_flip() and U.coin_flip())
	if chance_to_stand and is_ducking and not is_changing_position:
		is_changing_position = true
		anim.play_backwards("move_to_duck")
		await anim.animation_finished
		is_ducking = false
		$CollisionShape3D.disabled = false
		$ducked_collision.disabled = true
		is_changing_position = false
	
	if is_dead: # Since we awaited the duck animation
		return
	
	if latest_sound_position:
		A.face_position(self, latest_sound_position)
		latest_sound_position = Vector3.ZERO
	
	var target_candidates: Array = get_tree().get_nodes_in_group("players")
	if not target_candidates:
		return
	
	active_target = target_candidates[0]
	#func is_actor_viewable(source_actor: CharacterBody3D = null, source_raycast: RayCast3D = null, target_actor: CharacterBody3D = null, y_look_offset: float = 0.0):
	
	is_aiming = true
	
	#if target_visible:
	if active_weapon and active_weapon.fire_mode != U.fire_modes.FULL_AUTO and target_visible:
		A.face_position(self, active_target.global_position)
		get_tree().create_tween().tween_callback(
			func ():
				if is_dead:
					return
				if not A.is_actor_ahead_approx(self, active_target):
					self.global_rotation_degrees.y += U.random_choice([4.0, -4.0, 6.2, -6.2, 2.2, -2.2])
		).set_delay(1.5)
	
	var is_missed_shot: bool = false # U.coin_flip()
	await get_tree().create_timer(reaction_time + randf_range(0, .1)).timeout
	
	#if alert_expire_tick > 0.0 and A.is_actor_viewable(self, raycast, active_target) and not is_reloading:
	if alert_expire_tick > 0.0 and target_visible and not is_reloading:
		A.face_position(self, active_target.global_position)
		if is_missed_shot:
			self.global_rotation_degrees.y += U.random_choice([4.0, -4.0, 6.2, -6.2, 2.2, -2.2])
		
		#attack()
		if raycast.get_collider() == active_target:
			ghost_attack()
		else:
			attack()
	
	#if alert_expire_tick < 1.0 and A.is_actor_ahead_approx(self, active_target) and A.is_actor_viewable(self, raycast, active_target) and not is_reloading:
	elif alert_expire_tick < 1.0 and A.is_actor_ahead_approx(self, active_target) and target_visible and not is_reloading:
		alert_expire_tick = alert_expire_tick_reset
		A.face_position(self, active_target.global_position)
		if is_missed_shot:
			self.global_rotation_degrees.y += U.random_choice([4.0, -4.0, 6.2, -6.2, 2.2, -2.2])
		#attack()
		if raycast.get_collider() == active_target:
			ghost_attack()
		else:
			attack()
	
	elif is_ever_seen_target and alert_expire_tick > 0.0 and A.is_actor_ahead_approx(self, active_target) and not target_visible and not is_reloading:
		attack()
		await get_tree().create_timer(.1).timeout
		if is_dead:
			is_aiming = false
			return
		
		var is_carrying_fullauto: bool = (
			active_weapon and active_weapon.get("fire_mode") != U.fire_modes.FULL_AUTO
		)
		if A.is_actor_viewable(self, raycast, active_target) and not is_carrying_fullauto:
			A.face_position(self, active_target.global_position)
	
	
	is_aiming = false
	return

func attack(ghost_allowed: bool = true):
	if is_dead: return
	
	if not attack_cooloff.is_stopped():
		return
	
	
	
	if weapon_ammo < 1:
		weapon_reload()
		return
	
	if not is_ducking:
		anim.play(anim_set["shoot"])
	else:
		anim.play("duck_idle")
	
	attack_cooloff.start()
	#await get_tree().create_timer(reaction_time).timeout
	
	if is_dead:
		return
	if not active_weapon:
		return
	
	#if not is_ducking:
		#anim.play(anim_set["shoot"])
	#else:
		#anim.play("duck_idle")
	#gun.primary_action(self)
	#active_weapon.primary_action(self)
	
	######
	var y_difference: float = (active_target.global_position.y - self.global_position.y)
	var y_plane_threshold: float = 4.0
	if \
		ghost_allowed and \
		abs(y_difference) > y_plane_threshold and \
		A.is_actor_viewable(self, raycast, active_target) and \
		A.distance(self, active_target) < engage_distance:
			A.create_ghost_impact(self, active_target, active_weapon.damage, active_weapon.knockback_force) # I expect this will make two shots, the raycast shot and the ghost shot. Maybe it'll be okay?
		#func create_ghost_impact(source_actor: PhysicsBody3D, target_actor: PhysicsBody3D, damage: int, knockback_force: float = 30):
	########
	
	if active_weapon.has_method("trigger_down"):
		active_weapon.trigger_down(self)
	else:
		active_weapon.primary_action(self)
	weapon_ammo -= 1
	
	
	get_tree().create_tween().tween_callback(
		func():
			if is_dead or not active_weapon:
				return
			if active_weapon.has_method("trigger_up"):
				active_weapon.trigger_up()
			else:
				active_weapon.stop_action()
	).set_delay(trigger_pull_time)
	
	
	#attack_cooloff.wait_time = randf_range(.9, 1.6)
	attack_cooloff.wait_time = randf_range(.14, .88)
	#attack_cooloff.start()
	return

func ghost_attack():
	if is_dead: return
	
	if not attack_cooloff.is_stopped():
		return
	
	
	
	if weapon_ammo < 1:
		weapon_reload()
		return
	
	if not is_ducking:
		anim.play(anim_set["shoot"])
	else:
		anim.play("duck_idle")
	
	attack_cooloff.start()
	#await get_tree().create_timer(reaction_time).timeout
	
	if is_dead:
		return
	if not active_weapon:
		return
	
	#if not is_ducking:
		#anim.play(anim_set["shoot"])
	#else:
		#anim.play("duck_idle")
	#gun.primary_action(self)
	#active_weapon.primary_action(self)
	
	######
	var y_difference: float = (active_target.global_position.y - self.global_position.y)
	var y_plane_threshold: float = 4.0
	
	A.create_ghost_impact(self, active_target, active_weapon.damage, active_weapon.knockback_force) # I expect this will make two shots, the raycast shot and the ghost shot. Maybe it'll be okay?
		#func create_ghost_impact(source_actor: PhysicsBody3D, target_actor: PhysicsBody3D, damage: int, knockback_force: float = 30):
	########
	
	suppress_impact_calls = true
	if active_weapon.has_method("trigger_down"):
		active_weapon.trigger_down(self)
	else:
		active_weapon.primary_action(self)
	weapon_ammo -= 1
	
	
	get_tree().create_tween().tween_callback(
		func():
			if is_dead or not active_weapon:
				return
			if active_weapon.has_method("trigger_up"):
				active_weapon.trigger_up()
			else:
				active_weapon.stop_action()
	).set_delay(trigger_pull_time)
	
	
	#attack_cooloff.wait_time = randf_range(.9, 1.6)
	attack_cooloff.wait_time = randf_range(.14, .88)
	#attack_cooloff.start()
	suppress_impact_calls = false
	return


func hearing_control():
	sounds_heard = A.check_for_sounds(self, hearing_distance)
	if not sounds_heard:
		return
	latest_sound_position = sounds_heard.pop_back().global_position
	return

func drop_weapon():
	#var spawn_weapon: String = "beretta_nine" #Temp?
	var world_item: RigidBody3D = Weapons.by_name(spawn_weapon)["world_item"].instantiate()
	Blackboard.current_world.add_child(world_item)
	world_item.global_position = rhand_anchor.global_position
	world_item.rotation_degrees.y = 180
	
	world_item.add_collision_exception_with(self)
	for p in get_tree().get_nodes_in_group("players"):
		world_item.add_collision_exception_with(p) # This shouldn't go here!
	
	world_item.linear_velocity = Vector3(0, 10, 0)
	world_item.angular_velocity = Vector3(0, 0, 5)
	
	for c in rhand_anchor.get_children():
		c.queue_free()
	
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	#if is_dead: return
	
	if caller and not is_dead:
		var caller_distance: float = self.global_position.distance_to(caller.global_position)
		if caller_distance > target_distance_threshold:
			target_distance_threshold = caller_distance
		active_target = caller
		#await get_tree().create_timer(0.5).timeout # Feels weird, reimplement better
		A.face_position(self, active_target.global_position)
	
	
	if is_dead:
		return
	
	health -= damage
	last_hurt_position = hit_pos if hit_pos else last_hurt_position
	
	if health < 1 and not is_phys_dying:
		kill_actor()
	else:
		var flinch_anim: String = U.random_choice([
			"flinch",
			"flinch_2",
			"flinch_3",
			"flinch_4"
		])
		anim.play(flinch_anim)
		if U.coin_flip():
			U.random_choice(
				$Sounds.find_children("hurt_*")
			).play()
	return

func kill_actor():
	if is_dead: return
	for p in get_tree().get_nodes_in_group("players"):
		add_collision_exception_with(p)
	if is_ducking:
		$CollisionShape3D.disabled = false
		$ducked_collision.disabled = true
		is_ducking = false
	var die_anim: String
	var is_dying_by_wall: bool = false
	#raycast.global_rotation_degrees.y -= 180
	#raycast.global_position.y -= 1.5
	#raycast.target_position.z = -3.0
	is_dead = true
	await get_tree().process_frame
	#var collider: PhysicsBody3D = raycast.get_collider()
	var collider: PhysicsBody3D = $back_wall_sensor.get_collider()
	if collider and is_instance_of(collider, StaticBody3D):
		is_dying_by_wall = true
	
	drop_weapon()
	await get_tree().process_frame
	var is_phys_death: bool = U.coin_flip()
	if is_phys_death or force_phys_death:
		$CollisionShape3D.disabled = true
		spawn_rigid_actor()
	
	if not is_phys_death:
		if is_dying_by_wall:
			var wall_pos: Vector3 = $back_wall_sensor.get_collision_point() #raycast.get_collision_point()
			var move_dist: Vector2 = Vector2(
				$model.global_position.x - wall_pos.x,
				$model.global_position.z - wall_pos.z
			)
			prints(self.name, move_dist.length())
			$model.global_position.x = wall_pos.x
			$model.global_position.z = wall_pos.z
			die_anim = "die_against_wall_1"
		else:
			#die_anim = "die_5" # "die_3"
			die_anim = U.random_choice([
				"die_1",
				"die_2",
				"die_3",
				"die_4",
				"die_5"
			])
		U.random_choice($Sounds.find_children("die_*")).play()
		
		anim.play(die_anim)
	#is_dead = true
	for brush in get_tree().get_nodes_in_group("breaktex_brushes"):
		if U.distance(self, brush) < 9:
			brush.activate(self)
			break
	$CollisionShape3D.disabled = true
	
	await get_tree().create_timer(.1).timeout
	prints(self.name, anim.assigned_animation)
	anim.play(die_anim) # hackfix, I think the shoot anim is pl
	return

func spawn_rigid_actor():
	var rigid_actor: RigidBody3D = RigidBody3D.new()
	self.get_parent().add_child(rigid_actor)
	rigid_actor.add_collision_exception_with(self)
	#for g in ["players", "player_minions"]:
		#for actor in get_tree().get_nodes_in_group(g):
			#rigid_actor.add_collision_exception_with(actor)
	rigid_actor.global_position = self.global_position
	rigid_actor.global_rotation = self.global_rotation
	rigid_actor.add_to_group("actors")
	# rigid_actor.add_to_group("hit_takers") # Melee problems
	rigid_actor.gravity_scale = 8.0
	for p in get_tree().get_nodes_in_group("players"):
		rigid_actor.add_collision_exception_with(p) # This shouldn't go here!
	
	var collider_copy: CollisionShape3D = $CollisionShape3D.duplicate()
	collider_copy.disabled = false
	rigid_actor.add_child(
		collider_copy
	)
#	collider_copy.disabled = false
	phys_model = model.duplicate()
	model.visible = false
	rigid_actor.add_child(phys_model)
	
	is_phys_dying = true
	
	phys_anim = phys_model.get_node("AnimationPlayer")
	phys_anim.speed_scale = .7
	var phys_die_start_anim: String = U.random_choice([
		"die_phys_1_start",
		"flinch",
		"flinch_2",
		"flinch_3",
		"flinch_4"
	])
	phys_anim.play(phys_die_start_anim)
	var random_x: float = randf_range(-60, 22)
	var random_y: float = U.random_choice([0, 15])
	var random_z: float = randf_range(-54, 88)
	var force_vector: Vector3 = Vector3(
			random_x,
			0,
			random_z
	)
	rigid_actor.linear_velocity = Vector3(random_x * .1, 15, 0)
	rigid_actor.add_constant_central_force(-force_vector)
	await get_tree().create_timer(.9).timeout
	
	rigid_actor.linear_velocity = Vector3(0, 5, 0)
	rigid_actor.add_constant_central_force(force_vector * 2)
	
	
	phys_anim.play("die_phys_1_end")
	#await get_tree().create_timer(4.5).timeout
	await get_tree().create_timer(1.5).timeout
	var died_standing_up: bool = absf(self.rotation_degrees.x) < 50 and absf(self.rotation_degrees.z) < 50
	if died_standing_up:
		rigid_actor.angular_velocity.x = 5.0
	await get_tree().create_timer(3.5).timeout
	is_phys_dying = false
	
	rigid_actor.process_mode = Node.PROCESS_MODE_DISABLED
	return

func weapon_reload():
	if not active_weapon: return
	if is_reloading: return
	is_reloading = true
	active_weapon.reload(self)
	var reload_anim: String
	if active_weapon.size == U.weapon_sizes.LONG:
		reload_anim = "long_breaktop_reload_1"
	else:
		reload_anim = "pistol_reload_1"
	anim.play(reload_anim)
	
	get_tree().create_tween().tween_callback(
		func ():
			if is_dead: return
			is_reloading = false
			weapon_ammo = randi_range(1, Weapons.registry[active_weapon.hud_name]["mag_size"])
	).set_delay(1.2)
	return

func _on_tick_timeout():
	behavior_tick()

func set_fullauto_clothes():
	$model/Armature/Skeleton3D/burglar_arms_1.visible = true
	$model/Armature/Skeleton3D/burglar_boots_1.visible = true
	$model/Armature/Skeleton3D/burglar_facemask.visible = true
	$model/Armature/Skeleton3D/burglar_jacket_1.visible = false
	$model/Armature/Skeleton3D/burglar_jacket_2.visible = false
	$model/Armature/Skeleton3D/burglar_jacket_3.visible = true
	$model/Armature/Skeleton3D/burglar_pants_1.visible = false
	$model/Armature/Skeleton3D/burglar_pants_2.visible = false
	$model/Armature/Skeleton3D/burglar_pants_3.visible = true
	$model/Armature/Skeleton3D/burglar_shirt_1.visible = false
	$model/Armature/Skeleton3D/burglar_shirt_2.visible = false
	$model/Armature/Skeleton3D/civ_body_male_torso_m.visible = false
	return
