extends Node

signal activated

@export var gd_group: String
@export var hit_trigger: bool = true
@export var notify_receiver: Node3D
@export var is_interactable: bool = true

func _ready():
	if gd_group:
		self.add_to_group(gd_group)
	if hit_trigger:
		self.add_to_group("hit_takers")
	if is_interactable:
		self.add_to_group("interactables")
	return

func _activated():
	activated.emit()
	if notify_receiver:
		notify_receiver.activate()
	return

func interact(_caller):
	_activated()
	return

func hit(damage: int, hit_type: int, caller: CharacterBody3D, hit_pos: Vector3):
	if not hit_trigger: return
	_activated()
	return
