extends CharacterBody3D


const JUMP_VELOCITY = 4.5
const BASE_MOVE_SPEED = 5.0
var move_speed: float = BASE_MOVE_SPEED
var run_scale = 1.2

@onready var eyes: Node3D = self.get_node("mid_anchor/eyes")
@onready var debug_label: Label3D = self.get_node("debug_label")
@onready var anim: AnimationPlayer = self.get_node("model/AnimationPlayer")
@onready var sight_raycast: RayCast3D =  self.get_node("sight_raycast")
@onready var strike_raycast: RayCast3D = self.get_node("strike_raycast")
@onready var nav_agent: NavigationAgent3D = self.get_node("NavigationAgent3D")

@export var health: int = 55
@export var spawn_weapon: String
@export var melee_damage: float = 16.0
@export var melee_recoil: float = -30.0
var is_dead: bool = false

var active_weapon_name: String
var active_weapon_node: Node3D
var active_weapon_ammo_left: int
var active_weapon_mag_size: int
var is_equipping: bool = false
var is_aiming: bool = false
var is_attacking: bool = false
var is_melee_attacking: bool = false
var is_flinching: bool = false

var anim_set: Dictionary = {
	"idle": "unarmed_idle",
	"run": "unarmed_run",
	"die": "die1"
}

var ouch_sounds: Array[AudioStreamPlayer3D] = []
var die_sounds: Array[AudioStreamPlayer3D] = []

var behavior_process_ticker: float = 0.0
const FAST_PROCESS_TICK: float = 0.049
const DEFAULT_PROCESS_TICK: float = 0.10
@export var behavior_process_interval: float = FAST_PROCESS_TICK

enum top_states {
	NONE,
	IDLE,
	ALERT,
	MOVING,
	GO_TO,
	ATTACK_SHOOT_INTENT,
	ATTACK_MELEE_INTENT,
	ATTACK_SHOOT,
	ATTACK_MELEE,
	SCRIPTED_EVENT,
	DEAD
}
@export var top_state: top_states = top_states.IDLE
var previous_top_state: int = top_states.IDLE

const BASE_TARGET_DISTANCE_THRESHOLD: float = 45.0
var target_distance_threshold: float = BASE_TARGET_DISTANCE_THRESHOLD
var melee_distance_threshold: float = 7.0
var passive_target: CharacterBody3D
var active_target: CharacterBody3D
var last_seen_target_position: Vector3
var strike_position: Vector3
var sound_position: Vector3
var target_pool: Array[CharacterBody3D] = []
var groups_i_dont_like: Array[String] = []

@export var follow_sounds: bool = false
var is_following_sound: bool = false
var sounds_heard: Array = []

var go_to_position: Vector3 = Vector3.ZERO
var last_go_to_position: Vector3 = Vector3.ZERO

# ---------------------------------------------

func _ready():
	return

func _physics_process(delta):
	debug_label.text = top_states.keys()[top_state] + " - " + str(health)
	if not is_on_floor():
		A.apply_gravity(self, delta)
	
	if not is_dead:
		tick_control(delta)
	
	move_and_slide()
	animation_control()
	return

func tick_control(delta):
	behavior_process_ticker += delta
	if behavior_process_ticker > behavior_process_interval:
		on_behavior_process_tick()
		behavior_process_ticker = 0.0
	return

func top_state_switch_to(new_state: int):
	previous_top_state = top_state
	top_state = new_state
	return

func animation_control():
	if is_dead:
		A.animate(self, anim_set["die"])
		return
	
	return

func behavior_control():
	match top_state:
		top_states.NONE:
			return
		top_states.IDLE:
			# Chill
			return
		top_states.ALERT:
			# Run away scared
			return
		top_states.MOVING:
			return
		top_states.GO_TO:
			return
		top_states.ATTACK_SHOOT_INTENT:
			return
		top_states.ATTACK_MELEE_INTENT:
			return
		top_states.ATTACK_SHOOT:
			return
		top_states.ATTACK_MELEE:
			return
		top_states.SCRIPTED_EVENT:
			# In clinic, wait until trigger (gunshot? Timer?)
			# then run out opening doors on the way
			return
		top_states.DEAD:
			return
	return

func move_nav(face_direction: bool = true, new_position: Vector3 = Vector3.ZERO):
	
	if new_position:
		nav_agent.target_position = new_position
	var next_position: Vector3 = nav_agent.get_next_path_position()
	if face_direction:
		A.face_position(self, next_position)
		A.apply_move(self, Vector2(0, -1), move_speed)
	elif not face_direction:
		self.velocity = (next_position - self.global_position).normalized() * move_speed
	return

func hit(damage: int, hit_type: int, caller: CharacterBody3D, hit_pos: Vector3):
	#if is_dead: return # If no dead flinch, uncomment
	
	
	health -= damage
	
	if caller and not is_dead:
		var caller_distance: float = self.global_position.distance_to(caller.global_position)
		if caller_distance > target_distance_threshold:
			target_distance_threshold = caller_distance
		active_target = caller
		A.face_position(self, active_target.global_position)
	
	if health < 1:
		kill_actor()
	return

func kill_actor():
	is_dead = true
	return

func on_behavior_process_tick():
	if is_dead and top_state == top_states.DEAD:
		return
	
	behavior_control()
	return
