extends CharacterBody3D

# TODO
# - Add a process ticker
# - Only move_and_slide when needed
# - Move around, get scared, bow to player, talk to player, etc.

var behavior_process_ticker: float = 0.0
const FAST_PROCESS_TICK: float = 0.049
const DEFAULT_PROCESS_TICK: float = 0.09
const ROPE_PROCESS_TICK: float = 0.049
var behavior_process_interval: float = DEFAULT_PROCESS_TICK # FAST_PROCESS_TICK

@export_enum("male", "female") var sex: String = "male"
@onready var anim: AnimationPlayer = $civilian_male/AnimationPlayer
@onready var model: Node3D = $civilian_male
@onready var eyes: Node3D = self.get_node("mid_anchor/eyes")
@onready var offer_ground_spawn: Marker3D = $Markers/offer_ground_spawn
@onready var handcuffs: Array = [
	$lhand_bone/anchor/handcuff,
	$rhand_bone/anchor/handcuff
]
@onready var rhand_bone: BoneAttachment3D = $rhand_bone
@onready var lhand_bone: BoneAttachment3D = $lhand_bone
@export var hostage: bool = false
@export var rescue_reward_item: PackedScene
var is_spawned_as_hostage: bool = false
var rescuer: Node3D

enum top_states {
	IDLE,
	RESCUE_REACT,
	NONE
}
var top_state: top_states = top_states.IDLE
var previous_top_state: top_states = top_state

var anim_set: Dictionary = {
	"idle": "unarmed_idle",
	"rescue_reaction": "bow_male_far",
	"rescue_reward": "gesture_offer_1",
	"run": "unarmed_run"
}

var health: int = 1
var is_dead: bool = false
var is_rescue_rewarding: bool = false
var is_rescue_reacting: bool = false
#var is_rescue_reaction_complete: bool = false


func _ready() -> void:
	if sex == "male":
		model = $civilian_male
		anim = $civilian_male/AnimationPlayer
		$civilian_female.visible = false
	elif sex == "female":
		model = $civilian_female
		anim = $civilian_female/AnimationPlayer
		$civilian_male.visible = false
		$Audio/trouble_finds_me.stream = null
	
	rhand_bone.set_external_skeleton(rhand_bone.get_path_to(model.get_node("Armature/Skeleton3D")))
	rhand_bone.bone_idx = 12
	lhand_bone.set_external_skeleton(lhand_bone.get_path_to(model.get_node("Armature/Skeleton3D")))
	lhand_bone.bone_idx = 8
	
	
	if hostage:
		is_spawned_as_hostage = true
	set_hostage(hostage)
	return

func _physics_process(delta: float) -> void:
	tick_control(delta)
	return

func tick_control(delta):
	behavior_process_ticker += delta
	
	if behavior_process_ticker > behavior_process_interval:
		on_behavior_process_tick()
		animation_control()
		behavior_process_ticker = 0.0
	return

func on_behavior_process_tick() -> void:
	if is_dead:
		return
	
	behavior_control()
	
	#if not self.velocity.is_zero_approx():
		#self.velocity = Vector3.ZERO
	#self.move_and_slide()
	return

func top_state_switch_to(new_state: int) -> void:
	previous_top_state = top_state
	top_state = new_state
	return

func animation_control() -> void:
	if is_rescue_rewarding:
		A.animate(self, anim_set["rescue_reward"])
		return
	
	if is_rescue_reacting:
		A.animate(self, anim_set["rescue_reaction"])
		return
	
	if self.hostage:
		A.animate(self, "hostage_tied_kneeling")
		return
	
	
	if A.is_moving(self):
		A.animate(self, anim_set["run"])
	else:
		A.animate(self, anim_set["idle"])
	return

func show_tied() -> void:
	# handcuffs visible
	for handcuff in handcuffs:
		handcuff.visible = true
	# anim hostage
	#anim.play("hostage_tied_kneeling")
	return

func show_untied() -> void:
	# handcuffs invisible
	for handcuff in handcuffs:
		handcuff.visible = false
	# anim unarmed_idle
	#anim.play("unarmed_idle")
	return

func interact(caller):
	#if caller.is_in_group("players"):
		#caller.ammo_from_item(ammo_type, ammo_count)
	if self.hostage:
		$Audio/trouble_finds_me.play()
		caller.free_hostage(self)
		set_hostage(false)
		self.rescuer = caller
		top_state_switch_to(top_states.RESCUE_REACT)
	return


func behavior_control() -> void:
	# If just freed as hostage
	# - thank rescuer (bow or whatever)
	# - Maybe give the rescuer something (ammo, health, armor, a powerup? credits? a hint? Cigarettes?)
	# - move somewhere (?)
	#	-- Follow the rescuer
	#	-- Run away to a safe place (predefined or algorithmic)
	#	-- Do something (like go look through files in a file cabinet, smoke a cig, idk)
	match top_state:
		top_states.IDLE:
			if rescuer:
				A.face_position(self, rescuer.global_position)
			return
		top_states.RESCUE_REACT:
			if is_rescue_reacting:
				return
			is_rescue_reacting = true
			A.face_position(self, rescuer.global_position)
			await get_tree().create_timer(anim.get_animation(anim_set["rescue_reaction"]).length).timeout
			
			if rescue_reward_item:
				is_rescue_rewarding = true
				await get_tree().create_timer(anim.get_animation(anim_set["rescue_reward"]).length).timeout
				spawn_rescue_reward()
				
			top_state_switch_to(previous_top_state)
			is_rescue_reacting = false
			is_rescue_rewarding = false
			return
	return

func set_hostage(toggle: bool = true) -> void:
	if toggle == true:
		self.show_tied()
		self.hostage = true
		self.add_to_group("interactables")
		return
	elif toggle == false:
		self.show_untied()
		self.hostage = false
		self.remove_from_group("interactables")
		return
	return

func spawn_rescue_reward() -> void:
	var reward: Node3D = rescue_reward_item.instantiate()
	Blackboard.current_world.add_child(reward)
	reward.global_position = offer_ground_spawn.global_position + Vector3(0, 2.5, 0)
	return
