extends CharacterBody3D

@onready var anim: AnimationPlayer = $clerk_jenny/AnimationPlayer
@onready var eyes: Node3D = $mid_anchor/eyes
@export var jacket: bool = true
@export var attention_target: PhysicsBody3D
@export var attention_range: float = 13.0
var accumulated_tick: float = 0.0
var tick_interval: float = .05

var is_checking_register: bool = false
var is_adding_to_counter: bool = false
var is_alert: bool = false

##########
# Speak
var audio_seek_place: float = 0.0
var queued_speak_node: AudioStreamPlayer3D
var active_speak_node: AudioStreamPlayer3D
var speak_sequence_name: String = ""
var speak_sequence_index: int = 0
##########

func _ready() -> void:
	if not attention_target:
		attention_target = get_tree().get_first_node_in_group("players")
	if not jacket:
		$clerk_jenny/Armature/Skeleton3D/jenny_jacket.visible = false
	return

func _physics_process(delta: float) -> void:
	accumulated_tick += delta
	if accumulated_tick >= tick_interval:
		tick_control()
		accumulated_tick = 0.0
	return

func tick_control() -> void:
	behavior_control()
	animation_control()
	return

func animation_control() -> void:
	if is_checking_register:
		A.animate(self, "jenny_register_check_2")
		return
	if is_adding_to_counter:
		A.animate(self, "jenny_add_counter_item_1")
		return
	if is_alert:
		A.animate(self, "jenny_idle_2")
		return
	A.animate(self, "jenny_idle_1")
	return

func behavior_control() -> void:
	if is_adding_to_counter or is_checking_register:
		return
	
	if attention_target and A.distance(self, attention_target) < attention_range:
		A.face_position(self, attention_target.global_position)
	return

func greet(actor: PhysicsBody3D) -> void:
	var speech_audio: AudioStreamPlayer3D = $Audio/entry.get_children().pick_random()
	speak(speech_audio)
	return

func greet_again(actor: PhysicsBody3D) -> void:
	var speech_audio: AudioStreamPlayer3D = $Audio/repeated_entry.get_children().pick_random()
	speak(speech_audio)
	return

func farewell(actor: PhysicsBody3D) -> void:
	var speech_audio: AudioStreamPlayer3D = $Audio/exit.get_children().pick_random()
	speak(speech_audio)
	return

func stop_speak() -> void:
	$Audio/sequence.find_children("*", "AudioStreamPlayer3D").map(func(a): a.stop())
	return

func speak(audio_node: AudioStreamPlayer3D) -> void:
	stop_speak()
	audio_node.play()
	return


func sequence_speak_trigger(sequence_name: String = "", sequence_index: int = 0) -> void:
	speak_sequence_name = sequence_name
	speak_sequence_index = sequence_index
	var speak_node_query: String = Director.speaking_sequences[sequence_name][sequence_index]["node_query"]
	audio_seek_place = 0.0
	active_speak_node = $Audio/sequence.find_child(speak_node_query)
	
	## Consider moving the actual audio playing out of this function.
	## Vela has it in a little state machine
	speak(active_speak_node)
	await active_speak_node.finished
	await get_tree().create_timer(.2).timeout
	Director.speak_sequence_ended(speak_sequence_name, speak_sequence_index)
	active_speak_node = null
	return
