extends CharacterBody3D

@export var is_caretaker: bool = false
@export var ward: PhysicsBody3D
var caretaker: PhysicsBody3D

@onready var anim: AnimationPlayer = $model/AnimationPlayer
@onready var model: Node3D = $model
@onready var nav_agent: NavigationAgent3D = $NavigationAgent3D
@onready var eyes: Node3D = $mid_anchor/eyes
@onready var head_marker: Marker3D = $head_bone/head_marker
@onready var colshape_standing: CollisionShape3D = $colshape_standing
@onready var colshape_crouching: CollisionShape3D = $colshape_crouching
@onready var rhand_anchor: Node3D = $rhand_bone/anchor
@onready var sight_raycast: RayCast3D = $sight_raycast
@onready var strike_raycast: RayCast3D = $strike_raycast
@onready var audio_nodes: Array = $Audio.get_children()
@export var spawn_weapon: String = "imi_uzi"
@export var spawn_weapon_left: String = ""
@export_enum("yes", "no", "maybe") var equip_on_spawn: String = "maybe"
@export var never_move_nav: bool = false
@export var health: int = 120 # 60
var spawn_health: int = health

var anim_set: Dictionary = {
	"run": "unarmed_run",
	"idle": "unarmed_idle",
	"aim_focus": "aim_focus_bigpistol",
	"aim_shoot": "aim_shoot_bigpistol",
	"die": "clown_die_1"
}
var flinch_anim: String = ""
var flinch_time: float = .60

var behavior_process_ticker: float = 0.0
const FAST_PROCESS_TICK: float = 0.049
const DEFAULT_PROCESS_TICK: float = 0.09
var behavior_process_interval: float = DEFAULT_PROCESS_TICK # FAST_PROCESS_TICK

const BASE_TARGET_DISTANCE_THRESHOLD: float = 45.0
var target_distance_threshold: float = BASE_TARGET_DISTANCE_THRESHOLD
var engage_distance: float = 15.0
var melee_distance_threshold: float = 7.0
var headshot_sqdist: float = 0.9

const BASE_MOVE_SPEED: float = 25.0 # 14.0
var move_speed: float = BASE_MOVE_SPEED
var run_scale: float = 1.35
var max_velo: float = BASE_MOVE_SPEED * run_scale

var global_spawn_position: Vector3

var passive_target: CharacterBody3D
@export var active_target: PhysicsBody3D
var random_remembered_target_position: Vector3
var active_target_first_health: int = 100
var last_seen_target_position: Vector3
var last_live_delta: float = 0.0
var strike_position: Vector3
var sound_position: Vector3
var move_destination: Vector3 = Vector3.ZERO
#var target_board: Dictionary = {}
@export var groups_i_dont_like: Array[String] = [
	"players",
	"player_minions",
	"cultists",
	"h_grunts"
]

enum top_states {
	NONE,
	IDLE,
	ALERT,
	CONTACT,
	ATTACK_SHOOT_INTENT,
	ATTACK_MELEE_INTENT,
	ATTACK_SHOOT,
	ATTACK_MELEE,
	HUNT,
	MOVE,
	DEAD
}
var top_state: int = top_states.IDLE
var previous_top_state: int = top_states.IDLE

var active_weapon_node: Node3D
var active_weapon_name: String
var active_weapon_ammo_left: int = 0
var active_weapon_mag_size: int = 0
var equip_delay_time: float = .8 # .2
var attack_intent_time: float = 0.7 # 1.30 # 2.5
@export var attack_time: float = 1.0

var sounds_heard: Array = []
var latest_sound_position: Vector3
var hearing_distance: float = BASE_TARGET_DISTANCE_THRESHOLD * 2.0

var is_dead: bool = false
var is_dying: bool = false
var is_flinching: bool = false
var is_recently_hit: bool = false
var is_equipping: bool = false
var is_aiming: bool = false
var is_shooting: bool = false
var is_shootrunning: bool = false
var is_sprinting: bool = false
@export var is_shootwalker: bool = true
@export var is_accuracy_boost: bool = false
var is_first_contact: bool = true
var is_alert_expired: bool = false

var shootwalk_dir: Vector2 = Vector2.ZERO

var seethrough_groups: Array = ["glass_cells", "debris_breakables"]

### SENSOR
var accumulated_alert_time: float = 0.0
var threshold_alert_time_expiry: float = 8.0 # 15.0

###

func _ready() -> void:
	#if spawn_weapon and not active_weapon_node:
		#equip_weapon(spawn_weapon)
	
	global_spawn_position = self.global_position
	spawn_health = health
	
	
	if equip_on_spawn == "maybe":
		equip_on_spawn = ["yes", "no"].pick_random()
	for seethrough_group in seethrough_groups:
		for group_node in get_tree().get_nodes_in_group(seethrough_group):
			sight_raycast.add_exception(group_node)
	return

func _physics_process(delta: float) -> void:
	if $debug_label.visible:
		$debug_label.text = get_top_state_name()
		if active_target:
			$debug_label.text += "\n" + active_target.name
	
	if is_dead:
		animation_control()
		return
	
	if not is_dead:
		tick_control(delta)
		time_tracker(delta)
	
	if not self.is_on_floor():
		A.apply_gravity(self, delta)
		#if self.velocity.is_zero_approx():
	
	return

func tick_control(delta):
	behavior_process_ticker += delta
	
	if behavior_process_ticker > behavior_process_interval:
		on_behavior_process_tick()
		animation_control()
		sound_control()
		hearing_control()
		behavior_process_ticker = 0.0
	return

func on_behavior_process_tick() -> void:
	if is_dead:
		return
	
	behavior_control()
	self.velocity = self.velocity.clamp(
		-Vector3.INF,
		Vector3(max_velo, 100.00, max_velo)
	)
	self.move_and_slide()
	return

func animation_control() -> void:
	if is_dead:
		A.animate(self, anim_set["die"])
		return
	
	if is_shootrunning:
		if shootwalk_dir.x == -1:
			A.animate(self, "clowngrunt_armedshort_shoot_run_W_1") #left
		if shootwalk_dir.x == 1:
			A.animate(self, "clowngrunt_armedshort_shoot_run_E_1") #right
		if shootwalk_dir == Vector2.UP:
			A.animate(self, "clowngrunt_armedshort_shoot_run_N_1")
		if shootwalk_dir == Vector2.DOWN:
			A.animate(self, "clowngrunt_armedshort_shoot_run_S_1")
		return
	
	if is_shooting:
		A.animate(self, anim_set["aim_shoot"])
		return
	
	if is_aiming:
		A.animate(self, anim_set["aim_focus"])
		return
	
	if is_equipping:
		if not anim_set.has("equip"):
			return
		A.animate(self, anim_set["equip"])
		return
	
	if A.is_moving(self):
		if move_speed > (BASE_MOVE_SPEED * 1.15):
			A.animate(self, anim_set["run"])
		else:
			A.animate(self, "clowngrunt_armedshort_sprint_1")
		return
	else:
		A.animate(self, anim_set["idle"])
		return
	return

func hearing_control():
	sounds_heard = A.check_for_sounds(self, hearing_distance)
	if not sounds_heard:
		return
	latest_sound_position = sounds_heard.pop_back().global_position
	return

func behavior_control() -> void:
	match top_state:
		top_states.NONE:
			return
		top_states.IDLE:
			# Check if active target, chill if not
			if equip_on_spawn == "yes" and spawn_weapon and not active_weapon_node:
				if is_equipping:
					return
				equip_weapon(spawn_weapon)
				return
			
			if sounds_heard and U.coin_flip():
				A.face_position(self, latest_sound_position)
			
			update_active_targets()
			if active_target:
				top_state_switch_to(top_states.ALERT)
			return
		
		top_states.ALERT:
			if is_alert_expired:
				if not active_target.is_dead: # and U.coin_flip():
					is_alert_expired = false
					accumulated_alert_time = 0.0
					move_speed = move_speed * run_scale
					if U.coin_flip():
						top_state_switch_to(top_states.HUNT)
					else:
						top_state_switch_to(top_states.MOVE)
					return
				
				passive_target = active_target
				active_target = null
				is_alert_expired = false
				top_state_switch_to(top_states.IDLE)
				return
			
			if not active_target:
				prints(self.name, "entered ALERT with no active target.")
				top_state_switch_to(top_states.IDLE)
				return
			
			# If target isn't the player, move_nav to them
			
			#if active_target and is_first_contact and active_target.is_in_group("players"):
				#audio_switchplay($Audio.find_children("greet_*").pick_random())
				#is_first_contact = false
			# Is target attackable?
			
			if health < spawn_health and U.coin_flip():
				#is_sprinting = true
				move_speed = move_speed * run_scale
			
			if health < int(float(spawn_health) * .70) and (U.coin_flip() and U.coin_flip()):
				top_state_switch_to(top_states.MOVE)
				return
			
			var is_target_attackable: bool = A.is_actor_ahead_approx(self, active_target) and A.is_actor_viewable(self, sight_raycast, active_target)
			#if active_target and A.is_actor_ahead_approx(self, active_target) and A.is_actor_viewable(self, sight_raycast, active_target):
			if is_target_attackable:
				last_seen_target_position = active_target.global_position
			
			if is_first_contact and is_target_attackable:
				is_first_contact = false
				
				if active_target.is_in_group("players") and U.coin_flip() and U.coin_flip() and U.coin_flip():
					audio_switchplay($Audio.find_children("greet_*").pick_random())
			
			if not active_target.is_in_group("players") and not is_target_attackable and is_first_contact and not never_move_nav:
				if self.global_position.distance_squared_to(last_seen_target_position) > engage_distance:
					A.move_nav(self, true, last_seen_target_position)
					return
			
			if active_target and is_target_attackable:
				accumulated_alert_time = 0.0
				top_state_switch_to(top_states.CONTACT)
				A.face_position(self, active_target.global_position)
				return
			elif not is_alert_expired:
				if U.coin_flip() and U.coin_flip() and U.coin_flip() and U.coin_flip() and U.coin_flip():
					self.rotation_degrees.y += [randf_range(-45.0, 45.0), randf_range(-135.0, 135.0)].pick_random()
			
			if not is_target_attackable and U.coin_flip() and U.coin_flip() and U.coin_flip():
				move_speed = move_speed * run_scale
				top_state_switch_to(top_states.HUNT)
				return
			return
		top_states.CONTACT:
			# Can we attack?
			if is_equipping:
				return
			
			if spawn_weapon and not active_weapon_node:
				# TEMP \/
				#is_equipping = true
				#await get_tree().create_timer(1.57).timeout
				#is_equipping = false
				# TEMP /\
				equip_weapon(spawn_weapon)
				alert_nearby_freelings()
				return
			
			# How should we attack?
			## Assume shoot until I feel like implementing something else
			top_state_switch_to(top_states.ATTACK_SHOOT_INTENT)
			return
		top_states.ATTACK_SHOOT_INTENT:
			if is_aiming:
				if health < spawn_health: # and U.coin_flip():
					A.apply_move(self, shootwalk_dir, move_speed)
				
				if A.is_actor_viewable(self, sight_raycast, active_target):
					if U.coin_flip() or not last_seen_target_position:
						last_seen_target_position = active_target.global_position
					A.face_position(self, last_seen_target_position)
				return
			
			# TEMP \/
			#await get_tree().create_timer(2.03).timeout
			# TEMP /\
			
			
			is_aiming = true
			await get_tree().create_timer(attack_intent_time).timeout
			
			A.gradual_velo_stop(self)
			top_state_switch_to(top_states.ATTACK_SHOOT)
			is_aiming = false
			return

		top_states.ATTACK_SHOOT:
			if is_shooting:
				friendlyfire_check()
				
				if is_recently_hit and not is_shootrunning:
					is_shootrunning = true
				
				if not is_recently_hit and not is_shootrunning and health < spawn_health:
					is_shootrunning = true
					if shootwalk_dir.x != -1:
						shootwalk_dir.x = -1
				
				if is_shootrunning:
					A.apply_move(self, shootwalk_dir, move_speed * run_scale)
				
				var prev_y_rot: float = self.rotation_degrees.y
				A.face_position(self, active_target.global_position)
				var new_y_rot: float = self.rotation_degrees.y
				#self.rotation_degrees.y = lerpf(prev_y_rot, new_y_rot, .54)
				
				if active_target.is_in_group("players"):
					if active_target.is_diving or active_target.is_kick_sliding:
						self.rotation_degrees.y = lerpf(prev_y_rot, new_y_rot, .34)
				else:
					#self.rotation_degrees.y = lerpf(prev_y_rot, new_y_rot, .54)
					pass
				
				if A.is_moving(active_target) and U.coin_flip():
					self.rotation_degrees.y += randf_range(-15.0, 15.0)
				return
			
			is_shooting = true
			#if A.is_moving(self):
				#A.gradual_velo_stop(self)
			
			if active_weapon_node.fire_mode == U.fire_modes.FULL_AUTO:
				fire_weapon(attack_time)
			else:
				fire_weapon()
			
			if is_shootwalker:
				shootwalk_dir = Vector2(
					[-1, 1, 0].pick_random(),
					[-1, 1, 0].pick_random()
				)
				
				get_tree().create_tween().tween_callback(
					func ():
						if not self or self.is_dead:
							return
						is_shootrunning = true
				).set_delay(randf_range(attack_time * .10, attack_time * .99))
			
			await get_tree().create_timer(attack_time).timeout
			top_state_switch_to(top_states.ALERT)
			is_shooting = false
			is_shootrunning = false
			#shootwalk_dir = Vector2.ZERO
			A.gradual_velo_stop(self, Vector3.ZERO, 1.2) # Might have to change/fix this later
			return
		top_states.ATTACK_MELEE_INTENT:
			return
		top_states.ATTACK_MELEE:
			return
		top_states.HUNT:
			var is_target_attackable: bool = A.is_actor_ahead_approx(self, active_target) and A.is_actor_viewable(self, sight_raycast, active_target)
			if is_target_attackable:
				move_speed = BASE_MOVE_SPEED
				top_state_switch_to(top_states.ALERT)
				return
			
			if not is_target_attackable and not never_move_nav:
				if self.global_position.distance_squared_to(last_seen_target_position) > engage_distance:
					self.velocity.y += .12
					A.move_nav(self, true, last_seen_target_position)
					return
				else:
					move_speed = BASE_MOVE_SPEED
					top_state_switch_to(top_states.ALERT)
					return
			# if active target
			# and active target is not viewable
			
			return
		top_states.MOVE:
			if not move_destination:
				move_destination = global_spawn_position
			
			if self.global_position.distance_squared_to(move_destination) < 15.0:
				move_speed = BASE_MOVE_SPEED
				top_state_switch_to(top_states.ALERT)
				return
			
			var is_target_attackable: bool = A.is_actor_ahead_approx(self, active_target) and A.is_actor_viewable(self, sight_raycast, active_target)
			if is_target_attackable:
				move_speed = BASE_MOVE_SPEED
				top_state_switch_to(top_states.ALERT)
				return
			if not is_target_attackable and not never_move_nav:
				if U.coin_flip():
					if not shootwalk_dir:
						shootwalk_dir = Vector2(
							[-1, 1, 0].pick_random(),
							[-1, 1, 0].pick_random()
						)
					A.apply_move(self, shootwalk_dir, move_speed)
				else:
					if self.global_position.distance_squared_to(move_destination) > engage_distance:
						self.velocity.y += .12
						A.move_nav(self, true, move_destination)
						return
				
				return
			return
		top_states.DEAD:
			return
	return

func equip_weapon(weapon_name: String, equip_anim: String = ""):
	var weapon_item: Dictionary = Weapons.by_name(weapon_name)
	if active_weapon_node:
		active_weapon_node.free()
	
	for c in rhand_anchor.get_children():
		c.free()
	
	if equip_anim:
		anim_set["equip"] = equip_anim
	else:
		#anim_set["equip"] = "equip_bigpistol"
		detect_weapon_params(weapon_name)
	
	is_equipping = true
	#A.animate(self, anim_set["equip"])
	active_weapon_name = weapon_name
	active_weapon_node = weapon_item["scene"].instantiate()
	active_weapon_node.actor = self
	active_weapon_node.prop_weapon = false
	active_weapon_node.suppress_aimdot = true
	detect_weapon_params(weapon_name) # Called twice out of laziness
	active_weapon_node.damage = int(active_weapon_node.damage * .45)
	rhand_anchor.add_child(active_weapon_node)
	
	active_weapon_ammo_left = weapon_item["mag_size"]
	active_weapon_mag_size = weapon_item["mag_size"]
	
	if active_weapon_name == "m_16_nato":
		active_weapon_node.burst_shot_limit = 1
	
	if active_weapon_node.get("finished_shot_callback"):
		active_weapon_node.finished_shot_callback = self._weapon_finished_shot
	
	await get_tree().create_timer(equip_delay_time).timeout

	if active_weapon_node.get("raycast_container"):
		for rc in active_weapon_node.raycast_container.get_children():
			rc.add_exception(self)
	elif active_weapon_node.get("raycast"):
		active_weapon_node.raycast.add_exception(self)
	
	is_equipping = false
	
	return

func update_active_targets() -> void:
	var candidates: Array = []
	for group in groups_i_dont_like:
		var group_nodes: Array = get_tree().get_nodes_in_group(group)
		#for actor in get_tree().get_nodes_in_group(group):
		for actor in group_nodes:
			if not actor.is_in_group("actors"):
				continue
			if actor.is_dead:
				continue
			if A.distance(self, actor) > target_distance_threshold:
				continue
			candidates.append(actor)
	
	for actor in candidates:
		#if U.coin_flip() and U.coin_flip() and U.coin_flip() and U.coin_flip() and U.coin_flip():
		if U.coin_flip() and U.coin_flip() and U.coin_flip():
			active_target = actor
			break
		if A.is_actor_viewable(self, sight_raycast, actor) and A.is_actor_ahead_approx(self, actor):
			active_target = actor
			break
	
	return


func top_state_switch_to(new_state: int) -> void:
	previous_top_state = top_state
	top_state = new_state
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3) -> void:
	if is_dead:
		return
	
	if caller and caller.is_in_group("clowns_freeling"):
		caller.friendlyfire_check()
	
	if caller and not caller.is_in_group("clowns_freeling"):
		active_target = caller
		A.face_position(self, active_target.global_position)
	
	var is_headshot: bool = false
	var adjusted_damage: int = damage
	if hit_type == U.hit_types.RAYCAST and hit_pos:
		var hit_dist_to_head: float = hit_pos.distance_squared_to(head_marker.global_position)
		if hit_dist_to_head < headshot_sqdist:
			is_headshot = true
			adjusted_damage = 100 + (damage * .50)
	
	health -= adjusted_damage
	
	flinch()
	#if U.coin_flip() and U.coin_flip():
		#flinch_control()
	
	if health > 0:
		audio_switchplay($Audio.find_children("pain_*").pick_random())
		
	if health < 1:
		kill_actor()
		if U.coin_flip():
			audio_switchplay($Audio.find_children("pain_*").pick_random())
		else:
			audio_switchplay($Audio.find_children("pain_*").pick_random())
		if is_headshot:
			pass
		return
	
	if not is_recently_hit:
		is_recently_hit = true
		await get_tree().create_timer(1.8).timeout
		is_recently_hit = false
	return

func fire_weapon(trigger_time: float = 0.0) -> void:
	if not active_weapon_node:
		prints(self.name, "Attempted to fire_weapon() without active_weapon_node")
		return
	
	var assumed_raycast: RayCast3D = U.get_weapon_raycast(active_weapon_node)
	var original_raycast_localrot: Vector3
	if assumed_raycast and is_accuracy_boost:
		original_raycast_localrot = assumed_raycast.rotation_degrees
		assumed_raycast.look_at(active_target.global_position)
		await get_tree().process_frame
	
	active_weapon_node.trigger_down(self)
	
	if assumed_raycast and is_accuracy_boost:
		await get_tree().process_frame
		assumed_raycast.rotation_degrees = original_raycast_localrot

	
	if trigger_time == 0.0:
		await get_tree().process_frame
	else:
		await get_tree().create_timer(trigger_time).timeout
	
	if trigger_time > -1.0:
		active_weapon_node.trigger_up()
		target_life_check()
	return

func kill_actor() -> void:
	#is_dead = true
	if is_dying or is_dead:
		return
	
	$sequencer_stepsound.stop()
	var anim_list: Array = anim.get_animation_list()
	var die_anims: Array = anim_list.filter(func (anim_name): return anim_name.contains("die"))
	anim_set["die"] = die_anims.pick_random()
	
	is_dying = true
	
	if active_weapon_node:
		active_weapon_node.visible = false
		var world_weapon: Node3D = U.spawn_world_weapon(active_weapon_node.hud_name, rhand_anchor.global_position)
		world_weapon.global_rotation = active_weapon_node.global_rotation
	is_dead = true
	
	var colshapes: Array = [colshape_standing, colshape_crouching]
	for colshape in colshapes:
		colshape.disabled = true
	return

func flinch() -> void:
	if is_flinching:
		return
	
	flinch_anim = ["flinch_lower1", "flinch_torso2"].pick_random()
	is_flinching = true
	await get_tree().create_timer(flinch_time).timeout
	is_flinching = false
	flinch_anim = ""
	return

func detect_weapon_params(weapon_name: String) -> void:
	var big_pistol_names: Array = ["python_357"]
	if big_pistol_names.has(weapon_name):
		anim_set["equip"] = "equip_bigpistol"
		anim_set["aim_focus"] = "aim_focus_bigpistol"
		anim_set["aim_shoot"] = "aim_shoot_bigpistol"
		attack_time = 4.0
	
	if active_weapon_node:
		if active_weapon_node.size != U.weapon_sizes.PISTOL or U.coin_flip():
			anim_set["equip"] = "clown_bomb_equip" # Temp
			anim_set["aim_focus"] = ["clowngrunt_armedshort_focus_1", "clowngrunt_armedshort_focus_2"].pick_random()
			anim_set["aim_shoot"] = ["clowngrunt_armedshort_shoot_1", "clowngrunt_armedshort_shoot_1"].pick_random()
		#if active_weapon_node.size == U.weapon_sizes.:
		else:
			anim_set["equip"] = "clown_bomb_equip" # Temp
			anim_set["aim_focus"] = "clowngrunt_armed_shoot_1"
			anim_set["aim_shoot"] = "clowngrunt_armed_shoot_1"
	elif not active_weapon_node:
		return
	
	return

func recoil_kick(amount: float) -> void:
	return

#actor.apply_body_kickback($kickback_origin.global_position, knockback_force)
func apply_body_kickback(origin: Vector3, kickback_force: float) -> void:
	var kickback_direction: Vector3 = (self.global_position - origin).normalized() * kickback_force
	self.velocity += kickback_direction
	get_tree().create_tween().tween_property(self, "velocity", Vector3.ZERO, 1.8)
	return

func audio_switchplay(audionode: AudioStreamPlayer3D) -> void:
	for a in audio_nodes:
		a.stop()
	audionode.play()
	return

func get_top_state_name() -> String:
	return top_states.keys()[top_state]

func time_tracker(delta) -> void:
	if top_state == top_states.ALERT and active_target:
		accumulated_alert_time += delta
		if accumulated_alert_time >= threshold_alert_time_expiry:
			is_alert_expired = true
			accumulated_alert_time = 0.0
	return

func target_life_check() -> void:
	if not active_target:
		return
	
	if active_target:
		if active_target.health <= 0:
			target_eliminated()
		return
	return

func target_eliminated() -> void:
	active_target = null
	passive_target = null
	is_first_contact = true
	return

func sound_control() -> void:
	if A.is_moving(self):
		$sequencer_stepsound.play("loop")
	else:
		$sequencer_stepsound.stop()
	return

func random_shoestep_sound() -> void:
	$Audio.find_children("footstep_*").pick_random().play()
	return

func friendlyfire_check() -> void:
	if not is_shooting:
		return
	if not active_weapon_node:
		return
	var weap_collider: Object = U.get_weapon_raycast(active_weapon_node).get_collider()
	if not weap_collider:
		return
	if weap_collider.is_in_group("clowns_freeling"):
		active_weapon_node.trigger_up()
	return

func alert_nearby_freelings() -> void:
	if not active_target:
		return
	
	for clown in get_tree().get_nodes_in_group("clowns_freeling"):
		if clown.is_dead:
			continue
		if clown.active_target:
			continue
		clown.active_target = active_target
	return
