extends Node3D

@export_enum("Random", "Red", "Blue", "White", "Blue Alt") var outfit: String = "Random"
@onready var model: Node3D = $club_dancer_fem
@onready var anim: AnimationPlayer = $club_dancer_fem/AnimationPlayer
@export var spawn_dance_anim: String
@export var random_turn_enabled: bool = true
@export var random_anim_time: bool = true
var original_position: Vector3 = Vector3.ZERO
var is_touched: bool = false
var touch_distance: float = 5.0

var ticker: float = 0.0
var tick_interval: float = 0.4

func _ready():
	if random_anim_time:
		anim.speed_scale = randf_range(.95, 1.05)
	set_outfit(outfit)
	if spawn_dance_anim:
		if spawn_dance_anim == "random":
			spawn_dance_anim = U.random_choice([
				"gesture_andaz_dance",
				"gesture_swug_dance",
				"gesture_shrug_dance",
				"gesture_reach_dance"
			])
		anim.play(spawn_dance_anim)
	original_position = self.global_position
	return

func _physics_process(delta):
	ticker += delta
	if ticker >= tick_interval:
		tick_control()
		ticker = 0.0
	return

func set_outfit(outfit_choice: String):
	var visible_meshes: Array[String] = [
		"club_female_head_1",
		"club_female_neck_1",
		"female_shoes_1",
		"club_female_torso_1",
		"female_stomach_1",
		"female_arms"
	]
	var skeleton: Skeleton3D = model.get_node("Armature/Skeleton3D")
	var all_meshes: Array = skeleton.get_children()
	match outfit_choice:
		"Random":
			var hair: String = U.random_choice(skeleton.find_children("*hair*")).name
			var shirt: String = U.random_choice(skeleton.find_children("*shirt*")).name
			var lower: String = U.random_choice(skeleton.find_children("*skirt*")).name
			visible_meshes.append_array([
				hair, shirt, lower, "female_legs",
			])
			if U.coin_flip():
				visible_meshes.append("female_leg_covers_1")
		"Red":
			var hair: String = U.random_choice(skeleton.find_children("*hair*")).name
			visible_meshes.append_array([
				hair,
				"female_shirt_club_red",
				"female_club_lower_red",
				"female_legs_partial",
				"female_leg_covers_1"
			])
			if U.coin_flip():
				visible_meshes.append("female_necklace")
		"Blue":
			var hair: String = U.random_choice(skeleton.find_children("*hair*")).name
			visible_meshes.append_array([
				hair,
				"female_shirt_club_blue",
				"female_club_lower_blue",
				"female_legs_partial",
				"female_leg_covers_1"
			])
			if U.coin_flip():
				visible_meshes.append("female_necklace")
		"White":
			var hair: String = U.random_choice(skeleton.find_children("*hair*")).name
			visible_meshes.append_array([
				hair,
				"female_tshirt_1",
				"civ_body_female_skirt_3",
				"female_legs"
			])
		"Blue Alt":
			pass
	
	for mesh in all_meshes:
		mesh.visible = mesh.name in visible_meshes
	return

func play_random_dance():
	var animation_list: PackedStringArray = anim.get_animation_list()
	var dance_animations: Array = []
	for anim_name in animation_list:
		if anim_name.to_lower().contains("dance"):
			dance_animations.append(anim_name)
	var dance_anim: String = U.random_choice(dance_animations)
	anim.play(dance_anim)
	return

func actor_touched(caller: Node3D):
	if is_touched:
		return
	is_touched = true
	original_position = self.global_position
	var move_out_time: float = .2
	var move_wait_time: float = 2.8
	var move_in_time: float = move_out_time * 2.5
	var slide_pos: Vector3 = self.global_position + (self.global_position - caller.global_position)
	slide_pos.y = original_position.y
	get_tree().create_tween().tween_property(
		self,
		"global_position",
		slide_pos,
		move_out_time
	).set_trans(Tween.TRANS_CIRC)
	await get_tree().create_timer(move_wait_time).timeout
	get_tree().create_tween().tween_property(
		self,
		"global_position",
		original_position,
		move_in_time
	)
	await get_tree().create_timer(move_in_time).timeout
	is_touched = false
	return

func tick_control():
	var player = U.grptop("players")
	if U.distance(self, player) < touch_distance:
		if A.is_moving(player):
			self.actor_touched(player)
	return
