extends StaticBody3D

var is_in_use: bool = false
var computer_interface: Control

func _ready():
	#computer_interface = get_tree().get_first_node_in_group("computer_interface")
	return



func interact(caller):
	if not computer_interface:
		computer_interface = get_tree().get_first_node_in_group("computer_interface")
	
	if not caller.is_in_group("players"):
		return
	
	if is_in_use:
		return
	
	is_in_use = true
	caller.player_interface = self
	caller.is_input_allowed = false
	caller.is_mouselook_locked = true
	var computer_user_cam: Camera3D = get_tree().get_first_node_in_group("computer_user_cam")
	computer_user_cam.current = true
	$Control.visible = true
	
	computer_interface.activate()
	return

func release(caller):
	is_in_use = false
	caller.player_interface = null
	caller.is_input_allowed = true
	caller.is_mouselook_locked = false
	var computer_user_cam: Camera3D = get_tree().get_first_node_in_group("computer_user_cam")
	computer_user_cam.current = false
	$Control.visible = false
	
	computer_interface.deactivate()
	return

func push_event(event: InputEvent):
	computer_interface.cursor_control(event)
	return
