extends Control

# TODO
# - implement double click for icons
# - Make map selector

signal mouse_motion(event: InputEventMouseMotion)

@onready var cursor: CanvasItem = $cursor
@onready var cursor_raycast: RayCast2D = $cursor/RayCast2D
var is_cursor_enabled: bool = false
var cursor_bounds: Dictionary = {
	"x": 610,
	"y": 450
}

var color_startmenu_unclicked: Color = Color.from_string("c0c0c0", Color.MAGENTA)
var color_startmenu_clicked: Color = Color.from_string("6a6a6a", Color.MAGENTA)

func cursor_control(event: InputEvent):
	if not is_cursor_enabled:
		return
	
	if event is InputEventKey:
		return
	
	if event is InputEventMouseMotion:
		cursor.position.x += event.relative.x
		cursor.position.y += event.relative.y
		
		if cursor.position.x > cursor_bounds.x:
			cursor.position.x = cursor_bounds.x
		if cursor.position.x < 0:
			cursor.position.x = 0
		if cursor.position.y > cursor_bounds.y:
			cursor.position.y = cursor_bounds.y
		if cursor.position.y < 0:
			cursor.position.y = 0
	
	if event is InputEventMouseButton:
		cursor_button(event)
	
	return

func activate():
	is_cursor_enabled = true
	return
	
func deactivate():
	is_cursor_enabled = false
	return

func cursor_button(event: InputEventMouseButton):
	var things_clicked: Array = []
	if event.pressed and event.button_index == 1:
		prints(self.name, "Clicked at", cursor.position)
		for cyber_button in get_tree().get_nodes_in_group("cyber_buttons"):
			var collider: Object = cursor_raycast.get_collider()
			if collider and collider.name == cyber_button.name:
				things_clicked.append(collider)
	
	for thing in things_clicked:
		if thing.name == "start_menu_button":
			click_start_menu()
		if thing.name == "mapper_button":
			click_mapper_icon()
	return

func click_start_menu():
	prints(self.name, "start menu clicked")
	return

func click_mapper_icon():
	prints(self.name, "mapper clicked")
	get_tree().get_first_node_in_group("app_mapper").activate()
	return

func bsod_event():
	$start_menu_button/ColorRect.color = color_startmenu_clicked
	await get_tree().create_timer(.1).timeout
	$start_menu_button/ColorRect.color = color_startmenu_unclicked
	$bsod_event/AnimationPlayer.play("bluescreen")
	return

func release():
	var computer: Node3D = get_tree().get_first_node_in_group("computer")
	var player: Node3D = get_tree().get_first_node_in_group("players")
	computer.release(player)
	return
