extends World

#signal scene_ended

var is_already_triggered: bool = false
@onready var map: TBLoader = $NavigationRegion3D/Map
var longhall_doortrig: Area3D
@onready var exit_trigger: Area3D = $tutorial_triggers/exit_trigger
var is_exit_triggered: bool = false
var is_longroom_darken_trigger_tripped: bool = false

func _ready():
	var map_areatriggers = map.find_children("*", "Area3D")
	for areatrigger in map_areatriggers:
		if longhall_doortrig:
			break
		if "target_group" in areatrigger and areatrigger.target_group.contains("%longhalltrig"):
			longhall_doortrig = areatrigger
			break
	
	longhall_doortrig.connect("body_entered", _doors_triggered)
	A.animate($doorman1, "sword_idle")
	A.animate($doorman2, "sword_idle")
	
	exit_trigger.connect("body_entered", _body_entered_exit_trigger)
	return

func _doors_triggered(body: Node3D):
	if is_already_triggered:
		return
	if body == get_tree().get_first_node_in_group("players"):
		is_already_triggered = true
		await get_tree().create_timer(0.7).timeout
		$doorman1.scripted_event_pos = $rush_point1.global_position
		$doorman2.scripted_event_pos = $rush_point2.global_position
		$doorman1.top_state_switch_to($doorman1.top_states.SCRIPTED_EVENT)
		$doorman2.top_state_switch_to($doorman1.top_states.SCRIPTED_EVENT)
		$doorman1.active_target = get_tree().get_first_node_in_group("players")
		$doorman2.active_target = get_tree().get_first_node_in_group("players")
	return
	


func _on_kill_trench_trigger_body_entered(body):
	if body.is_in_group("hit_takers"):
		body.hit(9999, U.hit_types.UNDEFINED, null, body.global_position)
	return


func _on_last_room_glow_trigger_body_entered(body):
	if body.is_in_group("players"):
		$WorldEnvironment/AnimationPlayer.play("glow_up")
		$map_externals/last_room_glow_trigger.queue_free()
		return

func _body_entered_exit_trigger(body: Node3D):
	if not body.is_in_group("players"):
		return
	
	tutorial_exit()
	return

func tutorial_exit():
	if is_exit_triggered:
		return
	# Fade out or whatever
	# Change scene (Director?)
	for player in get_tree().get_nodes_in_group("players"):
		player.trigger_exit_mode()
		player.velocity = Vector3.ZERO
		player.kick()
	
	await get_tree().create_timer(.11).timeout
	Engine.time_scale = .02
	$world_camera/spatial_shader/AnimationPlayer.play("flicker_in")
	$world_camera.current = true
	$exit_ui.visible = true
	
	await get_tree().create_timer(0.08).timeout # Should be able to skip this with a keypress
	scene_ended.emit()
	return


func _on_longroom_darken_trigger_body_entered(body):
	if is_longroom_darken_trigger_tripped: return
	if body.is_in_group("players"):
		is_longroom_darken_trigger_tripped = true
		$WorldEnvironment/AnimationPlayer.pause()
		get_tree().create_tween().tween_property(
			$WorldEnvironment,
			"environment:ambient_light_energy",
			.33,
			1.2
		)
	return
