@tool
extends Node3D

enum card_colors {
	RED,
	BLUE,
	GREEN,
	GOLD
}
var pickup_range: float = 5.0 # 10.0

@export var card_color: card_colors = card_colors.RED :
	get:
		return card_color
	set(value):
		for mesh in self.find_children("*_credits"):
			var color_query: String = card_colors.keys()[value].to_lower()
			var mesh_color: String = mesh.name.split("_")[0].to_lower()
			if color_query == mesh_color:
				mesh.visible = true
			else:
				mesh.visible = false
		card_color = value

var credit_amounts: Dictionary = {
	card_colors.RED: 25,
	card_colors.BLUE: 50,
	card_colors.GREEN: 100,
	card_colors.GOLD: 1000
}

func _on_ticker_timeout():
	var credit_amount: int = credit_amounts[card_color]
	var players: Array = get_tree().get_nodes_in_group("players")
	for player in players:
		if player.global_position.distance_to(self.global_position) < pickup_range:
			player.add_credits(credit_amount)
			$AudioStreamPlayer3D.play()
			
			self.visible = false
			
			$ticker.stop()
			await get_tree().create_timer(.5).timeout
			self.queue_free()
			return
	return
