extends Node3D

@onready var model: Node3D = $generic_debris_effect
@onready var anim: AnimationPlayer = $generic_debris_effect/AnimationPlayer
#@onready var sequencer: AnimationPlayer = $sequencer
@export var debris_scale: float = 1.0
@export var debris_portion: float = 1.0
@export var random_rotations: bool = true

func _ready() -> void:
	for mesh in model.find_children("*", "MeshInstance3D"):
		mesh.scale = Vector3.ONE * debris_scale
	return

func set_materials(new_material: Material) -> void:
	for mesh in model.find_children("*", "MeshInstance3D"):
		mesh.set_surface_override_material(0, new_material)
	return

func explode_and_fade() -> void:
	#sequencer.play("explode")
	set_portion()
	if random_rotations:
		self.rotation_degrees.y = [0, 180, 90, -90].pick_random()
	
	anim.play("Animation")
	for mesh in model.find_children("*", "MeshInstance3D"):
		get_tree().create_tween().tween_property(
			mesh,
			"transparency",
			1.0,
			1.0
		).set_trans(Tween.TRANS_CUBIC)
	
	cleanup()
	return

func explode_and_void() -> void:
	#sequencer.play("explode")
	set_portion()
	anim.play("Animation")
	await get_tree().create_timer(anim.get_animation("Animation").length).timeout
	self.visible = false
	cleanup()
	return

func cleanup() -> void:
	await get_tree().create_timer(2.0).timeout
	return

func set_portion() -> void:
	var all_meshes: Array = model.find_children("*", "MeshInstance3D")
	var total_mesh_count: int = all_meshes.size()
	var visible_mesh_count: int = int(
		clampf(debris_portion, 0.0, 1.0) * total_mesh_count
	)
	var visible_meshes: Array = []
	var invisible_meshes: Array = []
	for mesh in all_meshes:
		#mesh.visible = false
		invisible_meshes.append(mesh)
	
	invisible_meshes.shuffle()
	for i in range(visible_mesh_count):
		visible_meshes.append(invisible_meshes.pop_front())
	
	for mesh in invisible_meshes:
		mesh.visible = false
	return
