extends Node

@onready var grunt: CharacterBody3D = get_parent()
@onready var phys_anchor: Node3D = grunt.get_node("phys_anchor")
@onready var sight_sweeper: RayCast3D = $"../graphics/grunt/Armature/Skeleton3D/attach_hitbox_torso/anchor/sight_sweeper"
@onready var carrot: Node3D = grunt.get_node("phys_anchor/carrot")
@onready var delayed_ticker: Timer = $delayed_ticker
@onready var aggression_timer: Timer = $aggression_timer

enum behavior_states {
	IDLE,
	FIDGET,
	ROAM,
	ALERT,
	STANDING_ATTACK
}
var active_behavior_state: int = behavior_states.IDLE
var is_aggressive: bool = false
var is_forced_idle: bool = true
@export var is_aiming: bool = false
@export var move_speed: float = 1.0
var default_move_speed: float = 1.0
var aggressive_move_speed: float = 11.0

func ready():
	return

func process_idle_state():
	return

func process_fidget_state():
	return

func _physics_process(_delta):
	check_sight_for_wakeup()
	return

func check_sight_for_wakeup():
	var object_seen: Object = sight_sweeper.get_collider()
	if object_seen and object_seen.is_in_group("hit_takers"):
		if not is_instance_of(object_seen, PhysicsBody3D): return
		if object_seen.get_rid() == grunt.get_rid():
			sight_sweeper.add_exception(grunt)
		elif object_seen.is_in_group("grunts"):
			sight_sweeper.add_exception(object_seen)
		else:
			wake_up()
	return

func process_roam_state():
	delayed_ticker.wait_time = randf_range(1.0, 2.0)
	var rand_choice: int = randi_range(0, 2)
	match rand_choice:
		0:
			var rand_y_rotation: float = randf_range(0, 6)
			grunt.rotate_y(rand_y_rotation)
			grunt.apply_move(Vector2(0, 1) * move_speed)
		1:
			grunt.apply_move(Vector2(0,0))
		2:
			var rand_y_rotation: float = randf_range(0, 6)
			grunt.rotate_y(rand_y_rotation)
			grunt.apply_move(Vector2(0,0))
	return

func process_alert_state():
	return

func process_standing_attack_state():
	return

func _on_delayed_ticker_timeout():
	process_simple_behavior()
	return

func get_offline_player():
	return get_tree().get_first_node_in_group("players")

func process_simple_behavior():
	if is_aiming: return
	if is_forced_idle: return
	
	var random_choice: int = randi_range(0,4)
	var player: CharacterBody3D = get_offline_player()
	if player.global_position.distance_to(grunt.global_position) >= 50:
		match random_choice:
			0:
				process_roam_state()
			2:
				grunt.look_towards(player.global_position, 1.0)
			3:
				process_roam_state()
		return
	
	if is_collider_hittaker():
		is_aggressive = true
		aggression_timer.start()
		
	if is_aggressive:
		move_speed = aggressive_move_speed
		look_at_offline_player()
		aim_and_shoot()
		
		if is_collider_hittaker():
			grunt.apply_move(Vector2(0, 1))
		else:
			look_at_offline_player()
			random_strafe()
		return
		
		
	match random_choice:
		0:
			look_at_offline_player()
		1:
			process_roam_state()
		2:
			process_roam_state()
			aim_and_shoot()
			
		3:
			is_aggressive = true
			#aggression_timer.start()
		4:
			aim_and_shoot()
			is_aggressive = true
	return

func aim_and_shoot():
	$sequencer.play("aim_and_shoot")
	return

func shoot():
	grunt.grunt_rifle.full_auto_shoot(grunt)
	return

func random_strafe():
	var random_strafe_value: int = randi_range(-1, 1)
	if random_strafe_value == 0: random_strafe_value = 1
	grunt.apply_move(Vector2(random_strafe_value, 0))
	return

func look_at_offline_player():
	var player_origin: Vector3 = get_offline_player().global_position
	var y_diff: float = player_origin.y - grunt.global_position.y
	
	var target_origin: Vector3 = player_origin
#	if abs(y_diff) > 1:
#		target_origin.y = grunt.global_position.y
	grunt.look_towards(target_origin, 1.0)
	return

func is_collider_hittaker():
	var collider: Object = grunt.grunt_rifle.raycast.get_collider()
	if not collider:
		return false
	if collider.is_in_group("hit_takers"):
		return true
	return


func _on_aggression_timer_timeout():
	is_aggressive = false
	move_speed = default_move_speed
	return

func wake_up():
	is_forced_idle = false
	return
