extends CharacterBody3D

# TODO
# - Make a function to hit the target (not just shoot towards)
# - Make a running toggle
# - Fix running anims

const SPEED = 8.0
const JUMP_VELOCITY = 4.5

@export var spawn_idle: bool = true
@export var health: int = 52
var base_health: int
var rolling_damage_received: Array[int] = []
var rolling_damage_tick: float = 1.0
var rolling_damage_delta: float = 0


var gravity = (ProjectSettings.get_setting("physics/3d/default_gravity") * 6)

@onready var grunt_brain: Node = $grunt_brain
#@onready var grunt_rifle: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor/debug_grunt_rifle # Temporary?
@onready var grunt_rifle: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor/debug_grunt_rifle
@onready var flashlight: SpotLight3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor/flashlight
@onready var anim: AnimationPlayer = $graphics/grunt/AnimationPlayer
@onready var hit_sound: AudioStreamPlayer3D = $Sound/hit_sound
@onready var rhand: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor
@onready var lhand: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_lhand/anchor
@onready var eyes: Node3D = $eyes
@onready var cover_feeler_top: RayCast3D = $graphics/grunt/Armature/Skeleton3D/attach_hitbox_legs/anchor/cover_feeler_top
@onready var cover_feeler_bottom: RayCast3D = $graphics/grunt/Armature/Skeleton3D/attach_hitbox_legs/anchor/cover_feeler_bottom
@onready var sight_sweeper: RayCast3D = $graphics/grunt/Armature/Skeleton3D/attach_hitbox_torso/anchor/sight_sweeper
@onready var anim_timer: Timer = $anim_timer
@onready var debug_label: Label3D = $debug_label

var ammo: int = 150

var anim_set: Dictionary = {
	"idle": "armed_idle",
	"aim": "armed_aim",
	"travel": "armed_run",
	"die": "die2"
}
var anim_locked: bool = false

enum armed_types {
	UNARMED,
	ARMED,
	AKIMBO
}
var armed_type: int = armed_types.UNARMED

var is_dead: bool = false
var last_anim: String

@onready var bark_sounds: Array = [$Sound/bark1, $Sound/bark2, $Sound/bark3]
@export var flashlight_enabled: bool = false :
	get:
		return flashlight_enabled
	set(value):
		flashlight_enabled = value
		flashlight.visible = value

func _ready():
#	equip_grunt_rifle()
	grunt_rifle.raycast.add_exception(self)
	base_health = health
	await get_tree().create_timer(.8).timeout; grunt_brain.sight_sweeper = sight_sweeper
	
	if not spawn_idle:
		grunt_brain.wake_up()
	return

func equip_grunt_rifle():
	return

func _physics_process(delta):
	apply_gravity(delta)
	move_and_slide()
	animate()
	
	if not is_dead:
		rolling_damage_delta += delta
		if rolling_damage_delta >= rolling_damage_tick:
			rolling_damage_delta = 0
			rolling_damage_received.pop_front()
	return

func apply_gravity(delta):
	# Add the gravity.
	if not is_on_floor():
		velocity.y -= gravity * delta
	return


func apply_jump():
	# Handle Jump.
	velocity.y = JUMP_VELOCITY
	return

func apply_move(input_dir: Vector2):
	# Get the input direction and handle the movement/deceleration.
	# As good practice, you should replace UI actions with custom gameplay actions.
	# var input_dir = Input.get_vector("ui_left", "ui_right", "ui_up", "ui_down")
	var direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	if direction:
		velocity.x = direction.x * SPEED
		velocity.z = direction.z * SPEED
	else:
		velocity.x = move_toward(velocity.x, 0, SPEED)
		velocity.z = move_toward(velocity.z, 0, SPEED)
	return

func look_towards(target_position: Vector3, turn_speed: float):
	# This could probably be done with tween, without the eyes node
	eyes.look_at(target_position, Vector3.UP, true)
	self.rotation.x = (eyes.rotation.x * .9)
	self.rotate_y(eyes.rotation.y * turn_speed)
	return

func check_dead():
	return health < 0
	
func check_aiming():
	return grunt_brain.is_aiming
	
func check_traveling():
	return is_on_floor() and not velocity.is_zero_approx()

func check_taking_cover():
	return grunt_brain.is_taking_cover
	
func animate():
	if is_dead: return
	
	var conditions: Dictionary = {
		"die": [
			check_dead()
		],
		"cover": [
			check_taking_cover()
		],
		"aiming": [
			check_aiming()
		],
		"idle": [
			is_on_floor(),
			velocity.is_zero_approx()
		],
		"travel": [
			check_traveling()
		]
	}
	
	var animate_condition: String
	for condition in conditions:
		var condition_met: bool = conditions[condition].all(U.is_true)
		if not condition_met:
			continue
		
		animate_condition = condition
		break
	
	match animate_condition:
		"die":
			anim_h(anim_set["die"], true, 10.0)
			kill_actor()
		"cover":
			anim_h("crouch_aim")
		"aiming":
			if check_traveling():
				anim_h("armed_aim_run", true)
			else:
				anim_h("armed_aim", true)
			#anim_h(anim_set["aim"], true, 0.6)
		"idle":
			anim_h(anim_set["idle"])
		"travel":
			anim_h(anim_set["travel"])
	return

func set_armed_type(new_armed_type):
	match new_armed_type:
		armed_types.UNARMED:
			anim_set["idle"] = "unarmed_idle"
			anim_set["travel"] = "unarmed_run"
			anim_set["crouch"] = "crouch"
			anim_set["die"] = "die1"
		armed_types.ARMED:
			anim_set["idle"] = "unarmed_idle"
			anim_set["travel"] = "unarmed_run"
			anim_set["crouch"] = "crouch"
			anim_set["die"] = "die1"
#		armed_types.AKIMBO:
#			anim_set["idle"] = "akimbo_idle"
#			anim_set["run"] = "akimbo_run"
#			anim_set["jump"] = "akimbo_jump"
#			anim_set["crouch"] = "crouch"
#			anim_set["handstand"] = "armed_handstand"
	armed_type = new_armed_type
	return

func hit(damage: int, hit_type: int):
	if is_dead: return
	grunt_brain.wake_up()
	
	# I was going to use g_area here to detect a grunt_alert_area
	# but I'm not too sure how to do it right now
	
	health -= damage
	rolling_damage_received.push_back(damage)
	
	if hit_type == U.hit_types.UNDEFINED:
		hit_sound.play()
	elif hit_type == U.hit_types.KICK:
		$Sound/hit_sound2.play()
	elif hit_type == U.hit_types.KNOCKABLE:
		$Sound/knockable_hit.play()
	if health > 0:
		var flinch_anim: String

		if len(rolling_damage_received) >= 3:
			flinch_anim = "rapid_flinch"
		elif grunt_brain.is_taking_cover:
			flinch_anim = "crouch_flinch"
		else:
			flinch_anim = "mid_flinch"
		#anim_h(flinch_anim, true, .3)
		anim_h(flinch_anim, true, .6)
		
		var rand_choice: int = randi_range(0, 3)
		match rand_choice:
			0:
				$Sound/hurt_sound1.play()
			1:
				pass
			2:
				$Sound/hurt_sound3.play()
	
	if health < 40 and health > 0:
		grunt_brain.is_about_to_die = true
	return

func anim_h(anim_name: String = "", force_anim: bool = false, duration: float = 0.0):
	if anim_name == "":
		return
	if anim.current_animation == anim_name:
		return
	
	if anim_locked and not force_anim:
		return
	
	if force_anim:
		anim.seek(0)
		anim.stop()
	
	if force_anim and duration > 0:
		anim_timer.wait_time = duration
		anim_locked = true
		anim_timer.start()

	elif force_anim and duration == 0:
		anim_timer.wait_time = 1
		anim_locked = true
		anim_timer.start()
	
	anim.play(anim_name)
	last_anim = anim_name
	return


func _on_anim_timer_timeout():
	anim_locked = false
	return

func kill_actor():
	
	is_dead = true
	grunt_brain.process_mode = Node.PROCESS_MODE_DISABLED
#	for child in self.get_children():
#		if child.name.begins_with("hitbox_"):
#			child.disabled = true
	if randi_range(0, 1) == 0:
		$Sound/die_sound.play()
	else:
		$Sound/die_sound2.play()
	
	self.position.y += 1
	var dead_collider: CollisionShape3D = preload("res://Scenes/dead_collider.tscn").instantiate()
	self.add_child(dead_collider)
	$hitbox_head_col.disabled = true
	$hitbox_lower.disabled = true
	$hitbox_torso_col.disabled = true
	flashlight.visible = false
	return

func random_bark():
	var random_index: int = randi_range(0, (len(bark_sounds)-1))
	bark_sounds[random_index].play()
	return

func toggle_flashlight():
	if not flashlight:
		print("No flashlight available, did not enable.")
		return
	print("Flashlight available, enabled.")
	flashlight.visible = !flashlight.visible
	prints("Flashlight state:", flashlight.visible)
	return

func set_leg_hitbox(anim_name: String):
	$hitbox_lower/AnimationPlayer.play(anim_name)
	return
