extends Node

@onready var grunt: CharacterBody3D = get_parent()
@onready var phys_anchor: Node3D = grunt.get_node("phys_anchor")
#@onready var sight_sweeper: RayCast3D = $"../graphics/grunt/Armature/Skeleton3D/attach_hitbox_torso/anchor/sight_sweeper"
@onready var sight_sweeper: RayCast3D
@onready var carrot: Node3D = grunt.get_node("phys_anchor/carrot")
@onready var delayed_ticker: Timer = $delayed_ticker
@onready var aggression_timer: Timer = $aggression_timer
@onready var cover_timer: Timer = $cover_timer
@onready var cover_cooloff: Timer = $cover_cooloff

enum behavior_states {
	IDLE,
	FIDGET,
	ROAM,
	ALERT,
	STANDING_ATTACK
}
var active_behavior_state: int = behavior_states.IDLE
var is_aggressive: bool = false
var is_forced_idle: bool = true
var is_taking_cover: bool = false
var is_about_to_die: bool = false
@export var is_aiming: bool = false
@export var move_speed: float = 1.0
var default_move_speed: float = 1.0
var aggressive_move_speed: float = 11.0

var target: Object

func _ready():
	return

func process_idle_state():
	return

func _physics_process(_delta):
	check_sight_for_wakeup()
	return

func check_sight_for_wakeup():
	if not sight_sweeper:
		#push_warning("Sight sweeper is null.") # Too many errors that I won't fix
		sight_sweeper = grunt.sight_sweeper
		return
	var object_seen: Object = sight_sweeper.get_collider()
	if object_seen and object_seen.is_in_group("hit_takers"):
		if not is_instance_of(object_seen, PhysicsBody3D): return
		if object_seen.get_rid() == grunt.get_rid():
			sight_sweeper.add_exception(grunt)
			print(1)
		else:
			wake_up()
	return

func process_fidget_state():
	return

func process_roam_state():
	if is_taking_cover: return
	
	delayed_ticker.wait_time = randf_range(1.0, 2.0)
	var rand_choice: int = randi_range(0, 2)
	match rand_choice:
		0:
			var rand_y_rotation: float = randf_range(0, 6)
			grunt.rotate_y(rand_y_rotation)
			grunt.apply_move(Vector2(0, 1) * move_speed)
		1:
			grunt.apply_move(Vector2(0,0))
		2:
			var rand_y_rotation: float = randf_range(0, 6)
			grunt.rotate_y(rand_y_rotation)
			grunt.apply_move(Vector2(0,0))
	return

func process_alert_state():
	return

func process_standing_attack_state():
	return

func _on_delayed_ticker_timeout():
	process_simple_behavior()
	return

func get_offline_player():
	return get_tree().get_first_node_in_group("players")

func process_simple_behavior():
	if is_aiming: return
	if is_forced_idle: return
	
	if is_about_to_die:
		is_aggressive = true
	
	var random_choice: int = randi_range(0,4)
	var player: CharacterBody3D = get_offline_player()
	if player.global_position.distance_to(grunt.global_position) >= 120:
		match random_choice:
			0:
				process_roam_state()
			2:
				grunt.look_towards(player.global_position, 1.0)
			3:
				process_roam_state()
		return
	
	if grunt.health < grunt.base_health and not is_about_to_die:
		var is_cover_available: bool = take_cover_control()
		if is_cover_available:
			return
	
	if is_collider_hittaker():
		is_aggressive = true
		aggression_timer.start()
		
	if is_aggressive:
		move_speed = aggressive_move_speed
		look_at_offline_player()
		aim_and_shoot()
		
		if is_collider_hittaker() and not is_about_to_die:
			grunt.apply_move(Vector2(0, 1))
		elif is_about_to_die:
			grunt.apply_move(Vector2(0, -1))
		elif not is_collider_hittaker() and not is_about_to_die:
			look_at_offline_player()
			random_strafe()
		return
		
		
	match random_choice:
		0:
			look_at_offline_player()
		1:
			process_roam_state()
		2:
			process_roam_state()
			aim_and_shoot()
			
		3:
			is_aggressive = true
			#aggression_timer.start()
		4:
			aim_and_shoot()
			is_aggressive = true
	return

func aim_and_shoot():
	var random_chance: int = randi_range(0,11)
	if random_chance == 2: grunt.random_bark()
	$sequencer.play("aim_and_shoot")
	return

func shoot():
	#grunt.grunt_rifle.full_auto_shoot(grunt)
	grunt.grunt_rifle.full_auto_shoot_long(grunt)
	return

func random_strafe():
	if is_taking_cover: return
	
	var random_strafe_x: int = randi_range(-1, 1)
	var random_strafe_y: int = randi_range(-1, 1)
	if random_strafe_x == 0: random_strafe_x = 1
	grunt.apply_move(Vector2(random_strafe_x, random_strafe_y))
	return

func look_at_offline_player():
	var player_origin: Vector3 = get_offline_player().global_position
	var y_diff: float = player_origin.y - grunt.global_position.y
	
	var target_origin: Vector3 = player_origin
#	if abs(y_diff) > 1:
#		target_origin.y = grunt.global_position.y
	grunt.look_towards(target_origin, 1.0)
	return

func look_at_target():
	var target_origin: Vector3 = target.global_position
	var y_diff: float = target_origin.y - grunt.global_position.y
	
	grunt.look_towards(target_origin, 1.0)
	return

func is_collider_hittaker():
	var collider: Object = grunt.grunt_rifle.raycast.get_collider()
	if not collider:
		return false
	if collider.is_in_group("hit_takers"):
		return true
	return

func take_cover_control():
	if not cover_cooloff.is_stopped():
		return false
	if not cover_timer.is_stopped():
		return false
	
	# Check feelers
	var is_cover_available: bool
	var top_feeler_collider: Node3D = grunt.cover_feeler_top.get_collider()
	var bottom_feeler_collider: Node3D = grunt.cover_feeler_bottom.get_collider()
	
	if not top_feeler_collider and bottom_feeler_collider:
		is_cover_available = false
		return is_cover_available
	
	if is_instance_of(top_feeler_collider, StaticBody3D) and is_instance_of(bottom_feeler_collider, StaticBody3D):
		is_cover_available = true
	

	
	# If both have a static body in front of them, take cover for a random time between 2 seconds and 10 seconds
	var min_cover_time: float = 2
	var max_cover_time: float = 10
	cover_timer.wait_time = randf_range(min_cover_time, max_cover_time)
	cover_timer.start()
	is_taking_cover = true
	
	# Bypass animations, just crouch until the timer goes off
	grunt.set_leg_hitbox("half")
	
	return is_cover_available

func _on_aggression_timer_timeout():
	is_aggressive = false
	move_speed = default_move_speed
	return



func _on_cover_timer_timeout():
	is_taking_cover = false
	grunt.set_leg_hitbox("full")
	cover_cooloff.start()
	return


func _on_cover_cooloff_timeout():
	return

func wake_up():
	is_forced_idle = false
	return
