extends Node3D

@onready var raycast: RayCast3D = $RayCast3D
@onready var anim: AnimationPlayer = $AnimationPlayer

@onready var smoke_puff: Sprite3D = $"Lazy Cache/smoke_puff"
var smoke_puff_fpath: String = ""
var default_shoot_sound_pitch: float = 1.5
var raycast_exception_nodes: Array = []

var damage: int = 25 #45

var csgbox: Resource = preload("res://Scenes/csg_box_subtract_test.tscn")

func _ready():
	return


func _process(delta):
	return

func primary_action(caller, action_type):
	match action_type:
		U.primary_action_types.TAP:
			semi_auto_shoot(caller)
		U.primary_action_types.HOLD:
			full_auto_shoot(caller)
	return


func impact_control():
	var collider: Object = raycast.get_collider()
	if collider:
		if collider.is_in_group("hit_takers"):
			collider.hit(damage, U.hit_types.UNDEFINED)
		
		var impact_position = raycast.get_collision_point()
		var new_smoke_puff: Sprite3D = smoke_puff.duplicate()
		var assumed_world = get_tree().get_first_node_in_group("Worlds")
		assumed_world.add_child(new_smoke_puff)
		new_smoke_puff.global_position = raycast.get_collision_point()
		new_smoke_puff.get_node("AnimationPlayer").play("fade")
		
		## CSG TEST
		if is_instance_of(collider, CSGCombiner3D):

			var new_box: CSGMesh3D = csgbox.instantiate()
			collider.add_child(new_box)
			new_box.global_position = raycast.get_collision_point()
	return

func shell_casing_control():
	var new_shell_casing: Node3D = $'Lazy Cache/9_mm_shell_casing'.duplicate()
	var assumed_world = get_tree().get_first_node_in_group("Worlds")
	assumed_world.add_child(new_shell_casing)
	new_shell_casing.global_position = $'Lazy Cache/9_mm_shell_casing'.global_position
	new_shell_casing.global_rotation = $'Lazy Cache/9_mm_shell_casing'.global_rotation
	var anim_choice_index: int = randi_range(0, 2)
	var anim_name: String = ["eject", "eject_2", "eject_3"][anim_choice_index]
	new_shell_casing.get_node("AnimationPlayer").play(anim_name)
	new_shell_casing.process_mode = Node.PROCESS_MODE_INHERIT
	return

func semi_auto_shoot(caller):
	if "ammo" in caller:
		if caller.ammo < 1: return
		caller.ammo -= 1
			
	anim.stop()
	anim.play("shoot semi")
	impact_control()
	return

func full_auto_shoot(caller):
	if "ammo" in caller:
		if caller.ammo < 1: return
		caller.ammo -= 1

	randomize_shoot_pitch()
	anim.play("shoot auto")
	if "ammo" in caller:
		caller.ammo -= 1
	#impact_control()
	return

func full_auto_shoot_long(caller):
	if "ammo" in caller:
		if caller.ammo < 1: return
		caller.ammo -= 1

	randomize_shoot_pitch()
	anim.play("shoot auto long")
	if "ammo" in caller:
		caller.ammo -= 1
	#impact_control()
	return

func stop_action(caller, action_type):
	anim.stop()
	anim.play("idle")
	if action_type == U.primary_action_types.HOLD:
		$semi_shoot.pitch_scale = default_shoot_sound_pitch
	return

func randomize_shoot_pitch():
	var new_pitch: float = 0.0
	var first_step: int = randi_range(0, 2)
	if first_step == 0:
		new_pitch = randf_range(.7, .8)
	elif first_step == 1:
		new_pitch = randf_range(.8, .9)
	elif first_step == 2:
		new_pitch = .6
	$semi_shoot.pitch_scale = new_pitch

	return

func reload(caller):
	$reload.play()
	return


func _on_delayed_ticker_timeout():
	return
