extends Control

var predefined_scene: Node3D
#var predefined_scene_fpath: String = "res://Scenes/lab.tscn" # Broken?
var predefined_scene_fpath: String = "res://Scenes/lab_2.tscn" # MAP02
#var predefined_scene_fpath: String = "res://Scenes/lab_three.tscn" # MAP04
#var predefined_scene_fpath: String = "res://Scenes/core_rnd.tscn" # Dark room
#var predefined_scene_fpath: String = "res://Scenes/Levels/e1_tickets_please.tscn"
#var predefined_scene_fpath: String = "res://Scenes/Levels/e2_quiet_please.tscn"
#var predefined_scene_fpath: String = "res://Scenes/core_rnd_b.tscn" # Spooky doors
#var predefined_scene_fpath: String = "res://Scenes/bsp_test.tscn"
#var predefined_scene_fpath: String = "res://Scenes/net_core_rnd.tscn" # (Net) Dark room
var tutorial_scene_fpath: String = "res://Scenes/core_rnd_b.tscn"
var play_scene_fpath: String = "res://Scenes/Levels/e1_tickets_please.tscn"
var demo_scene_fpath: String = "res://Scenes/core_rnd.tscn"
@onready var world_container: Node3D = $Worlds
@export var auto_load: bool = false

func _ready():
	Blackboard.user_scene_root = self
	if auto_load:
		load_predefined()
	return

func _unhandled_input(event):
	if Input.is_action_just_pressed("ui_cancel") and world_container.get_child_count() > 0:
		match visible:
			true:
				world_resume()
			false:
				world_block()
	return


func _on_quit_pressed():
	get_tree().quit()
	return


func _on_resume_pressed():
	world_resume()
	return


func _on_load_predefined_pressed():
	load_predefined()
	return

func world_resume():
	self.hide()
	Input.mouse_mode = Input.MOUSE_MODE_CAPTURED
	allow_player_input()
	return

func world_block():
	self.show()
	Input.mouse_mode = Input.MOUSE_MODE_VISIBLE
	block_player_input()
	return

func allow_player_input():
	get_tree().get_first_node_in_group("players").is_input_allowed = true
	return

func block_player_input():
	get_tree().get_first_node_in_group("players").is_input_allowed = false
	return

func load_predefined():
	Engine.time_scale = 1.0
	for world in world_container.get_children():
		world.free()
	await get_tree().process_frame
	predefined_scene = load(predefined_scene_fpath).instantiate()
	world_container.add_child(predefined_scene)
	self.hide()
	return


func _on_reset_time_scale_pressed():
	Engine.time_scale = 1.0 if Engine.time_scale != 1.0 else 0.5 # Kinda' slow?
	#Engine.time_scale = 1.0 if Engine.time_scale != 1.0 else 0.1 # Really slow
	return


func _on_rebuild_maps_pressed():
	var maps: Array = get_tree().get_nodes_in_group("trenchbroom_maps")
	for map in maps:
		var map_script: Script = map.get_script()
		print(map_script)
		if not map_script:
			continue
		map.build_meshes()
	return


func _on_skill_level_item_selected(index):
	Global.skill_level = index
	return


func _on_actor_creator_pressed():
	#for c in $Worlds.get_children():
		#c.queue_free()
	var actor_creator: Control = load("res://Scenes/actor_creator.tscn").instantiate()
	self.add_child(actor_creator)
	return

func restart_level():
	load_predefined()
	return


func _on_tutorial_level_pressed():
	Engine.time_scale = 1.0
	for world in world_container.get_children():
		world.free()
	await get_tree().process_frame
	predefined_scene = load(tutorial_scene_fpath).instantiate()
	world_container.add_child(predefined_scene)
	self.hide()
	return


func _on_play_pressed():
	Engine.time_scale = 1.0
	for world in world_container.get_children():
		world.free()
	await get_tree().process_frame
	predefined_scene = load(play_scene_fpath).instantiate()
	world_container.add_child(predefined_scene)
	self.hide()
	return


func _on_demo_map_pressed():
	Engine.time_scale = 1.0
	for world in world_container.get_children():
		world.free()
	await get_tree().process_frame
	predefined_scene = load(demo_scene_fpath).instantiate()
	world_container.add_child(predefined_scene)
	self.hide()
	return
