extends Node3D

#@export var spawn_open: bool = false
@onready var door: Node3D = get_parent()
@onready var hinge: Node3D = get_parent().get_parent()
@export var opened_angle: float = 90
@export var is_breakable: bool = false
@export var health: int = 45
var last_hit_pos: Vector3 = Vector3.ZERO
#var post_init_timer: Timer
var original_hinge_rotation: Vector3
var sound_door_opening_res: Resource = preload("res://Audio/Items/door_opening.ogg")
var sound_door_closing_res: Resource = preload("res://Audio/Items/door_closing.ogg")
var sound_door_shaking_res: Resource = preload("res://Audio/Items/door_shaking2.ogg")

var sound_door_opening: AudioStreamPlayer3D
var sound_door_closing: AudioStreamPlayer3D
var sound_door_shaking: AudioStreamPlayer3D

enum door_states {
	OPEN_OUT,
	CLOSED,
	OPEN_IN,
}
var door_state: int = door_states.CLOSED

@export var is_locked: bool = false
@export var key: String = ""
@export var targetgroup: String = ""
var ready_executed: bool = false

func _ready():
	prints(self.name, "READY")
	self.add_to_group("interactables")
	self.add_to_group("world_inits")
	self.add_to_group("kickable_doors")
	self.add_to_group("doors")
	if is_breakable and is_instance_of(self, StaticBody3D):
		self.add_to_group("hit_takers")
	sound_door_opening = AudioStreamPlayer3D.new()
	sound_door_closing = AudioStreamPlayer3D.new()
	sound_door_shaking = AudioStreamPlayer3D.new()
	
	self.add_child(sound_door_opening)
	self.add_child(sound_door_closing)
	self.add_child(sound_door_shaking)
	
	sound_door_opening.global_position = self.global_position
	sound_door_closing.global_position = self.global_position
	sound_door_shaking.global_position = self.global_position
	
	sound_door_opening.stream = sound_door_opening_res
	sound_door_closing.stream = sound_door_closing_res
	sound_door_shaking.stream = sound_door_shaking_res
	
	
	ready_executed = true
	#if spawn_open:
		#post_init_timer = Timer.new()
		#self.add_child(post_init_timer)
		#post_init_timer.wait_time = 1.0
		#post_init_timer.timeout.connect(_post_init_timer_timedout)
		#post_init_timer.start()
	return

func read_key_prop(datastring: String):
	var propsign: String = "#"
	var flat_datastring: String = datastring.to_lower()
	var keyprop_text: String = propsign + "key="
	if not flat_datastring.contains(keyprop_text):
		return ""
	
	var keypiece_raw: String = flat_datastring.split(keyprop_text)[1]
	var dash_position: int = keypiece_raw.findn("-")
	var propsign_position: int = keypiece_raw.findn(propsign)
	
	#if dash_position == -1 and propsign_position == -1:
		#return flat_datastring
	#elif dash_position == -1 and propsign_position > -1:
		#return flat_datastring.split(propsign)[0]
	#elif dash_position > -1 and propsign_position == -1:
		#return flat_datastring.split("-")[0]

	if dash_position == -1 and propsign_position == -1:
		return keypiece_raw
	elif dash_position == -1 and propsign_position > -1:
		return keypiece_raw.split(propsign)[0]
	elif dash_position > -1 and propsign_position == -1:
		return keypiece_raw.split("-")[0]

	return

func read_targetgroup_prop(datastring: String):
	var propsign: String = "#"
	var flat_datastring: String = datastring.to_lower()
	var groupprop_text: String = propsign + "targetgroup="
	if not flat_datastring.contains(groupprop_text):
		return ""
	
	var grouppiece_raw: String = flat_datastring.split(groupprop_text)[1]
	var dash_position: int = grouppiece_raw.findn("-")
	var propsign_position: int = grouppiece_raw.findn(propsign)
	
	if dash_position == -1 and propsign_position == -1:
		return grouppiece_raw
	elif dash_position == -1 and propsign_position > -1:
		return grouppiece_raw.split(propsign)[0]
	elif dash_position > -1 and propsign_position == -1:
		return grouppiece_raw.split("-")[0]
	
	return

func interact(caller: Object = null):
	
	#var caller_doorkeys: Array = caller.get("door_keys")
	var caller_doorkeys: Array
	if caller:
		caller_doorkeys = caller.get("door_keys") if caller.get("door_keys") else []
	if caller_doorkeys and key and key in caller_doorkeys:
		is_locked = false
	
	if is_locked:
		sound_door_shaking.play()
		return
	
	if not original_hinge_rotation:
		original_hinge_rotation = hinge.global_rotation
	
	var final_rotation: float
	match door_state:
		door_states.OPEN_OUT:
			final_rotation = original_hinge_rotation.y
			door_state = door_states.CLOSED
			sound_door_closing.play()
		
		door_states.OPEN_IN:
			final_rotation = original_hinge_rotation.y
		
		door_states.CLOSED:
			final_rotation = original_hinge_rotation.y
			final_rotation = hinge.global_rotation_degrees.y + opened_angle
			door_state = door_states.OPEN_OUT
			sound_door_opening.play()
	
	var t = get_tree().create_tween()
	var rot_duration: float = .25
	t.tween_property(hinge, "global_rotation_degrees:y", final_rotation, rot_duration)
	if is_instance_of(self, StaticBody3D):
		var colshape: CollisionShape3D = self.get_node("CollisionShape3D")
		colshape.disabled = true
		await get_tree().create_timer(rot_duration).timeout
		colshape.disabled = false
	
	
	return


func activate(caller: Object = null):
	#if caller and caller.name.to_lower().contains("padlock"):
	if caller and caller.is_in_group("door_unlockers"):
		is_locked = false
	#prints("Activating", self.name, "with parent", self.get_parent().name, "from caller", caller, caller.name)
	interact()
	return

func _on_world_ready():
	key = read_key_prop(door.name)
	
	if key:
		is_locked = true
	
	prints(self.name, door.name)
	if door.name.contains("#"):
		#var opened_angle_overwrite: String = U.read_propstring(door.name)
		var doorprops: Dictionary = U.read_propstring(door.name)
		if doorprops.has("opened_angle"):
			var opened_angle_overwrite: float = float(doorprops["opened_angle"])
			opened_angle = opened_angle_overwrite
	
	targetgroup = read_targetgroup_prop(door.name)
	if targetgroup:
		self.add_to_group(targetgroup)
	prints(door.name, targetgroup)
	return

func _init():
	# This is just _ready() copied
	if ready_executed: return
	
	self.add_to_group("interactables")
	self.add_to_group("world_inits")
	sound_door_opening = AudioStreamPlayer3D.new()
	sound_door_closing = AudioStreamPlayer3D.new()
	sound_door_shaking = AudioStreamPlayer3D.new()
	
	self.add_child(sound_door_opening)
	self.add_child(sound_door_closing)
	self.add_child(sound_door_shaking)
	
	sound_door_opening.global_position = self.global_position
	sound_door_closing.global_position = self.global_position
	sound_door_shaking.global_position = self.global_position
	
	sound_door_opening.stream = sound_door_opening_res
	sound_door_closing.stream = sound_door_closing_res
	sound_door_shaking.stream = sound_door_shaking_res
	
	return

#func _post_init_timer_timedout():
	#if spawn_open:
		#interact()
	#return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3) -> void:
	sound_door_shaking.play()
	health -= damage
	
	if health < 1:
		kill_door()
		return
	last_hit_pos = hit_pos
	return

func kill_door() -> void:
	# Spawn effect
	var doorbreak_effect: Node3D = load("res://Scenes/doorbreak_effect.tscn").instantiate()
	doorbreak_effect.global_position = last_hit_pos
	doorbreak_effect.global_rotation = door.global_rotation
	Blackboard.current_world.add_child(doorbreak_effect)
	#U.spawn_green_marker(Blackboard.current_world, last_hit_pos, .5)
	doorbreak_effect.activate()
	doorbreak_effect.get_node("GPUParticles3D").global_position = door.global_position
	# Make invisible
	door.visible = false
	# Make nocollide
	self.get_node("CollisionShape3D").disabled = true
	# Wait a second
	await get_tree().create_timer(1.0).timeout
	# Queue free
	door.queue_free()
	return
