@tool
extends Node

@export var run: bool = false:
	set(value):
		if value:
			activate_tool()
			run = false
		else:
			run = value
	get:
		return run

func activate_tool():
	prints(self.name, "activate_tool called")
	var vehicle_root: VehicleBody3D = self.get_parent()
	var car_model: Node3D = self.get_parent().get_node("ggbot_crown_edit")
	# 
	var colliders: Array = []
	
	var nodes_to_remove: Array = []
	for c in car_model.find_children("vehicle_collider"):
		for c_col in c.find_children("*", "CollisionShape3D"):
			c_col.reparent(vehicle_root)
			c_col.owner = vehicle_root
		nodes_to_remove.append(c)
	for n in nodes_to_remove:
		n.queue_free()
	
	var wheels: Dictionary = {}
	for c in car_model.find_children("wheel_*", "VehicleWheel3D"):
		var mesh: MeshInstance3D = c.find_children("*", "MeshInstance3D")[0]
		c.reparent(vehicle_root, true)
		c.owner = vehicle_root
		wheels[c.name] = {
			"wheel": c,
			"mesh": mesh
		}
	for wheel in wheels:
		wheels[wheel]["mesh"].reparent(wheels[wheel]["wheel"])
		wheels[wheel]["mesh"].owner = wheels[wheel]["wheel"]
	return
