extends Node3D

var blast_radius: float = 17.0
var raw_damage: int = 360

func activate(_caller):
	$explode_sound.play()
	for hit_taker in get_tree().get_nodes_in_group("hit_takers"):
		if hit_taker.get("is_dead"):
			continue
		var distance: float = hit_taker.global_position.distance_to(self.global_position)
		if distance > blast_radius:
			continue
		if hit_taker == self:
			continue
		var adjusted_damage: int = snappedi((distance / blast_radius) * raw_damage, 1)
		
		hit_taker.hit(adjusted_damage, U.hit_types.UNDEFINED, null, self.global_position)
		if is_instance_of(hit_taker, CharacterBody3D):
			if hit_taker.has_method("flinch_control"):
				hit_taker.flinch_control()
			hit_taker.velocity.y += 18.0
	
	
	$explosion_static/AnimationPlayer.play("activate")
	$explosion_static.visible = true
	await get_tree().create_timer(1.0).timeout
	$explosion_static.visible = false
	return
