extends Node3D

var actor: CharacterBody3D
var hud_name: String = "Hand"
@export var damage: int = 20 #16
var base_damage: int = damage
var heavy_damage: int = damage + damage + 5
var knockback_force: float = 5.0
@onready var hurt_cooldown: Timer = $hurt_cooldown
var is_hurting: bool = false
var primary_action_type: int = U.primary_action_types.TAP
var is_speed_punching: bool = false

func _ready():
	actor = get_parent().owner
	return

func primary_action(caller, action_type):
	hurt_area([caller], damage)
	return

func mod_action(caller):
	hurt_area([caller], heavy_damage)
	return

func stop_action(caller, action_type):
	return

func reload(caller):
	print("I am a fist, nothing to reload.")
	return


func _on_hurt_timer_timeout():
	is_hurting = false
	return

func hurt_area(nodes_to_exclude: Array[Object], damage_amount: int):
	for body in $Area3D.get_overlapping_bodies():
		if body.is_in_group("hit_takers"):
			var hit_taker: Object = body
			if hit_taker in nodes_to_exclude:
				continue
			
			var adjusted_damage: int = damage_amount
			if is_speed_punching:
				adjusted_damage = int(damage_amount * .8)
			#hit_taker.hit(adjusted_damage, U.hit_types.UNDEFINED, actor, Vector3.ZERO)
			hit_taker.hit(adjusted_damage, U.hit_types.AREA, actor, Vector3.ZERO)
			if is_instance_of(hit_taker, CharacterBody3D) and "health" in hit_taker and hit_taker.health < 1:
				actor._hit_taker_died(hit_taker)
			
			if is_instance_of(hit_taker, CharacterBody3D):
				actor._punch_landed(hit_taker)
			
			var is_heavy_punch: bool = damage_amount > base_damage
			
			if not is_heavy_punch:
				var max_pitch: float = .8 if not is_speed_punching else 1.1
				var min_pitch: float = .6 if not is_speed_punching else 0.9
				$punched_sound.pitch_scale = randf_range(min_pitch, max_pitch)
				$punched_sound.play()
			elif is_heavy_punch:
				$heavy_punched_sound.play()
		
		if is_instance_of(body, RigidBody3D) and not body.is_in_group("droppables"):
			if body.is_in_group("glass_cells"):
				$punched_sound.play()
				body.blowout()
			var collider: RigidBody3D = body
			var applied_impulse: Vector3 = (
				Vector3(0, 0.8, 2).rotated(Vector3.UP, self.global_rotation.y) * knockback_force
			)
			collider.apply_central_impulse(applied_impulse)
	return

