extends Control

@onready var world_container: Node3D = $Worlds
@onready var black_rect: ColorRect = $black_rect
var active_scene: Node

func _ready():
	black_rect.visible = true
	
	# Figure out what we're loading.
	# New game? Loading a save?
	# Probably just always load from a global
	# like "current_game_scene", set it from the menu
	await get_tree().process_frame
	set_active_scene(Director.current_scene_path)
	return

func set_active_scene(new_scene_path: String):
	if active_scene:
		#active_scene.disconnect("scene_ended", _active_scene_ended)
		active_scene.queue_free()
		await get_tree().process_frame
		await get_tree().process_frame
	Engine.time_scale = 1.0
	var scene_instance: Node = load(new_scene_path).instantiate()
	
	world_container.add_child(scene_instance)
	scene_instance.connect("scene_ended", _active_scene_ended)
	active_scene = scene_instance
	prints(self.name, "# -- #", active_scene.get_groups())
	prints(self.name, "active_scene:", active_scene.name)
	prints(self.name, self.get_node("Worlds").get_children())
	if not OS.has_feature("editor"):
		prints(self.name, "Not editor")
		if active_scene.find_child("Map"):
			prints(self.name, "INTENT to call _init_in_tree on active_scene")
			active_scene._init_in_tree()
	fade_in()
	await active_scene.ready
	
	for run_trigger in Director.run_on_load:
		run_trigger["node"].call(run_trigger["method"])
	return

func black_out():
	black_rect.visible = true
	black_rect.color = Color(0, 0, 0, 1)
	return

func fade_in():
	black_rect.visible = true
	var fade_time: float = .5
	get_tree().create_tween().tween_property(
		black_rect,
		"color",
		Color(0, 0, 0, 0),
		fade_time
	)
	return

func _active_scene_ended():
	prints(self.name, "Detected scene end.")
	#set_active_scene(Director.next_scene())
	var next_scene: String = Director.next_scene()
	if next_scene.contains("main_menu.tscn"):
		Director.reset()
		get_tree().change_scene_to_file(next_scene)
		return
	else:
		set_active_scene(next_scene)
	black_out()
	await get_tree().process_frame
	fade_in()
	return

func restart_level():
	# May have more logic in the future
	# but for now just kill it and make a new one
	set_active_scene(Director.current_scene_path)
	return

func restart_game():
	get_tree().change_scene_to_file("res://Scenes/resource_loader_box.tscn")
	return
