@tool
extends Node3D

@export var key: String = ""
@export var is_locked: bool = false
@export var tb_flat_axis: String = "x"
@export var hinge_side: String = "a"

# To keep it simple you're going to have a few standard door sizes
# Tried material swapping but the textures do not align.
# Swapping the mesh as a resource does work fine.
# So just make it an option for which kind of door,
# then instance the correct mesh in editor or at runtime if you're desperate
# - One hinge side will be z scale 1, the other will be z scale -1
# - One tb_flat_axis will be x, the other will be y. If you need a trap door at z... I don't know?

func _ready():
	return

func _editor_ready():
	if not Engine.is_editor_hint(): return
	
	await get_parent().ready
	for child in self.get_children():
		print(child.name)
		if child.name.begins_with("entity_"):
			child.free()
	return
