extends StaticBody3D


#@onready var lame_glass_shard: MeshInstance3D = $lame_glass_shard
@onready var lame_glass_shards: Array = self.find_children("lame_glass_shard_*")
@onready var full_cell: MeshInstance3D = $full_cell
@onready var splash_area: Area3D = $splash_area
@onready var floor_check: RayCast3D = $floor_check
@onready var glass_sounds: Array = self.find_children("glass_sound_*")
@onready var debug_lights: Array = self.find_children("debug_light*")
var rigid_glass_cell_master: PackedScene = preload("res://Scenes/glass_cell.tscn")
var active_gravity_scale: float = 1.0
var velo_threshold_sq: float = 5.0 # 50.0 # 50.0 worked great except on the mp5t_9mm, I suspect the force was too low to register.
var latest_physics_state: PhysicsDirectBodyState3D
var modified_velocity: Vector3 = Vector3.ZERO
@export var spawn_and_freeze: bool = true
@export var convert_on_hit: bool = false
@export var never_separate: bool = false
@export var hard_floor: bool = false
var is_spawned: bool = false
var is_separated: bool = false
var is_in_grid: bool = false
var travel_dist_sq: float = 0.0
var separated_dist_sq: float = 0.50 # 1.0
var milkyway_dist_sq: float = 1500.0
var original_origin: Vector3 = Vector3.ZERO
var is_ever_active: bool = false
var is_ever_impacted: bool = false
var is_area_activated: bool = false
var is_performing_float_check: bool = false
var area_cooloff: float = 1.50
var area_ticker: float = 0.0
var recent_nearby_cells: Array = []
var available_rotations: Array = [0.0, 90.0, -90.0, 180.0]
var cells_absorbed: int = 0
var cell_absorb_limit: int = 1
var cell_height: float = 1.0

var last_hit_damage: int = -1
var last_hit_position: Vector3 = Vector3.ZERO

enum break_effect_types {
	DROP,
	TREADMILL_FALL,
	EXPLODE
}

func _ready() -> void:
	floor_check.add_exception(self)
	
	original_origin = self.global_position
	for lame_glass_shard in lame_glass_shards:
		if (U.coin_flip() and U.coin_flip()):
			lame_glass_shard.rotation_degrees.z = randf_range(0.0, 180.0)
		else:
			var new_rotation: float = available_rotations.pick_random()
			lame_glass_shard.rotation_degrees.z = new_rotation
			available_rotations.erase(new_rotation)
		lame_glass_shard.mesh.left_to_right = [0.0, 0.5, 1.0].pick_random()
	
	if spawn_and_freeze:
		pass
	
	is_spawned = true
	if U.coin_flip():
		full_cell.visible = false
	return

func _physics_process(delta: float) -> void:
	travel_dist_sq = self.global_position.distance_squared_to(original_origin)
	
	
	if area_ticker > 0.0:
		for b in splash_area.get_overlapping_bodies():
			if not recent_nearby_cells.has(b):
				recent_nearby_cells.append(b)
			if b.is_in_group("glass_cells"):
				if (U.coin_flip() and U.coin_flip()):
					b.set_as_separated()
					continue
				if U.coin_flip():
					#b.full_cell.visible = false
					full_cell.transparency *= 4.6
					continue
		area_ticker -= delta
		if area_ticker <= 0.0:
			area_ticker = 0.0
			splash_area.monitoring = false
			if recent_nearby_cells.size() == 0:
				is_separated = true
	
	if travel_dist_sq > milkyway_dist_sq:
		self.queue_free()
		return
	
	if not is_separated and travel_dist_sq >= separated_dist_sq:
		set_as_separated()
		return
	
	return

func _on_sleeping_state_changed() -> void:
	if is_separated:
		return
	
	#if linear_velocity.length_squared() > velo_threshold_sq: # and (U.coin_flip() and U.coin_flip()):
	if last_hit_damage > 0:
		
		if convert_on_hit:
			convert_to_rigidbody()
		else:
			if is_in_grid:
				for cell in get_grid().cells:
					if not cell:
						continue
					floor_check.add_exception(cell)
			break_cell_effect(break_effect_types.DROP)
		
		is_ever_impacted = true
		if is_in_grid:
			get_grid()._cell_impacted(self)
		
		var glass_sound: AudioStreamPlayer3D = glass_sounds.pick_random()
		glass_sound.pitch_scale = randf_range(.95, 1.05)
		glass_sound.play()
		
		return
		#############################
		#splash_area.monitoring = true
		#area_ticker = area_cooloff
		#
		#tilt_area()
		###################
		
		#full_cell.visible = false
	else:
		await get_tree().create_timer(.02).timeout
		if not is_separated:
			##sleeping = true
			pass
	
	if rotation_degrees.length_squared() > 1.0:
		#full_cell.visible = false
		full_cell.transparency *= 4.6
	return

func _on_float_check_timer_timeout() -> void:
	if is_separated:
		return
	
	if is_performing_float_check:
		return
	
	is_performing_float_check = true
	splash_area.monitoring = true
	await get_tree().create_timer(.1).timeout
	
	var bodies: Array = splash_area.get_overlapping_bodies()
	bodies.erase(self)
	
	if bodies.size() == 0:
		set_as_separated()
	
	#if bodies.size() > 0 and travel_dist_sq > 0.1:
		#var absorb_candidate: PhysicsBody3D = bodies.pick_random()
		#if absorb_candidate.is_in_group("glass_cells"):
			#absorb_cell(absorb_candidate)
	
	is_performing_float_check = false
	return

func set_as_separated() -> void:
	if is_separated:
		return
	
	if never_separate:
		return
		
	if $debug_label.visible:
		$debug_label.text = "<-s->"
		$debug_label.outline_modulate = Color.WHITE
	
	if not is_ever_impacted:
		self.hit(1, U.hit_types.AREA, null, self.global_position)
		return
	
	get_grid()._cell_impacted(self)
	is_separated = true
	full_cell.visible = false
	#lame_glass_shards.pick_random().visible = false
	
	for actor in get_tree().get_nodes_in_group("actors"):
		self.add_collision_exception_with(actor)
	
	await get_tree().create_timer(5.2).timeout
	process_mode = Node.PROCESS_MODE_DISABLED
	return

func absorb_cell(cell_node: RigidBody3D) -> void:
	#if cell_node.is_separated:
		#return
	if not cell_node:
		return
	
	if cells_absorbed >= cell_absorb_limit:
		return
	
	var new_children: Array = []
	new_children.append(cell_node.get_node("CollisionShape3D"))
	new_children.append_array(cell_node.lame_glass_shards)
	for new_child in new_children:
		new_child.reparent(self)
	
	cells_absorbed += 1
	cell_node.queue_free()
	return

func blink_debug_lights(blink_color: Color = Color.GREEN) -> void:
	#for debug_light in debug_lights:
		#debug_light.visible = true
	debug_lights.map(func (node): node.visible = true)
	await get_tree().create_timer(.1).timeout
	debug_lights.map(func (node): node.visible = false)
	await get_tree().create_timer(.1).timeout
	debug_lights.map(func (node): node.visible = true)
	await get_tree().create_timer(.1).timeout
	debug_lights.map(func (node): node.visible = false)
	return

func tilt_area() -> void:
	splash_area.rotation_degrees.z += randf_range(-90, 90)
	var colliders: Array = [$CollisionShape3D, $splash_area/asym_collider]
	var collider_i: int = [0, 1].pick_random()
	if collider_i == 0:
		colliders[0].disabled = false
		colliders[1].disabled = true
	elif collider_i == 1:
		colliders[0].disabled = true
		colliders[1].disabled = false
	
	return

func blowout(caller: Object = null) -> void:
	var colliders: Array = splash_area.find_children("*", "CollisionShape3D")
	var collider_states: Dictionary = {}
	for collider in colliders:
		collider_states[collider] = collider.disabled
		if collider.name.contains("blowout"):
			collider.disabled = false
		else:
			collider.disabled = true
	
	await get_tree().process_frame
	
	var splash_candidates: Array = splash_area.get_overlapping_bodies()
	if caller:
		if is_instance_of(caller, PhysicsBody3D):
			for b in splash_candidates:
				if not is_instance_of(b, RigidBody3D):
					continue
				b.add_collision_exception_with(caller)
				await get_tree().process_frame
	
	await get_tree().process_frame
	for b in splash_candidates:
		if not b.is_in_group("glass_cells"):
			continue
		if b == self:
			continue
		if not is_instance_of(b, RigidBody3D):
			continue
		
		var cell_dist_sq: float = b.global_position.distance_squared_to(self.global_position)
		var blowout_force: float = 88.2 * cell_dist_sq
		var blowout_vec: Vector3 = b.global_position - self.global_position
		if is_in_grid:
			if get_grid().is_floor:
				blowout_vec.y += randf_range(0.0, 15.0)
		b.apply_central_impulse(blowout_vec * blowout_force)
		b.apply_torque_impulse(Vector3.ONE * blowout_force)
	
	for collider in colliders:
		collider.disabled = collider_states[collider]
	return

func get_grid() -> Node3D:
	return self.get_parent().get_parent()

func toggle_colliders(toggle: bool) -> void:
	if toggle == true:
		$CollisionShape3D.disabled = false
	elif toggle == false:
		$CollisionShape3D.disabled = true
	return

func play_glass_sound() -> void:
	var glass_sound: AudioStreamPlayer3D = glass_sounds.pick_random()
	glass_sound.pitch_scale = randf_range(.95, 1.05)
	glass_sound.play()
	return

func hit(damage: int, hit_type: int, caller: PhysicsBody3D, hit_pos: Vector3):
	last_hit_damage = damage
	last_hit_position = hit_pos
	if caller:
		floor_check.add_exception(caller)
	_on_sleeping_state_changed()
	return

func convert_to_rigidbody() -> void:
	var new_rigid_cell: RigidBody3D = rigid_glass_cell_master.instantiate()
	#Blackboard.current_world.add_child(new_rigid_cell)
	if is_in_grid:
		get_grid().get_node("anchor").add_child(new_rigid_cell)
	new_rigid_cell.global_position = self.global_position
	new_rigid_cell.global_rotation = self.global_rotation
	self.visible = false
	new_rigid_cell.visible = true
	if is_in_grid:
		var grid_index: int = get_grid().cells.find(self)
		get_grid().cells.erase(self)
		get_grid().cells.insert(grid_index, new_rigid_cell)
		#if get_grid().is_floor:
		new_rigid_cell.process_mode = Node.PROCESS_MODE_DISABLED
	self.queue_free()
	return

func break_cell_effect(effect_type: break_effect_types) -> void:
	match effect_type:
		break_effect_types.DROP:
			effect_drop_cell()
			return
		break_effect_types.TREADMILL_FALL:
			effect_treadmill_fall()
			return
		break_effect_types.EXPLODE:
			effect_explode()
			return
	return

func effect_drop_cell():
	# Just ease out and drop to the floor
	var chosen_shard: MeshInstance3D = lame_glass_shards.pick_random()
	for shard in lame_glass_shards:
		if shard == chosen_shard:
			shard.visible = true
		else:
			shard.visible = false
	
	# Where is the floor?
	floor_check.reparent(Blackboard.current_world)
	floor_check.rotation_degrees = Vector3.ZERO
	
	floor_check.enabled = true
	await get_tree().process_frame
	var floor_collider: Object = floor_check.get_collider()
	var floor_y: float = -17.0
	if floor_collider and not floor_collider.is_in_group("glass_cells"):
		floor_y = floor_check.get_collision_point().y
	
	
	var fall_vector: Vector3 = Vector3(
		randf_range(-0.6, 0.6),
		floor_y,
		randf_range(-1.6, 1.6) # randf_range(-0.6, 0.6)
	) + self.global_position
	var fall_rot: Vector3 = Vector3(
		randf_range(-180, 180),
		randf_range(-180, 180),
		randf_range(-180, 180)
	)
	var fall_unitpersec: float = 12.0 # 3.0 # 3.0 is too slow
	var fall_time: float = absf(floor_y) / fall_unitpersec
	
	get_tree().create_tween().tween_property(
		self,
		"rotation_degrees",
		fall_rot,
		fall_time * 1.5
	).set_ease(Tween.EASE_OUT)
	
	get_tree().create_tween().tween_property(
		self,
		"global_position",
		fall_vector,
		fall_time
	)
	
	await get_tree().create_timer(fall_time).timeout
	floor_check.enabled = false
	self.visible = false
	process_mode = Node.PROCESS_MODE_DISABLED
	return

func effect_treadmill_fall():
	# Rotate X a lot, Z and Y a little bit, linear drop to the floor
	var chosen_shard: MeshInstance3D = lame_glass_shards.pick_random()
	for shard in lame_glass_shards:
		if shard == chosen_shard:
			shard.visible = true
		else:
			shard.visible = false
	
	return

func effect_explode():
	# Each shard, random fly in different direction
	return


func break_towards(fall_vector: Vector3 = Vector3.ZERO, fall_rot: Vector3 = Vector3.ZERO) -> void:
	# Just ease out and drop to the floor
	var chosen_shard: MeshInstance3D = lame_glass_shards.pick_random()
	for shard in lame_glass_shards:
		if shard == chosen_shard:
			shard.visible = true
		else:
			shard.visible = false
	
	
	
	if not fall_rot:
		fall_rot = Vector3(
			randf_range(-180, 180),
			randf_range(-180, 180),
			randf_range(-180, 180)
		)
	var fall_unitpersec: float = 12.0 # 3.0 # 3.0 is too slow
	#var fall_time: float = absf(floor_y) / fall_unitpersec
	var fall_time: float = absf(self.global_position.distance_to(fall_vector)) / fall_unitpersec
	
	get_tree().create_tween().tween_property(
		self,
		"rotation_degrees",
		fall_rot,
		fall_time * 1.5
	).set_ease(Tween.EASE_OUT)
	
	get_tree().create_tween().tween_property(
		self,
		"global_position",
		fall_vector,
		fall_time
	)
	
	await get_tree().create_timer(fall_time).timeout
	floor_check.enabled = false
	self.visible = false
	process_mode = Node.PROCESS_MODE_DISABLED
	return
