extends CharacterBody3D

const SPEED = 5.0
const JUMP_VELOCITY = 4.5

@export var health: int = 50

var gravity = (ProjectSettings.get_setting("physics/3d/default_gravity") * 6)

@onready var grunt_brain: Node = $grunt_brain
@onready var anim: AnimationPlayer = $graphics/grunt/AnimationPlayer
@onready var hit_sound: AudioStreamPlayer3D = $Sound/hit_sound
@onready var rhand: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_rhand/anchor
@onready var lhand: Node3D = $graphics/grunt/Armature/Skeleton3D/attach_lhand/anchor
@onready var eyes: Node3D = $eyes
@onready var vision_area: Area3D = $vision_area
@onready var anim_timer: Timer = $anim_timer
@onready var debug_label: Label3D = $debug_label
var actor_target: CharacterBody3D
var anim_locked: bool = false
var is_dead: bool = false
var last_anim: String = ""

func ready():
	return

func _physics_process(delta):
	apply_gravity(delta)
	
	move_and_slide()
	debug_label.text = str(health)

func apply_gravity(delta):
	# Add the gravity.
	if not is_on_floor():
		velocity.y -= gravity * delta
	return


func apply_jump():
	# Handle Jump.
	velocity.y = JUMP_VELOCITY
	return

func apply_move(input_dir: Vector2):
	# Get the input direction and handle the movement/deceleration.
	# As good practice, you should replace UI actions with custom gameplay actions.
	# var input_dir = Input.get_vector("ui_left", "ui_right", "ui_up", "ui_down")
	var direction = (transform.basis * Vector3(input_dir.x, 0, input_dir.y)).normalized()
	if direction:
		velocity.x = direction.x * SPEED
		velocity.z = direction.z * SPEED
	else:
		velocity.x = move_toward(velocity.x, 0, SPEED)
		velocity.z = move_toward(velocity.z, 0, SPEED)
	return

func look_towards(target_position: Vector3, turn_speed: float):
	# This could probably be done with tween, without the eyes node
	eyes.look_at(target_position, Vector3.UP, true)
	self.rotation.x = (eyes.rotation.x * .9)
	self.rotate_y(eyes.rotation.y * turn_speed)
	return

func anim_h(anim_name: String = "", force_anim: bool = false, duration: float = 0.0):
	if anim_name == "":
		return
	
	if anim_locked and not force_anim:
		return
	
	if force_anim:
		anim.seek(0)
		anim.stop()
	
	if duration > 0:
		anim_timer.wait_time = duration
		anim_locked = true
		anim_timer.start()

	else:
		anim_timer.wait_time = 1
	
	anim.play(anim_name)
	last_anim = anim_name
	return


func _on_anim_timer_timeout():
	anim_locked = false
	return
