extends StaticBody3D

var is_dryer_running: bool = false

# Called when the node enters the scene tree for the first time.
func _ready():
	return


func interact(caller: Node = null):
	if is_dryer_running:
		$AudioStreamPlayer3D.stop()
		$AudioStreamPlayer3D.volume_db = -40.0
		$AudioStreamPlayer3D.pitch_scale = 1.0
		is_dryer_running = false
	else:
		get_tree().create_tween().tween_property($AudioStreamPlayer3D, "volume_db", 0.0, 1.0)
		get_tree().create_tween().tween_property($AudioStreamPlayer3D, "pitch_scale", 1.2, 1.0)
		$AudioStreamPlayer3D.play()
		is_dryer_running = true
	return
