extends StaticBody3D

signal taken

@export_enum("blue", "red", "black") var card_color: String = "black"
var spawn_light_energy: float = 0.0
var shine_color: Color
var is_shining: bool = false
var ticker_interval: float = 1.00
var accumulated_tick: float = 0.0
var is_taken: bool = false

var time_to_die: float = 3.0

# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	#$editor_viewmesh.visible = false
	$editor_viewmesh.queue_free()
	spawn_light_energy = $OmniLight3D.light_energy
	$OmniLight3D.light_energy = 0.0
	for mesh in self.find_children("keycard_*"):
		mesh.visible = false
	match card_color:
		"blue":
			$cinf_keycard/keycard_blue.visible = true
			shine_color = Color.BLUE
			$OmniLight3D.light_color = shine_color
		"red":
			$cinf_keycard/keycard_red.visible = true
			shine_color = Color.RED
			$OmniLight3D.light_color = shine_color
		"black":
			$cinf_keycard/keycard_black.visible = true
			shine_color = Color.WHITE
			$OmniLight3D.light_color = shine_color
			$OmniLight3D.light_negative = true
	return


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta: float) -> void:
	accumulated_tick += delta
	if accumulated_tick >= ticker_interval:
		var assumed_player: Node3D = get_tree().get_first_node_in_group("players")
		var player_dist_sq: float = self.global_position.distance_squared_to(assumed_player.global_position)
		if $debug_label.visible: $debug_label.text = str(player_dist_sq)
		if player_dist_sq < 35.0:
			set_as_shining(true)
		else:
			set_as_shining(false)
	return

func interact(caller: Object) -> void:
	if is_taken:
		return
	if not caller.has_method("add_doorkey"):
		return
	taken.emit()
	caller.add_doorkey("keycard_" + card_color)
	is_taken = true
	$AudioStreamPlayer3D.play()
	self.visible = false
	await get_tree().create_timer(time_to_die + .1).timeout
	self.queue_free()
	return

func set_as_shining(toggle: bool) -> void:
	var trans_time: float = .6 # 1.0
	if toggle:
		if not is_shining:
			is_shining = true
			get_tree().create_tween().tween_property($OmniLight3D, "light_energy", spawn_light_energy, trans_time)
	else:
		if is_shining:
			is_shining = false
			get_tree().create_tween().tween_property($OmniLight3D, "light_energy", 0.0, trans_time)
	return
